/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeLintOptions;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.lint.AndroidLintIdeClient;
import com.android.tools.idea.lint.AndroidLintIdeIssueRegistry;
import com.android.tools.idea.lint.AndroidLintIdeProject;
import com.android.tools.idea.lint.AndroidLintMissingConstraintsInspection;
import com.android.tools.idea.lint.LintIdeAnalytics;
import com.android.tools.idea.lint.ProvideLintFeedbackFix;
import com.android.tools.idea.lint.ProvideLintFeedbackIntentionAction;
import com.android.tools.idea.lint.ProvideLintFeedbackPanel;
import com.android.tools.idea.lint.common.LintBatchResult;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintResult;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.res.AndroidFileChangeListener;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioSdkUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.utils.SdkUtils;
import com.google.wireless.android.sdk.stats.LintSession;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.groovy.GroovyFileType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J?\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00132\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001b2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100!\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\"J.\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0$2\u0006\u0010\u001d\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010%\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u001e\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020/\u0018\u00010.2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\"\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002092\u0006\u00106\u001a\u000207H\u0016J\u001a\u0010:\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u0002012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010;\u001a\u00020<H\u0016\u00a8\u0006>"}, d2={"Lcom/android/tools/idea/lint/AndroidLintIdeSupport;", "Lcom/android/tools/idea/lint/common/LintIdeSupport;", "()V", "askForAttributeValue", "", "attributeName", "context", "Lcom/intellij/psi/PsiElement;", "canAnalyze", "", "project", "Lcom/intellij/openapi/project/Project;", "canAnnotate", "file", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "canRequestFeedback", "createBatchClient", "Lcom/android/tools/idea/lint/common/LintIdeClient;", "lintResult", "Lcom/android/tools/idea/lint/common/LintBatchResult;", "createClient", "Lcom/android/tools/idea/lint/common/LintResult;", "createEditorClient", "Lcom/android/tools/idea/lint/common/LintEditorResult;", "createProject", "", "Lcom/android/tools/lint/detector/api/Project;", "client", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "modules", "", "(Lcom/android/tools/idea/lint/common/LintIdeClient;Ljava/util/List;[Lcom/intellij/openapi/module/Module;)Ljava/util/List;", "createProjectForSingleFile", "Lcom/intellij/openapi/util/Pair;", "ensureNamespaceImported", "Lcom/intellij/psi/xml/XmlFile;", "namespaceUri", "suggestedPrefix", "getBaselineFile", "Ljava/io/File;", "getIssueRegistry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "getSeverityOverrides", "", "", "logSession", "", "lint", "Lcom/android/tools/lint/client/api/LintDriver;", "requestFeedbackFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "requestFeedbackIntentionAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "resolveDynamic", "gc", "Lcom/android/ide/common/repository/GradleCoordinate;", "updateToLatest", "intellij.android.core"})
public final class AndroidLintIdeSupport
extends LintIdeSupport {
    @NotNull
    public IssueRegistry getIssueRegistry() {
        return (IssueRegistry)new AndroidLintIdeIssueRegistry();
    }

    @Nullable
    public File getBaselineFile(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
        if (androidModuleModel == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)androidModuleModel, (String)"AndroidModuleModel.get(module) ?: return null");
        AndroidModuleModel model2 = androidModuleModel;
        GradleVersion gradleVersion2 = model2.getModelVersion();
        if (gradleVersion2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"model.modelVersion ?: return null");
        GradleVersion version2 = gradleVersion2;
        if (version2.isAtLeast(2, 3, 1)) {
            IdeAndroidProject ideAndroidProject = model2.getAndroidProject();
            Intrinsics.checkNotNullExpressionValue((Object)ideAndroidProject, (String)"model.androidProject");
            IdeLintOptions options = ideAndroidProject.getLintOptions();
            try {
                File baselineFile = options.getBaselineFile();
                if (baselineFile != null) {
                    return baselineFile;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Map<String, Integer> getSeverityOverrides(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
        if (androidModuleModel == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)androidModuleModel, (String)"AndroidModuleModel.get(module) ?: return null");
        AndroidModuleModel model2 = androidModuleModel;
        GradleVersion gradleVersion2 = model2.getModelVersion();
        if (gradleVersion2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"model.modelVersion ?: return null");
        GradleVersion version2 = gradleVersion2;
        if (version2.isAtLeast(2, 3, 1)) {
            IdeAndroidProject ideAndroidProject = model2.getAndroidProject();
            Intrinsics.checkNotNullExpressionValue((Object)ideAndroidProject, (String)"model.androidProject");
            IdeLintOptions options = ideAndroidProject.getLintOptions();
            try {
                return options.getSeverityOverrides();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String askForAttributeValue(@NotNull String attributeName, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)context);
        String message2 = "Specify value of attribute '" + attributeName + '\'';
        String title = "Set Attribute Value";
        if (facet2 != null) {
            AttributeDefinition def;
            AttributeDefinitions attrDefs;
            ModuleResourceManagers moduleResourceManagers = ModuleResourceManagers.getInstance(facet2);
            Intrinsics.checkNotNullExpressionValue((Object)moduleResourceManagers, (String)"ModuleResourceManagers.getInstance(facet)");
            FrameworkResourceManager srm = moduleResourceManagers.getFrameworkResourceManager();
            if (srm != null && (attrDefs = srm.getAttributeDefinitions()) != null && (def = attrDefs.getAttrDefByName(attributeName)) != null) {
                String[] variants;
                String[] stringArray = def.getValues();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"def.values");
                String[] stringArray2 = variants = stringArray;
                boolean bl = false;
                String[] stringArray3 = stringArray2;
                boolean bl2 = false;
                if (!(stringArray3.length == 0)) {
                    return Messages.showEditableChooseDialog((String)message2, (String)title, (Icon)Messages.getQuestionIcon(), (String[])variants, (String)variants[0], null);
                }
            }
        }
        return Messages.showInputDialog((com.intellij.openapi.project.Project)context.getProject(), (String)message2, (String)title, (Icon)Messages.getQuestionIcon());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canAnnotate(@NotNull PsiFile file, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        if (facet2 == null && !AndroidLintIdeProject.hasAndroidModule(module.getProject())) {
            return false;
        }
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"file.fileType");
        FileType fileType2 = fileType;
        if (fileType2 == StdFileTypes.JAVA) return true;
        if (fileType2 == KotlinFileType.INSTANCE) return true;
        if (fileType2 == StdFileTypes.PROPERTIES) {
            return true;
        }
        if (fileType2 == StdFileTypes.XML) {
            if (facet2 == null) return false;
            ModuleResourceManagers moduleResourceManagers = ModuleResourceManagers.getInstance(facet2);
            Intrinsics.checkNotNullExpressionValue((Object)moduleResourceManagers, (String)"ModuleResourceManagers.getInstance(\n        facet)");
            if (moduleResourceManagers.getLocalResourceManager().getFileResourceFolderType(file) != null) return true;
            if (!Intrinsics.areEqual((Object)"AndroidManifest.xml", (Object)file.getName())) return false;
            return true;
        }
        if (fileType2 == FileTypes.PLAIN_TEXT) {
            return super.canAnnotate(file, module);
        }
        if (fileType2 != GroovyFileType.GROOVY_FILE_TYPE) return false;
        if (!SdkUtils.endsWithIgnoreCase((String)file.getName(), (String)".gradle")) {
            return false;
        }
        com.intellij.openapi.project.Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        com.intellij.openapi.project.Project project2 = project;
        if (!AndroidProjectInfo.getInstance(project2).requiresAndroidModel()) return true;
        AndroidFileChangeListener.getInstance(project2);
        return true;
    }

    public boolean canAnalyze(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ProjectFacetManager.getInstance((com.intellij.openapi.project.Project)project).hasFacets(AndroidFacet.ID);
    }

    @NotNull
    public List<Project> createProject(@NotNull LintIdeClient client, @Nullable List<? extends VirtualFile> files2, Module ... modules) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        List<Project> list = AndroidLintIdeProject.create(client, files2, Arrays.copyOf(modules, modules.length));
        Intrinsics.checkNotNullExpressionValue(list, (String)"AndroidLintIdeProject.cr\u2026(client, files, *modules)");
        return list;
    }

    @NotNull
    public Pair<Project, Project> createProjectForSingleFile(@NotNull LintIdeClient client, @Nullable VirtualFile file, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Pair<Project, Project> pair = AndroidLintIdeProject.createForSingleFile(client, file, module);
        Intrinsics.checkNotNullExpressionValue(pair, (String)"AndroidLintIdeProject.cr\u2026ile(client, file, module)");
        return pair;
    }

    @NotNull
    public LintIdeClient createClient(@NotNull com.intellij.openapi.project.Project project, @NotNull LintResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        return new AndroidLintIdeClient(project, lintResult);
    }

    @NotNull
    public LintIdeClient createBatchClient(@NotNull LintBatchResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        return new AndroidLintIdeClient(lintResult.getProject(), (LintResult)lintResult);
    }

    @NotNull
    public LintIdeClient createEditorClient(@NotNull LintEditorResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        return new AndroidLintIdeClient(lintResult.getModule().getProject(), (LintResult)lintResult);
    }

    public void updateToLatest(@NotNull Module module, @NotNull GradleCoordinate gc) {
        GradleCoordinate latest;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        StudioSdkUtil.reloadRemoteSdkWithModalProgress();
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"AndroidSdks.getInstance().tryToChooseSdkHandler()");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(AndroidLintMissingConstraintsInspection.class);
        RepoPackage p = SdkMavenRepository.findLatestVersion((GradleCoordinate)gc, (AndroidSdkHandler)sdkHandler, null, (ProgressIndicator)((ProgressIndicator)progress));
        if (p != null && (latest = SdkMavenRepository.getCoordinateFromSdkPath((String)p.getPath())) != null) {
            GradleDependencyManager gradleDependencyManager = GradleDependencyManager.getInstance(module.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)gradleDependencyManager, (String)"GradleDependencyManager.\u2026tInstance(module.project)");
            GradleDependencyManager manager = gradleDependencyManager;
            manager.updateLibrariesToVersion(module, CollectionsKt.listOf((Object)latest), null);
        }
    }

    @Nullable
    public String resolveDynamic(@NotNull com.intellij.openapi.project.Project project, @NotNull GradleCoordinate gc) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"AndroidSdks.getInstance().tryToChooseSdkHandler()");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        return RepositoryUrlManager.Companion.get().resolveDynamicCoordinateVersion(gc, project, sdkHandler);
    }

    public boolean canRequestFeedback() {
        return ProvideLintFeedbackPanel.canRequestFeedback();
    }

    @NotNull
    public LocalQuickFix requestFeedbackFix(@NotNull Issue issue2) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        return new ProvideLintFeedbackFix(issue2.getId());
    }

    @NotNull
    public IntentionAction requestFeedbackIntentionAction(@NotNull Issue issue2) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        return new ProvideLintFeedbackIntentionAction(issue2.getId());
    }

    public void logSession(@NotNull LintDriver lint, @NotNull LintEditorResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lint, (String)"lint");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        com.intellij.openapi.project.Project project = lintResult.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"lintResult.getModule().project");
        LintIdeAnalytics analytics = new LintIdeAnalytics(project);
        analytics.logSession(LintSession.AnalysisType.IDE_FILE, lint, lintResult.getModule(), lintResult.getProblems(), null);
    }

    public void logSession(@NotNull LintDriver lint, @Nullable Module module, @NotNull LintBatchResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lint, (String)"lint");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        LintIdeAnalytics analytics = new LintIdeAnalytics(lintResult.getProject());
        analytics.logSession(LintSession.AnalysisType.IDE_BATCH, lint, module, null, lintResult.getProblemMap());
    }

    @NotNull
    public String ensureNamespaceImported(@NotNull XmlFile file, @NotNull String namespaceUri, @Nullable String suggestedPrefix) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)namespaceUri, (String)"namespaceUri");
        String string = AndroidResourceUtil.ensureNamespaceImported(file, namespaceUri, suggestedPrefix);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AndroidResourceUtil.ensu\u2026paceUri, suggestedPrefix)");
        return string;
    }
}

