/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.GradleModelConverterUtil;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.projectmodel.ProjectType;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeProject;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Project;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Nullable;

public class AndroidLintIdeProject
extends LintIdeProject {
    AndroidLintIdeProject(LintClient client, File dir, File referenceDir) {
        super(client, dir, referenceDir);
    }

    public static List<Project> create(LintIdeClient client, @Nullable List<VirtualFile> files2, Module ... modules) {
        ArrayList<Project> projects = new ArrayList<Project>();
        HashMap projectMap = Maps.newHashMap();
        HashMap moduleMap = Maps.newHashMap();
        HashMap libraryMap = Maps.newHashMap();
        if (files2 != null && !files2.isEmpty()) {
            files2 = Lists.newArrayList(files2);
        }
        for (Module module : modules) {
            AndroidLintIdeProject.addProjects((LintClient)client, module, files2, moduleMap, libraryMap, projectMap, projects);
        }
        client.setModuleMap((Map)projectMap);
        if (projects.size() > 1) {
            HashSet<Project> roots = new HashSet<Project>(projects);
            for (Project project : projects) {
                roots.removeAll(project.getAllLibraries());
            }
            return Lists.newArrayList(roots);
        }
        return projects;
    }

    public static Pair<Project, Project> createForSingleFile(LintIdeClient client, @Nullable VirtualFile file, Module module) {
        LintIdeProject.LintModuleProject project = AndroidLintIdeProject.createModuleProject((LintClient)client, module);
        LintIdeProject.LintModuleProject main = null;
        HashMap projectMap = Maps.newHashMap();
        if (project != null) {
            Module androidModule;
            project.setDirectLibraries(Collections.emptyList());
            if (file != null) {
                project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
            }
            projectMap.put(project, module);
            if (!project.isAndroidProject() && (androidModule = AndroidLintIdeProject.findAndroidModule(module)) != null && (main = AndroidLintIdeProject.createModuleProject((LintClient)client, androidModule)) != null) {
                projectMap.put(main, androidModule);
                main.setDirectLibraries(Collections.singletonList(project));
            }
        }
        client.setModuleMap((Map)projectMap);
        return Pair.create((Object)project, main);
    }

    @Nullable
    private static Module findAndroidModule(Module module) {
        if (module.isDisposed()) {
            return null;
        }
        Graph graph = (Graph)ApplicationManager.getApplication().runReadAction(() -> {
            com.intellij.openapi.project.Project project = module.getProject();
            return ModuleManager.getInstance((com.intellij.openapi.project.Project)project).moduleGraph();
        });
        if (graph == null) {
            return null;
        }
        HashSet<AndroidFacet> facets = new HashSet<AndroidFacet>();
        HashSet<Module> seen = new HashSet<Module>();
        seen.add(module);
        AndroidLintIdeProject.addAndroidModules(facets, seen, (Graph<Module>)graph, module);
        for (AndroidFacet facet2 : facets) {
            if (!((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) continue;
            return facet2.getModule();
        }
        if (!facets.isEmpty()) {
            return ((AndroidFacet)facets.iterator().next()).getModule();
        }
        return null;
    }

    private static void addAndroidModules(Set<AndroidFacet> androidFacets, Set<Module> seen, Graph<Module> graph, Module module) {
        Iterator iterator = graph.getOut((Object)module);
        while (iterator.hasNext()) {
            Module dep = (Module)iterator.next();
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)dep);
            if (facet2 != null) {
                androidFacets.add(facet2);
            }
            if (seen.contains(dep)) continue;
            seen.add(dep);
            AndroidLintIdeProject.addAndroidModules(androidFacets, seen, graph, dep);
        }
    }

    private static void addProjects(LintClient client, Module module, @Nullable List<VirtualFile> files2, Map<Module, Project> moduleMap, Map<AndroidLibrary, Project> libraryMap, Map<Project, Module> projectMap, List<Project> projects) {
        AndroidModuleModel androidModuleModel;
        if (moduleMap.containsKey(module)) {
            return;
        }
        LintIdeProject.LintModuleProject project = AndroidLintIdeProject.createModuleProject(client, module);
        if (project == null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(module, false);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidLintIdeProject.addProjects(client, dependentFacet.getModule(), files2, moduleMap, libraryMap, projectMap, projects);
            }
            return;
        }
        project.setIdeaProject(module.getProject());
        projects.add((Project)project);
        moduleMap.put(module, (Project)project);
        projectMap.put((Project)project, module);
        if (AndroidLintIdeProject.processFileFilter((Module)module, files2, (LintIdeProject.LintModuleProject)project)) {
            return;
        }
        ArrayList<Project> dependencies2 = new ArrayList<Project>();
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(module, true);
        for (AndroidFacet dependentFacet : dependentFacets) {
            Project p = moduleMap.get(dependentFacet.getModule());
            if (p != null) {
                dependencies2.add(p);
                continue;
            }
            AndroidLintIdeProject.addProjects(client, dependentFacet.getModule(), files2, moduleMap, libraryMap, projectMap, dependencies2);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        if (facet2 != null && (androidModuleModel = AndroidModuleModel.get(facet2)) != null) {
            AndroidLintIdeProject.addGradleLibraryProjects(client, files2, libraryMap, projects, facet2, androidModuleModel, project, projectMap, dependencies2);
        }
        project.setDirectLibraries(dependencies2);
    }

    @Nullable
    private static LintIdeProject.LintModuleProject createModuleProject(LintClient client, Module module) {
        LintIdeProject.LintModuleProject project;
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        File dir = AndroidLintIdeProject.getLintProjectDirectory(module, facet2);
        if (dir == null) {
            return null;
        }
        if (facet2 == null) {
            project = new LintIdeProject.LintModuleProject(client, dir, dir, module);
            AndroidFacet f = AndroidLintIdeProject.findAndroidFacetInProject(module.getProject());
            if (f != null) {
                project.gradleProject = AndroidModel.isRequired(f);
            }
        } else {
            AndroidModel androidModel;
            project = AndroidModel.isRequired(facet2) ? ((androidModel = AndroidModel.get(facet2)) instanceof AndroidModuleModel ? new LintGradleProject(client, dir, dir, facet2, (AndroidModuleModel)androidModel) : (androidModel != null ? new LintAndroidModelProject(client, dir, dir, facet2, androidModel) : new LintAndroidProject(client, dir, dir, facet2))) : new LintAndroidProject(client, dir, dir, facet2);
        }
        client.registerProject(dir, (Project)project);
        return project;
    }

    @Nullable
    public static File getLintProjectDirectory(Module module, @Nullable AndroidFacet facet2) {
        File dir;
        if (facet2 != null) {
            VirtualFile mainContentRoot = AndroidRootUtil.getMainContentRoot(facet2);
            if (mainContentRoot == null) {
                return null;
            }
            dir = VfsUtilCore.virtualToIoFile((VirtualFile)mainContentRoot);
        } else {
            dir = AndroidRootUtil.findModuleRootFolderPath(module);
        }
        return dir;
    }

    public static boolean hasAndroidModule(com.intellij.openapi.project.Project project) {
        return ProjectFacetManager.getInstance((com.intellij.openapi.project.Project)project).hasFacets(AndroidFacet.ID);
    }

    @Nullable
    private static AndroidFacet findAndroidFacetInProject(com.intellij.openapi.project.Project project) {
        List androidFacetsInRandomOrder = ProjectFacetManager.getInstance((com.intellij.openapi.project.Project)project).getFacets(AndroidFacet.ID);
        return androidFacetsInRandomOrder.isEmpty() ? null : (AndroidFacet)androidFacetsInRandomOrder.get(0);
    }

    private static void addGradleLibraryProjects(LintClient client, @Nullable List<VirtualFile> files2, Map<AndroidLibrary, Project> libraryMap, List<Project> projects, AndroidFacet facet2, AndroidModuleModel androidModuleModel, LintIdeProject.LintModuleProject project, Map<Project, Module> projectMap, List<Project> dependencies2) {
        Collection libraries = androidModuleModel.getSelectedMainCompileDependencies().getLibraries();
        for (AndroidLibrary library : libraries) {
            Object p = libraryMap.get(library);
            if (p == null) {
                File dir = library.getFolder();
                p = new LintGradleLibraryProject(client, dir, dir, library);
                libraryMap.put(library, (Project)p);
                projectMap.put((Project)p, facet2.getModule());
                projects.add((Project)p);
                if (files2 != null) {
                    VirtualFile libraryDir = LocalFileSystem.getInstance().findFileByIoFile(dir);
                    if (libraryDir != null) {
                        ListIterator<VirtualFile> iterator = files2.listIterator();
                        while (iterator.hasNext()) {
                            VirtualFile file = iterator.next();
                            if (!VfsUtilCore.isAncestor((VirtualFile)libraryDir, (VirtualFile)file, (boolean)false)) continue;
                            project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                            iterator.remove();
                        }
                    }
                    if (files2.isEmpty()) {
                        files2 = null;
                    }
                }
            }
            dependencies2.add((Project)p);
        }
    }

    protected void initialize() {
    }

    protected static boolean depsDependsOn(Project project, String artifact) {
        for (Project dependency : project.getDirectLibraries()) {
            Boolean b = dependency.dependsOn(artifact);
            if (b == null || !b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static final class LintGradleLibraryProject
    extends LintIdeProject {
        private final AndroidLibrary myLibrary;
        private static boolean sOptionalAvailable = true;

        private LintGradleLibraryProject(LintClient client, File dir, File referenceDir, AndroidLibrary library) {
            super(client, dir, referenceDir);
            this.myLibrary = library;
            this.library = true;
            this.mergeManifests = true;
            this.reportIssues = false;
            this.gradleProject = true;
            this.directLibraries = Collections.emptyList();
        }

        public List<File> getManifestFiles() {
            if (this.manifestFiles == null) {
                File manifest = this.myLibrary.getManifest();
                this.manifestFiles = manifest.exists() ? Collections.singletonList(manifest) : Collections.emptyList();
            }
            return this.manifestFiles;
        }

        public List<File> getProguardFiles() {
            if (this.proguardFiles == null) {
                File proguardRules = this.myLibrary.getProguardRules();
                this.proguardFiles = proguardRules.exists() ? Collections.singletonList(proguardRules) : Collections.emptyList();
            }
            return this.proguardFiles;
        }

        public List<File> getResourceFolders() {
            if (this.resourceFolders == null) {
                File folder = this.myLibrary.getResFolder();
                this.resourceFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.resourceFolders;
        }

        public List<File> getAssetFolders() {
            if (this.assetFolders == null) {
                File folder = this.myLibrary.getAssetsFolder();
                this.assetFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.assetFolders;
        }

        public List<File> getJavaSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }

        @Nullable
        public IdeAndroidProject getGradleProjectModel() {
            return null;
        }

        @Nullable
        public AndroidLibrary getGradleLibraryModel() {
            return this.myLibrary;
        }

        @Nullable
        public Boolean dependsOn(String artifact) {
            if ("com.android.support:support-v4".equals(artifact) || "androidx.legacy:legacy-support-v4".equals(artifact)) {
                if (this.supportLib == null) {
                    this.supportLib = GradleUtil.dependsOn(this.myLibrary, "com.android.support:support-v4", true) || GradleUtil.dependsOn(this.myLibrary, "androidx.legacy:legacy-support-v4", true);
                }
                return this.supportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact) || "androidx.appcompat:appcompat".equals(artifact)) {
                if (this.appCompat == null) {
                    this.appCompat = GradleUtil.dependsOn(this.myLibrary, "com.android.support:appcompat-v7", true) || GradleUtil.dependsOn(this.myLibrary, "androidx.appcompat:appcompat", true);
                }
                return this.appCompat;
            }
            if ("com.android.support:leanback-v17".equals(artifact) || "androidx.leanback:leanback".equals(artifact)) {
                if (this.leanback == null) {
                    this.leanback = GradleUtil.dependsOn(this.myLibrary, "com.android.support:leanback-v17", true) || GradleUtil.dependsOn(this.myLibrary, "androidx.leanback:leanback", true);
                }
                return this.leanback;
            }
            if (GradleUtil.dependsOn(this.myLibrary, artifact, true)) {
                return true;
            }
            return super.dependsOn(artifact);
        }
    }

    private static final class LintGradleProject
    extends LintAndroidModelProject {
        private final AndroidModuleModel myAndroidModuleModel;
        private static boolean sProvidedAvailable = true;

        private LintGradleProject(LintClient client, File dir, File referenceDir, AndroidFacet facet2, AndroidModuleModel androidModuleModel) {
            super(client, dir, referenceDir, facet2, androidModuleModel);
            this.gradleProject = true;
            this.mergeManifests = true;
            this.myAndroidModuleModel = androidModuleModel;
        }

        protected boolean includeTests() {
            GradleVersion version2;
            IdeAndroidProject model2;
            if (this.isGradleProject() && (model2 = this.getGradleProjectModel()) != null && (version2 = this.getGradleModelVersion()) != null && version2.isAtLeast(2, 4, 0, "alpha", 4, true)) {
                try {
                    return model2.getLintOptions().isCheckTestSources();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.includeTests();
        }

        @Override
        public List<File> getManifestFiles() {
            if (this.manifestFiles == null) {
                this.manifestFiles = ContainerUtil.map(SourceProviderManager.getInstance(this.myFacet).getSources().getManifestFiles(), it -> VfsUtilCore.virtualToIoFile((VirtualFile)it));
            }
            return this.manifestFiles;
        }

        public List<File> getAssetFolders() {
            if (this.assetFolders == null) {
                this.assetFolders = new ArrayList();
                for (IdeaSourceProvider ideaSourceProvider : SourceProviderManager.getInstance(this.myFacet).getAllSourceProviders()) {
                    Collection<VirtualFile> dirs = ideaSourceProvider.getAssetsDirectories();
                    for (VirtualFile dir : dirs) {
                        this.assetFolders.add(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
                    }
                }
            }
            return this.assetFolders;
        }

        @Override
        public List<File> getProguardFiles() {
            if (this.proguardFiles == null) {
                AndroidModuleModel androidModel;
                if (AndroidModel.isRequired(this.myFacet) && (androidModel = AndroidModuleModel.get(this.myFacet)) != null) {
                    ProductFlavor flavor = androidModel.getAndroidProject().getDefaultConfig().getProductFlavor();
                    this.proguardFiles = new ArrayList();
                    for (File file : flavor.getProguardFiles()) {
                        if (!file.exists()) continue;
                        this.proguardFiles.add(file);
                    }
                    try {
                        for (File file : flavor.getConsumerProguardFiles()) {
                            if (!file.exists()) continue;
                            this.proguardFiles.add(file);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.proguardFiles == null) {
                    this.proguardFiles = Collections.emptyList();
                }
            }
            return this.proguardFiles;
        }

        public boolean hasDynamicFeatures() {
            if (this.getProjectType() != ProjectType.APP) {
                return false;
            }
            if (!GradleProjectInfo.getInstance(this.myFacet.getModule().getProject()).isBuildWithGradle()) {
                return false;
            }
            if (!AndroidModel.isRequired(this.myFacet)) {
                return false;
            }
            AndroidModuleModel model2 = AndroidModuleModel.get(this.myFacet);
            if (model2 == null) {
                return false;
            }
            IdeAndroidProject project = model2.getAndroidProject();
            return project.isBaseSplit() && !project.getDynamicFeatures().isEmpty();
        }

        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }

        public int getBuildSdk() {
            String compileTarget;
            AndroidVersion version2;
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel != null && (version2 = AndroidTargetHash.getPlatformVersion((String)(compileTarget = androidModel.getAndroidProject().getCompileTarget()))) != null) {
                return version2.getFeatureLevel();
            }
            AndroidPlatform platform = AndroidPlatform.getInstance(this.myFacet.getModule());
            if (platform != null) {
                return platform.getApiVersion().getFeatureLevel();
            }
            return super.getBuildSdk();
        }

        @Nullable
        public String getBuildTargetHash() {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel != null) {
                return androidModel.getAndroidProject().getCompileTarget();
            }
            AndroidPlatform platform = AndroidPlatform.getInstance(this.myFacet.getModule());
            if (platform != null) {
                return AndroidTargetHash.getPlatformHashString((AndroidVersion)platform.getApiVersion());
            }
            return super.getBuildTargetHash();
        }

        @Nullable
        public IdeAndroidProject getGradleProjectModel() {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel != null) {
                return androidModel.getAndroidProject();
            }
            return null;
        }

        @Nullable
        public Variant getCurrentVariant() {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel != null) {
                return androidModel.getSelectedVariant();
            }
            return null;
        }

        @Nullable
        public AndroidLibrary getGradleLibraryModel() {
            return null;
        }

        @Override
        @Nullable
        public Boolean dependsOn(String artifact) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if ("com.android.support:support-v4".equals(artifact) || "androidx.legacy:legacy-support-v4".equals(artifact)) {
                if (this.supportLib == null) {
                    this.supportLib = AndroidModel.isRequired(this.myFacet) && AndroidModel.get(this.myFacet) != null && androidModel != null ? Boolean.valueOf(GradleUtil.dependsOn(androidModel, "com.android.support:support-v4") || GradleUtil.dependsOn(androidModel, "androidx.legacy:legacy-support-v4")) : Boolean.valueOf(AndroidLintIdeProject.depsDependsOn((Project)this, "com.android.support:support-v4") || AndroidLintIdeProject.depsDependsOn((Project)this, "androidx.legacy:legacy-support-v4"));
                }
                return this.supportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact) || "androidx.appcompat:appcompat".equals(artifact)) {
                if (this.appCompat == null) {
                    this.appCompat = AndroidModel.isRequired(this.myFacet) && AndroidModel.get(this.myFacet) != null && androidModel != null ? Boolean.valueOf(GradleUtil.dependsOn(androidModel, "com.android.support:appcompat-v7") || GradleUtil.dependsOn(androidModel, "androidx.appcompat:appcompat")) : Boolean.valueOf(AndroidLintIdeProject.depsDependsOn((Project)this, "com.android.support:appcompat-v7") || AndroidLintIdeProject.depsDependsOn((Project)this, "androidx.appcompat:appcompat"));
                }
                return this.appCompat;
            }
            if ("com.android.support:leanback-v17".equals(artifact) || "androidx.leanback:leanback".equals(artifact)) {
                if (this.leanback == null) {
                    this.leanback = AndroidModel.isRequired(this.myFacet) && AndroidModel.get(this.myFacet) != null && androidModel != null ? Boolean.valueOf(GradleUtil.dependsOn(androidModel, "com.android.support:leanback-v17") || GradleUtil.dependsOn(androidModel, "androidx.leanback:leanback")) : Boolean.valueOf(AndroidLintIdeProject.depsDependsOn((Project)this, "com.android.support:leanback-v17") || AndroidLintIdeProject.depsDependsOn((Project)this, "androidx.leanback:leanback"));
                }
                return this.leanback;
            }
            if (AndroidModel.isRequired(this.myFacet) && AndroidModel.get(this.myFacet) != null && androidModel != null) {
                String newArtifact;
                if (GradleUtil.dependsOn(androidModel, artifact)) {
                    return true;
                }
                if (artifact.startsWith("com.android.support") && !(newArtifact = AndroidxNameUtils.getCoordinateMapping((String)artifact)).equals(artifact) && GradleUtil.dependsOn(androidModel, newArtifact)) {
                    return true;
                }
            }
            return super.dependsOn(artifact);
        }
    }

    private static class LintAndroidModelProject
    extends LintAndroidProject {
        private final AndroidModel myAndroidModel;

        private LintAndroidModelProject(LintClient client, File dir, File referenceDir, AndroidFacet facet2, AndroidModel androidModel) {
            super(client, dir, referenceDir, facet2);
            this.myAndroidModel = androidModel;
        }

        @Nullable
        public String getPackage() {
            String manifestPackage = super.getPackage();
            if (manifestPackage != null) {
                return manifestPackage;
            }
            return this.myAndroidModel.getApplicationId();
        }

        public AndroidVersion getMinSdkVersion() {
            if (this.myMinSdkVersion == null) {
                this.myMinSdkVersion = AndroidModuleInfo.getInstance(this.myFacet).getMinSdkVersion();
            }
            return this.myMinSdkVersion;
        }

        public AndroidVersion getTargetSdkVersion() {
            if (this.myTargetSdkVersion == null) {
                this.myTargetSdkVersion = AndroidModuleInfo.getInstance(this.myFacet).getTargetSdkVersion();
            }
            return this.myTargetSdkVersion;
        }
    }

    private static class LintAndroidProject
    extends LintIdeProject.LintModuleProject {
        protected final AndroidFacet myFacet;

        private LintAndroidProject(LintClient client, File dir, File referenceDir, AndroidFacet facet2) {
            super(client, dir, referenceDir, facet2.getModule());
            this.myFacet = facet2;
            this.gradleProject = false;
            this.library = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).isLibraryProject();
            AndroidPlatform platform = AndroidPlatform.getInstance(this.myFacet.getModule());
            if (platform != null) {
                this.buildSdk = platform.getApiLevel();
            }
        }

        public boolean isAndroidProject() {
            return true;
        }

        public String getName() {
            return this.myFacet.getModule().getName();
        }

        public ProjectType getProjectType() {
            return GradleModelConverterUtil.getProjectType((int)((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType());
        }

        public List<File> getManifestFiles() {
            if (this.manifestFiles == null) {
                VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(this.myFacet);
                this.manifestFiles = manifestFile != null ? Collections.singletonList(VfsUtilCore.virtualToIoFile((VirtualFile)manifestFile)) : Collections.emptyList();
            }
            return this.manifestFiles;
        }

        public List<File> getProguardFiles() {
            if (this.proguardFiles == null) {
                List urls;
                AndroidFacetProperties properties = this.myFacet.getProperties();
                if (properties.RUN_PROGUARD && !(urls = properties.myProGuardCfgFiles).isEmpty()) {
                    this.proguardFiles = new ArrayList();
                    for (String osPath : AndroidUtils.urlsToOsPaths(urls, null)) {
                        if (osPath.contains("%MODULE_SDK_HOME%")) continue;
                        this.proguardFiles.add(new File(osPath));
                    }
                }
                if (this.proguardFiles == null) {
                    this.proguardFiles = Collections.emptyList();
                }
            }
            return this.proguardFiles;
        }

        public List<File> getResourceFolders() {
            if (this.resourceFolders == null) {
                List<VirtualFile> folders = ResourceFolderManager.getInstance(this.myFacet).getFolders();
                ArrayList dirs = Lists.newArrayListWithExpectedSize((int)folders.size());
                for (VirtualFile folder : folders) {
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)folder));
                }
                this.resourceFolders = dirs;
            }
            return this.resourceFolders;
        }

        @Nullable
        public Boolean dependsOn(String artifact) {
            GradleCoordinate queryCoordinate = GradleCoordinate.parseCoordinateString((String)(artifact + ":+"));
            if (queryCoordinate != null) {
                String newArtifact;
                GradleCoordinate foundDependency = ProjectSystemUtil.getModuleSystem(this.myFacet.getModule()).getResolvedDependency(queryCoordinate);
                if (foundDependency != null) {
                    return Boolean.TRUE;
                }
                if (artifact.startsWith("com.android.support") && !(newArtifact = AndroidxNameUtils.getCoordinateMapping((String)artifact)).equals(artifact) && (queryCoordinate = GradleCoordinate.parseCoordinateString((String)(newArtifact + ":+"))) != null && (foundDependency = ProjectSystemUtil.getModuleSystem(this.myFacet.getModule()).getResolvedDependency(queryCoordinate)) != null) {
                    return Boolean.TRUE;
                }
            }
            return super.dependsOn(artifact);
        }
    }
}

