/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfSurrounder;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinIfSurrounder;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bH\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\u00020\u0017*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/lint/AddTargetVersionCheckQuickFix;", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "api", "", "(I)V", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "getKotlinSurrounder", "Lorg/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinIfSurrounder;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "todoText", "", "getKotlinTargetExpression", "getName", "handleJava", "handleKotlin", "isApplicable", "", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "isInvalidTargetExpression", "Companion", "intellij.android.core"})
public final class AddTargetVersionCheckQuickFix
implements LintIdeQuickFix {
    private final int api;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return "Surround with if (VERSION.SDK_INT >= VERSION_CODES." + Companion.getVersionField(this.api, false) + ") { ... }";
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        PsiExpression expression;
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        if (AndroidFacet.getInstance((PsiElement)endElement) == null) {
            return false;
        }
        Language language = startElement.getLanguage();
        return Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE) ? (expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiExpression.class, (boolean)false)) != null : (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) ? this.getKotlinTargetExpression(startElement) != null : false);
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        block2: {
            Language language;
            block1: {
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (!FileModificationService.getInstance().preparePsiElementForWrite(startElement)) {
                    return;
                }
                language = startElement.getLanguage();
                if (!Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) break block1;
                this.handleJava(startElement);
                break block2;
            }
            if (!Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) break block2;
            this.handleKotlin(startElement);
        }
    }

    private final void handleKotlin(PsiElement element) {
        KtElement ktElement = this.getKotlinTargetExpression(element);
        if (ktElement == null) {
            return;
        }
        KtElement targetExpression = ktElement;
        Project project = targetExpression.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"targetExpression.project ?: return");
        Project project2 = project;
        Editor editor2 = IntentionBasedInspectionKt.findExistingEditor((PsiElement)((PsiElement)targetExpression));
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        PsiFile file = targetExpression.getContainingFile();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = documentManager.getDocument(file);
        if (document == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"documentManager.getDocument(file) ?: return");
        Document document2 = document;
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        KotlinIfSurrounder surrounder = this.getKotlinSurrounder(targetExpression, "\"VERSION.SDK_INT < " + Companion.getVersionField(this.api, false) + '\"');
        TextRange textRange = surrounder.surroundElements(project2, editor3, (PsiElement[])new KtElement[]{targetExpression});
        if (textRange == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"surrounder.surroundEleme\u2026getExpression)) ?: return");
        TextRange conditionRange = textRange;
        String conditionText = "android.os.Build.VERSION.SDK_INT >= " + Companion.getVersionField(this.api, true);
        document2.replaceString(conditionRange.getStartOffset(), conditionRange.getEndOffset(), (CharSequence)conditionText);
        documentManager.commitDocument(document2);
        PsiFile psiFile2 = documentManager.getPsiFile(document2);
        if (psiFile2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        ShortenReferences.process$default((ShortenReferences)ShortenReferences.DEFAULT, (KtFile)((KtFile)psiFile2), (int)conditionRange.getStartOffset(), (int)(conditionRange.getStartOffset() + conditionText.length()), null, null, (int)24, null);
    }

    private final void handleJava(PsiElement element) {
        PsiExpression psiExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class, (boolean)false);
        if (psiExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"PsiTreeUtil.getParentOfT\u2026ss.java, false) ?: return");
        PsiExpression expression = psiExpression;
        Editor editor2 = PsiUtilBase.findEditor((PsiElement)((PsiElement)expression));
        if (editor2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"PsiUtilBase.findEditor(expression) ?: return");
        Editor editor3 = editor2;
        PsiStatement psiStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression), PsiStatement.class);
        if (psiStatement == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiStatement, (String)"PsiTreeUtil.getParentOfT\u2026nt::class.java) ?: return");
        PsiStatement anchorStatement = psiStatement;
        PsiFile file = expression.getContainingFile();
        Project project = expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"expression.project");
        Project project2 = project;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = documentManager.getDocument(file);
        if (document == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"documentManager.getDocument(file) ?: return");
        Document document2 = document;
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false);
        PsiElement[] elements = new PsiElement[]{(PsiElement)anchorStatement};
        PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)((PsiElement)anchorStatement));
        if (prev instanceof PsiComment && JavaSuppressionUtil.getSuppressedInspectionIdsIn((PsiElement)prev) != null) {
            elements = new PsiElement[]{prev, (PsiElement)anchorStatement};
        }
        try {
            TextRange textRange = new JavaWithIfSurrounder().surroundElements(project2, editor3, elements);
            if (textRange == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"JavaWithIfSurrounder().s\u2026itor, elements) ?: return");
            TextRange textRange2 = textRange;
            String newText = "android.os.Build.VERSION.SDK_INT >= " + Companion.getVersionField(this.api, true);
            document2.replaceString(textRange2.getStartOffset(), textRange2.getEndOffset(), (CharSequence)newText);
            documentManager.commitDocument(document2);
            editor3.getCaretModel().moveToOffset(textRange2.getEndOffset() + newText.length());
            editor3.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            if (owner != null && owner.isValid()) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) {
                    JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)owner);
                }
            }
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance(AddTargetVersionCheckQuickFix.class).error((Throwable)e);
        }
    }

    private final KtElement getKotlinTargetExpression(PsiElement element) {
        KtElement current = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)element, KtExpression.class);
        while (current != null) {
            PsiElement parent;
            if (current.getParent() == null) {
                return current;
            }
            if (this.isInvalidTargetExpression(parent)) break;
            current = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)current), KtExpression.class, (boolean)true);
        }
        return current;
    }

    private final KotlinIfSurrounder getKotlinSurrounder(KtElement element, String todoText) {
        Boolean bl = (Boolean)ResolutionUtils.analyze((KtElement)element, (BodyResolveMode)BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.USED_AS_EXPRESSION, (Object)element);
        if (bl == null) {
            bl = false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"element.analyze(BodyReso\u2026ESSION, element] ?: false");
        boolean used = bl;
        return used ? (KotlinIfSurrounder)new KotlinIfSurrounder(todoText){
            final /* synthetic */ String $todoText;

            @NotNull
            protected String getCodeTemplate() {
                StringBuilder stringBuilder = new StringBuilder().append("if (a) { \n} else {\nTODO(");
                String string = this.$todoText;
                if (string == null) {
                    string = "";
                }
                return stringBuilder.append(string).append(")\n}").toString();
            }
            {
                this.$todoText = $captured_local_variable$0;
            }
        } : new KotlinIfSurrounder();
    }

    private final boolean isInvalidTargetExpression(PsiElement $this$isInvalidTargetExpression) {
        return $this$isInvalidTargetExpression instanceof KtBlockExpression || $this$isInvalidTargetExpression instanceof KtContainerNode || $this$isInvalidTargetExpression instanceof KtWhenEntry || $this$isInvalidTargetExpression instanceof KtFunction || $this$isInvalidTargetExpression instanceof KtPropertyAccessor || $this$isInvalidTargetExpression instanceof KtProperty || $this$isInvalidTargetExpression instanceof KtReturnExpression || $this$isInvalidTargetExpression instanceof KtDestructuringDeclaration;
    }

    public AddTargetVersionCheckQuickFix(int api) {
        this.api = api;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/lint/AddTargetVersionCheckQuickFix$Companion;", "", "()V", "getVersionField", "", "myApi", "", "fullyQualified", "", "intellij.android.core"})
    public static final class Companion {
        @NotNull
        public final String getVersionField(int myApi, boolean fullyQualified) {
            String codeName = SdkVersionInfo.getBuildCode((int)myApi);
            return codeName == null ? String.valueOf(myApi) : (fullyQualified ? "android.os.Build.VERSION_CODES." + codeName : codeName);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

