/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.model;

import com.android.tools.idea.layoutinspector.SkiaParser;
import com.android.tools.idea.layoutinspector.SkiaParserService;
import com.android.tools.idea.layoutinspector.model.ComponentTreeLoaderImpl;
import com.android.tools.idea.layoutinspector.model.TreeLoader;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.resource.ResourceLookup;
import com.android.tools.idea.layoutinspector.transport.InspectorClient;
import com.android.tools.layoutinspector.proto.LayoutInspectorProto;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J4\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J8\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/layoutinspector/model/ComponentTreeLoader;", "Lcom/android/tools/idea/layoutinspector/model/TreeLoader;", "()V", "getAllWindowIds", "", "", "data", "", "client", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "loadComponentTree", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "maybeEvent", "resourceLookup", "Lcom/android/tools/idea/layoutinspector/resource/ResourceLookup;", "skiaParser", "Lcom/android/tools/idea/layoutinspector/SkiaParserService;", "project", "Lcom/intellij/openapi/project/Project;", "Lkotlin/Pair;", "intellij.android.layout-inspector"})
public final class ComponentTreeLoader
implements TreeLoader {
    public static final ComponentTreeLoader INSTANCE;

    @Nullable
    public Pair<ViewNode, Long> loadComponentTree(@Nullable Object data, @NotNull ResourceLookup resourceLookup, @NotNull InspectorClient client, @NotNull Project project) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)resourceLookup, (String)"resourceLookup");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ViewNode viewNode = this.loadComponentTree(data, resourceLookup, client, SkiaParser.INSTANCE, project);
        if (viewNode != null) {
            ViewNode viewNode2 = viewNode;
            boolean bl = false;
            boolean bl2 = false;
            ViewNode it = viewNode2;
            boolean bl3 = false;
            pair = new Pair((Object)it, (Object)it.getDrawId());
        } else {
            pair = null;
        }
        return pair;
    }

    @VisibleForTesting
    @Nullable
    public final ViewNode loadComponentTree(@Nullable Object maybeEvent, @NotNull ResourceLookup resourceLookup, @NotNull InspectorClient client, @NotNull SkiaParserService skiaParser, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)resourceLookup, (String)"resourceLookup");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)skiaParser, (String)"skiaParser");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = maybeEvent;
        if (!(object instanceof LayoutInspectorProto.LayoutInspectorEvent)) {
            object = null;
        }
        LayoutInspectorProto.LayoutInspectorEvent layoutInspectorEvent = (LayoutInspectorProto.LayoutInspectorEvent)object;
        if (layoutInspectorEvent == null) {
            return null;
        }
        LayoutInspectorProto.LayoutInspectorEvent event = layoutInspectorEvent;
        LayoutInspectorProto.ComponentTreeEvent componentTreeEvent = event.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)componentTreeEvent, (String)"event.tree");
        return new ComponentTreeLoaderImpl(componentTreeEvent, resourceLookup).loadComponentTree(client, skiaParser, project);
    }

    @Nullable
    public List<Long> getAllWindowIds(@Nullable Object data, @NotNull InspectorClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = data;
        if (!(object instanceof LayoutInspectorProto.LayoutInspectorEvent)) {
            object = null;
        }
        LayoutInspectorProto.LayoutInspectorEvent layoutInspectorEvent = (LayoutInspectorProto.LayoutInspectorEvent)object;
        if (layoutInspectorEvent == null) {
            return null;
        }
        LayoutInspectorProto.LayoutInspectorEvent event = layoutInspectorEvent;
        LayoutInspectorProto.ComponentTreeEvent componentTreeEvent = event.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)componentTreeEvent, (String)"event.tree");
        return componentTreeEvent.getAllWindowIdsList();
    }

    private ComponentTreeLoader() {
    }

    static {
        ComponentTreeLoader componentTreeLoader;
        INSTANCE = componentTreeLoader = new ComponentTreeLoader();
    }
}

