/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector;

import com.android.tools.idea.layoutinspector.legacydevice.LegacyClient;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.transport.DisconnectedClient;
import com.android.tools.idea.layoutinspector.transport.InspectorClient;
import com.android.tools.layoutinspector.proto.LayoutInspectorProto;
import com.android.tools.profiler.proto.Common;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "Lcom/intellij/openapi/Disposable;", "layoutInspectorModel", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "parentDisposable", "(Lcom/android/tools/idea/layoutinspector/model/InspectorModel;Lcom/intellij/openapi/Disposable;)V", "allClients", "", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "getAllClients", "()Ljava/util/List;", "client", "currentClient", "getCurrentClient", "()Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "setCurrentClient", "(Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;)V", "latestLoadTime", "Ljava/util/concurrent/atomic/AtomicLong;", "getLayoutInspectorModel", "()Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "clearComponentTreeWhenProcessEnds", "", "dispose", "loadComponentTree", "event", "", "logError", "registerClientListeners", "intellij.android.layout-inspector"})
public final class LayoutInspector
implements Disposable {
    @NotNull
    private InspectorClient currentClient;
    private final AtomicLong latestLoadTime;
    @NotNull
    private final List<InspectorClient> allClients;
    @NotNull
    private final InspectorModel layoutInspectorModel;

    @NotNull
    public final InspectorClient getCurrentClient() {
        return this.currentClient;
    }

    private final void setCurrentClient(InspectorClient client) {
        if (Intrinsics.areEqual((Object)this.currentClient, (Object)client) ^ true) {
            this.currentClient.disconnect();
            this.currentClient = client;
            this.layoutInspectorModel.updateConnection(client);
        }
    }

    @NotNull
    public final List<InspectorClient> getAllClients() {
        return this.allClients;
    }

    public void dispose() {
    }

    private final void registerClientListeners(InspectorClient client) {
        client.register(Common.Event.EventGroupIds.LAYOUT_INSPECTOR_ERROR, (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(this){

            public final void invoke(@NotNull Object p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                LayoutInspector.access$logError((LayoutInspector)this.receiver, p1);
            }
        }));
        client.register(Common.Event.EventGroupIds.COMPONENT_TREE, (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(this, client){
            final /* synthetic */ LayoutInspector this$0;
            final /* synthetic */ InspectorClient $client;

            public final void invoke(@NotNull Object event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LayoutInspector.access$setCurrentClient$p(this.this$0, this.$client);
                LayoutInspector.access$loadComponentTree(this.this$0, event);
            }
            {
                this.this$0 = layoutInspector;
                this.$client = inspectorClient;
                super(1);
            }
        }));
        client.registerProcessChanged((Function0<Unit>)((Function0)new Function0<Unit>(this){

            public final void invoke() {
                LayoutInspector.access$clearComponentTreeWhenProcessEnds((LayoutInspector)this.receiver);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void loadComponentTree(Object event) {
        long time2 = System.currentTimeMillis();
        List<?> allIds = this.currentClient.getTreeLoader().getAllWindowIds(event, this.currentClient);
        Pair<ViewNode, ?> pair = this.currentClient.getTreeLoader().loadComponentTree(event, this.layoutInspectorModel.getResourceLookup(), this.currentClient, this.layoutInspectorModel.getProject());
        if (pair == null) {
            return;
        }
        Pair<ViewNode, ?> pair2 = pair;
        ViewNode viewNode = (ViewNode)pair2.component1();
        Object rootId = pair2.component2();
        if (rootId != null && allIds != null) {
            void root2;
            ApplicationManager.getApplication().invokeLater(new Runnable(this, time2, (ViewNode)root2, rootId, allIds){
                final /* synthetic */ LayoutInspector this$0;
                final /* synthetic */ long $time;
                final /* synthetic */ ViewNode $root;
                final /* synthetic */ Object $rootId;
                final /* synthetic */ List $allIds;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    AtomicLong atomicLong = LayoutInspector.access$getLatestLoadTime$p(this.this$0);
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (atomicLong) {
                        boolean bl3 = false;
                        if (LayoutInspector.access$getLatestLoadTime$p(this.this$0).get() > this.$time) {
                            return;
                        }
                        LayoutInspector.access$getLatestLoadTime$p(this.this$0).set(this.$time);
                        this.this$0.getLayoutInspectorModel().update(this.$root, this.$rootId, this.$allIds);
                        Unit unit = Unit.INSTANCE;
                    }
                }
                {
                    this.this$0 = layoutInspector;
                    this.$time = l;
                    this.$root = viewNode;
                    this.$rootId = object;
                    this.$allIds = list;
                }
            });
        }
    }

    private final void logError(Object event) {
        Object object = event;
        String error = object instanceof LayoutInspectorProto.LayoutInspectorEvent ? ((LayoutInspectorProto.LayoutInspectorEvent)event).getErrorMessage() : (object instanceof String ? (String)event : "Unknown Error");
        Logger.getInstance((String)LayoutInspector.class.getCanonicalName()).warn(error);
    }

    private final void clearComponentTreeWhenProcessEnds() {
        if (this.currentClient.isConnected()) {
            return;
        }
        this.setCurrentClient(DisconnectedClient.INSTANCE);
        Application application = ApplicationManager.getApplication();
        application.invokeLater(new Runnable(this){
            final /* synthetic */ LayoutInspector this$0;

            public final void run() {
                boolean bl = false;
                this.this$0.getLayoutInspectorModel().update(null, 0, CollectionsKt.emptyList());
            }
            {
                this.this$0 = layoutInspector;
            }
        });
    }

    @NotNull
    public final InspectorModel getLayoutInspectorModel() {
        return this.layoutInspectorModel;
    }

    public LayoutInspector(@NotNull InspectorModel layoutInspectorModel, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)layoutInspectorModel, (String)"layoutInspectorModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.layoutInspectorModel = layoutInspectorModel;
        this.currentClient = DisconnectedClient.INSTANCE;
        this.latestLoadTime = new AtomicLong(-1L);
        InspectorClient defaultClient = InspectorClient.Companion.createInstance(this.layoutInspectorModel, this);
        this.registerClientListeners(defaultClient);
        LegacyClient legacyClient = new LegacyClient(this);
        this.registerClientListeners(legacyClient);
        this.allClients = CollectionsKt.listOf((Object[])new InspectorClient[]{defaultClient, legacyClient});
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public static final /* synthetic */ void access$logError(LayoutInspector $this, Object event) {
        $this.logError(event);
    }

    public static final /* synthetic */ InspectorClient access$getCurrentClient$p(LayoutInspector $this) {
        return $this.currentClient;
    }

    public static final /* synthetic */ void access$setCurrentClient$p(LayoutInspector $this, InspectorClient inspectorClient) {
        $this.setCurrentClient(inspectorClient);
    }

    public static final /* synthetic */ void access$loadComponentTree(LayoutInspector $this, Object event) {
        $this.loadComponentTree(event);
    }

    public static final /* synthetic */ void access$clearComponentTreeWhenProcessEnds(LayoutInspector $this) {
        $this.clearComponentTreeWhenProcessEnds();
    }

    public static final /* synthetic */ AtomicLong access$getLatestLoadTime$p(LayoutInspector $this) {
        return $this.latestLoadTime;
    }
}

