/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.level2.Library;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.VariantOnlySyncOptions;
import com.android.tools.idea.gradle.project.sync.setup.module.android.AndroidVariantChangeModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.ndk.NdkVariantChangeModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.BatchUpdatesUtil;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildVariantUpdater {
    @NotNull
    public static final Key<String> MODULE_WITH_BUILD_VARIANT_SWITCHED_FROM_UI = new Key("module.with.build.variant.switched.from.ui");
    @NotNull
    private final ModuleSetupContext.Factory myModuleSetupContextFactory;
    @NotNull
    private final IdeModifiableModelsProviderFactory myModifiableModelsProviderFactory;
    @NotNull
    private final AndroidVariantChangeModuleSetup myAndroidModuleSetupSteps;
    @NotNull
    private final NdkVariantChangeModuleSetup myNdkModuleSetupSteps;
    @NotNull
    private final List<BuildVariantView.BuildVariantSelectionChangeListener> mySelectionChangeListeners;

    @NotNull
    public static BuildVariantUpdater getInstance(@NotNull Project project) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(0);
        }
        BuildVariantUpdater buildVariantUpdater = (BuildVariantUpdater)project.getService(BuildVariantUpdater.class);
        if (buildVariantUpdater == null) {
            BuildVariantUpdater.$$$reportNull$$$0(1);
        }
        return buildVariantUpdater;
    }

    BuildVariantUpdater() {
        this(new ModuleSetupContext.Factory(), new IdeModifiableModelsProviderFactory(), new AndroidVariantChangeModuleSetup(), new NdkVariantChangeModuleSetup());
    }

    @NonInjectable
    @VisibleForTesting
    BuildVariantUpdater(@NotNull ModuleSetupContext.Factory moduleSetupContextFactory, @NotNull IdeModifiableModelsProviderFactory modifiableModelsProviderFactory, @NotNull AndroidVariantChangeModuleSetup androidModuleSetup, @NotNull NdkVariantChangeModuleSetup ndkModuleSetup) {
        if (moduleSetupContextFactory == null) {
            BuildVariantUpdater.$$$reportNull$$$0(2);
        }
        if (modifiableModelsProviderFactory == null) {
            BuildVariantUpdater.$$$reportNull$$$0(3);
        }
        if (androidModuleSetup == null) {
            BuildVariantUpdater.$$$reportNull$$$0(4);
        }
        if (ndkModuleSetup == null) {
            BuildVariantUpdater.$$$reportNull$$$0(5);
        }
        this.mySelectionChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myModuleSetupContextFactory = moduleSetupContextFactory;
        this.myModifiableModelsProviderFactory = modifiableModelsProviderFactory;
        this.myAndroidModuleSetupSteps = androidModuleSetup;
        this.myNdkModuleSetupSteps = ndkModuleSetup;
    }

    public void addSelectionChangeListener(@NotNull BuildVariantView.BuildVariantSelectionChangeListener listener2) {
        if (listener2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(6);
        }
        this.mySelectionChangeListeners.add(listener2);
    }

    public void removeSelectionChangeListener(@NotNull BuildVariantView.BuildVariantSelectionChangeListener listener2) {
        if (listener2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(7);
        }
        this.mySelectionChangeListeners.remove(listener2);
    }

    public boolean updateSelectedBuildVariant(@NotNull Project project, @NotNull String moduleName2, @NotNull String selectedBuildVariant) {
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(8);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(9);
        }
        if (selectedBuildVariant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(10);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2)) == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find module '%1$s'.", moduleName2));
            return false;
        }
        NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNdkModelIfNotJustDummy(moduleToUpdate);
        if (ndkModuleModel == null) {
            return this.updateSelectedVariant(project, moduleName2, selectedBuildVariant);
        }
        String newNdkBuildVariant = BuildVariantUpdater.resolveNewNdkVariant(ndkModuleModel, selectedBuildVariant, null);
        if (newNdkBuildVariant == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find suitable ABI for native module '%1$s'.", moduleName2));
            return false;
        }
        return this.updateSelectedVariant(project, moduleName2, newNdkBuildVariant);
    }

    boolean updateSelectedAbi(@NotNull Project project, @NotNull String moduleName2, @NotNull String selectedAbiName) {
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(11);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(12);
        }
        if (selectedAbiName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(13);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2)) == null) {
            BuildVariantUpdater.logAndShowAbiNameFailure(String.format("Cannot find module '%1$s'.", moduleName2));
            return false;
        }
        NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNdkModelIfNotJustDummy(moduleToUpdate);
        if (ndkModuleModel == null) {
            BuildVariantUpdater.logAndShowAbiNameFailure(String.format("Cannot find native module model '%1$s'.", moduleName2));
            return false;
        }
        String existingNdkBuildVariant = ndkModuleModel.getSelectedVariant().getName();
        String existingBuildVariant = ndkModuleModel.getVariantName(existingNdkBuildVariant);
        String newNdkBuildVariant = BuildVariantUpdater.resolveNewNdkVariant(ndkModuleModel, existingBuildVariant, selectedAbiName);
        if (newNdkBuildVariant == null) {
            BuildVariantUpdater.logAndShowAbiNameFailure(String.format("Cannot find suitable ABI for native module '%1$s'.", moduleName2));
            return false;
        }
        return this.updateSelectedVariant(project, moduleName2, newNdkBuildVariant);
    }

    private boolean updateSelectedVariant(@NotNull Project project, @NotNull String moduleName2, @NotNull String buildVariantName) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(14);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(15);
        }
        if (buildVariantName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(16);
        }
        ArrayList<AndroidFacet> affectedAndroidFacets = new ArrayList<AndroidFacet>();
        ArrayList<NdkFacet> affectedNdkFacets = new ArrayList<NdkFacet>();
        boolean variantToUpdateExists = BuildVariantUpdater.findAndUpdateAffectedFacets(project, moduleName2, buildVariantName, affectedAndroidFacets, affectedNdkFacets);
        if (affectedAndroidFacets.isEmpty() && affectedNdkFacets.isEmpty()) {
            return false;
        }
        Runnable invokeVariantSelectionChangeListeners = () -> {
            for (BuildVariantView.BuildVariantSelectionChangeListener listener2 : this.mySelectionChangeListeners) {
                listener2.selectionChanged();
            }
        };
        if (BuildVariantUpdater.hasBuildFilesChanged(project)) {
            BuildVariantUpdater.setVariantSwitchedProperty(project, moduleName2);
            BuildVariantUpdater.requestFullGradleSync(project, invokeVariantSelectionChangeListeners);
        } else if (!variantToUpdateExists) {
            BuildVariantUpdater.setVariantSwitchedProperty(project, moduleName2);
            BuildVariantUpdater.requestVariantOnlyGradleSync(project, moduleName2, buildVariantName, invokeVariantSelectionChangeListeners);
        } else {
            this.setupCachedVariant(project, affectedAndroidFacets, affectedNdkFacets, invokeVariantSelectionChangeListeners);
        }
        return true;
    }

    private static void setVariantSwitchedProperty(@NotNull Project project, @NotNull String moduleName2) {
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(17);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(18);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2)) == null) {
            return;
        }
        GradleFacet gradleFacet = GradleFacet.getInstance(moduleToUpdate);
        if (gradleFacet == null) {
            return;
        }
        GradleModuleModel gradleModel = gradleFacet.getGradleModuleModel();
        if (gradleModel != null) {
            project.putUserData(MODULE_WITH_BUILD_VARIANT_SWITCHED_FROM_UI, (Object)Modules.createUniqueModuleId(gradleModel.getRootFolderPath(), gradleModel.getGradlePath()));
        }
    }

    private static boolean findAndUpdateAffectedFacets(@NotNull Project project, @NotNull String moduleName2, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        AndroidModuleModel androidModel;
        NdkModuleModel ndkModuleModel;
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(19);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(20);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(21);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(22);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(23);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2)) == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find module '%1$s'.", moduleName2));
            return false;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (androidFacet == null && ndkFacet == null) {
            String msg = String.format("Cannot find 'Android' or 'Native-Android-Gradle' facets in module '%1$s'.", moduleToUpdate.getName());
            BuildVariantUpdater.logAndShowBuildVariantFailure(msg);
        }
        boolean ndkVariantExists = true;
        boolean androidVariantExists = true;
        String variantName = variantToSelect;
        String abiName = null;
        if (ndkFacet != null && (ndkModuleModel = BuildVariantUpdater.getNdkModelIfNotJustDummy(ndkFacet)) != null) {
            ndkVariantExists = BuildVariantUpdater.updateAffectedFacetsForNdkModule(ndkFacet, ndkModuleModel, variantToSelect, affectedNdkFacets);
            variantName = ndkModuleModel.getVariantName(variantToSelect);
            abiName = ndkModuleModel.getAbiName(variantToSelect);
        }
        if (androidFacet != null && (androidModel = BuildVariantUpdater.getAndroidModel(androidFacet)) != null) {
            androidVariantExists = BuildVariantUpdater.updateAffectedFacetsForAndroidModule(project, androidFacet, androidModel, variantName, abiName, affectedAndroidFacets, affectedNdkFacets);
        }
        return ndkVariantExists && androidVariantExists;
    }

    private static boolean updateAffectedFacetsForNdkModule(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModuleModel, @NotNull String variantToSelect, @NotNull List<NdkFacet> affectedNdkFacets) {
        if (ndkFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(24);
        }
        if (ndkModuleModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(25);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(26);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(27);
        }
        if (variantToSelect.equals(ndkModuleModel.getSelectedVariant().getName())) {
            return true;
        }
        affectedNdkFacets.add(ndkFacet);
        ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT = variantToSelect;
        if (!ndkModuleModel.variantExists(variantToSelect)) {
            return false;
        }
        ndkModuleModel.setSelectedVariantName(variantToSelect);
        return true;
    }

    private static boolean updateAffectedFacetsForAndroidModule(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull AndroidModuleModel androidModel, @NotNull String variantToSelect, @Nullable String abiToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        boolean isAbiChanged;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(28);
        }
        if (androidFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(29);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(30);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(31);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(32);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(33);
        }
        boolean isVariantChanged = !variantToSelect.equals(androidModel.getSelectedVariant().getName());
        boolean bl = isAbiChanged = abiToSelect != null;
        if (!isVariantChanged && !isAbiChanged) {
            return true;
        }
        if (isVariantChanged) {
            affectedAndroidFacets.add(androidFacet);
            androidFacet.getProperties().SELECTED_BUILD_VARIANT = variantToSelect;
        }
        if (!androidModel.variantExists(variantToSelect)) {
            return false;
        }
        androidModel.setSelectedVariantName(variantToSelect);
        androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
        BuildVariantUpdater.updateSelectedVariantsForDependencyModules(project, androidModel, abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        return true;
    }

    private static void updateSelectedVariantsForDependencyModules(@NotNull Project project, @NotNull AndroidModuleModel androidModel, @Nullable String abiToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        Module dependencyModule;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(34);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(35);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(36);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(37);
        }
        for (Library library : androidModel.getSelectedMainCompileLevel2Dependencies().getModuleDependencies()) {
            if (!StringUtil.isNotEmpty((String)library.getVariant()) || !StringUtil.isNotEmpty((String)library.getProjectPath())) continue;
            dependencyModule = ProjectStructure.getInstance(project).getModuleFinder().findModuleFromLibrary(library);
            BuildVariantUpdater.updateDependencyModule(project, library.getProjectPath(), dependencyModule, library.getVariant(), abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        }
        for (String gradlePath : androidModel.getAndroidProject().getDynamicFeatures()) {
            if (!StringUtil.isNotEmpty((String)gradlePath) || (dependencyModule = ProjectStructure.getInstance(project).getModuleFinder().findModuleByGradlePath(gradlePath)) == null) continue;
            AndroidModuleModel depModuleModel = AndroidModuleModel.get(dependencyModule);
            String variantToSelect = androidModel.getSelectedVariant().getName();
            if (depModuleModel == null || !depModuleModel.getVariantNames().contains(variantToSelect)) continue;
            BuildVariantUpdater.updateDependencyModule(project, gradlePath, dependencyModule, variantToSelect, abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        }
    }

    private static void updateDependencyModule(@NotNull Project project, @NotNull String gradlePath, @Nullable Module dependencyModule, @NotNull String projectVariant, @Nullable String abiToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(38);
        }
        if (gradlePath == null) {
            BuildVariantUpdater.$$$reportNull$$$0(39);
        }
        if (projectVariant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(40);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(41);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(42);
        }
        if (dependencyModule == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find module with Gradle path '%1$s'.", gradlePath));
            return;
        }
        AndroidFacet dependencyFacet = AndroidFacet.getInstance((Module)dependencyModule);
        if (dependencyFacet == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find 'Android' facet in module '%1$s'.", dependencyModule.getName()));
            return;
        }
        AndroidModuleModel dependencyModel = BuildVariantUpdater.getAndroidModel(dependencyFacet);
        if (dependencyModel != null) {
            String projectVariantWithAbi;
            NdkModuleModel dependencyNdkModel;
            NdkFacet dependencyNdkFacet = NdkFacet.getInstance(dependencyModule);
            NdkModuleModel ndkModuleModel = dependencyNdkModel = dependencyNdkFacet == null ? null : BuildVariantUpdater.getNdkModelIfNotJustDummy(dependencyNdkFacet);
            if (dependencyNdkModel != null && (projectVariantWithAbi = BuildVariantUpdater.resolveNewNdkVariant(dependencyNdkModel, projectVariant, abiToSelect)) != null) {
                BuildVariantUpdater.updateAffectedFacetsForNdkModule(dependencyNdkFacet, dependencyNdkModel, projectVariantWithAbi, affectedNdkFacets);
            }
            BuildVariantUpdater.updateAffectedFacetsForAndroidModule(project, dependencyFacet, dependencyModel, projectVariant, abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        }
    }

    @Nullable
    private static String resolveNewNdkVariant(@NotNull NdkModuleModel ndkModel, @NotNull String newVariant, @Nullable String userSelectedAbi) {
        if (ndkModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(43);
        }
        if (newVariant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(44);
        }
        if (userSelectedAbi != null) {
            String ndkVariant = BuildVariantUpdater.getNdkBuildVariantName(newVariant, userSelectedAbi);
            if (ndkModel.getNdkVariantNames().contains(ndkVariant)) {
                return ndkVariant;
            }
        }
        String existingAbi = ndkModel.getAbiName(ndkModel.getSelectedVariant().getName());
        String ndkVariant = BuildVariantUpdater.getNdkBuildVariantName(newVariant, existingAbi);
        if (ndkModel.getNdkVariantNames().contains(ndkVariant)) {
            return ndkVariant;
        }
        String expectedPrefix = newVariant + "-";
        Optional<String> variant = ndkModel.getNdkVariantNames().stream().filter(it -> it.startsWith(expectedPrefix)).findFirst();
        return variant.orElse(null);
    }

    private static boolean hasBuildFilesChanged(@NotNull Project project) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(45);
        }
        return GradleSyncState.getInstance(project).isSyncNeeded().equals((Object)ThreeState.YES);
    }

    private static void requestFullGradleSync(@NotNull Project project, @NotNull Runnable variantSelectionChangeListeners) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(46);
        }
        if (variantSelectionChangeListeners == null) {
            BuildVariantUpdater.$$$reportNull$$$0(47);
        }
        GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_VARIANT_SELECTION_FULL_SYNC, BuildVariantUpdater.getSyncListener(variantSelectionChangeListeners));
    }

    @NotNull
    private static GradleSyncListener getSyncListener(final @NotNull Runnable variantSelectionChangeListeners) {
        if (variantSelectionChangeListeners == null) {
            BuildVariantUpdater.$$$reportNull$$$0(48);
        }
        return new GradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                variantSelectionChangeListeners.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater$1", "syncSucceeded"));
            }
        };
    }

    private static void requestVariantOnlyGradleSync(@NotNull Project project, @NotNull String moduleName2, @NotNull String buildVariantName, @NotNull Runnable variantSelectionChangeListeners) {
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(49);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(50);
        }
        if (buildVariantName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(51);
        }
        if (variantSelectionChangeListeners == null) {
            BuildVariantUpdater.$$$reportNull$$$0(52);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2)) == null) {
            return;
        }
        GradleFacet gradleFacet = GradleFacet.getInstance(moduleToUpdate);
        if (gradleFacet == null) {
            return;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(moduleToUpdate);
        NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNdkModelIfNotJustDummy(moduleToUpdate);
        GradleModuleModel gradleModel = gradleFacet.getGradleModuleModel();
        if (androidModel != null && gradleModel != null) {
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_VARIANT_SELECTION_CHANGED_BY_USER);
            String variantName = buildVariantName;
            String abiName = null;
            if (ndkModuleModel != null) {
                variantName = ndkModuleModel.getVariantName(buildVariantName);
                abiName = ndkModuleModel.getAbiName(buildVariantName);
            }
            request.variantOnlySyncOptions = new VariantOnlySyncOptions(gradleModel.getRootFolderPath(), gradleModel.getGradlePath(), variantName, abiName);
            GradleSyncInvoker.getInstance().requestProjectSync(project, request, BuildVariantUpdater.getSyncListener(variantSelectionChangeListeners));
        }
    }

    private void setupCachedVariant(final @NotNull Project project, final @NotNull List<AndroidFacet> affectedAndroidFacets, final @NotNull List<NdkFacet> affectedNdkFacets, final @NotNull Runnable variantSelectionChangeListeners) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(53);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(54);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(55);
        }
        if (variantSelectionChangeListeners == null) {
            BuildVariantUpdater.$$$reportNull$$$0(56);
        }
        final Application application = ApplicationManager.getApplication();
        Task.Backgroundable task2 = new Task.Backgroundable(project, "Setting up Project", false){
            private double PROGRESS_SETUP_MODULES_START;
            private double PROGRESS_SETUP_MODULES_SIZE;
            private double PROGRESS_SETUP_PROJECT_START;
            private double PROGRESS_SETUP_PROJECT_SIZE;
            private double PROGRESS_COMMIT_START;
            private double PROGRESS_COMMIT_SIZE;
            private double PROGRESS_GENERATE_SOURCES_START;
            {
                super(arg0, arg1, arg2);
                this.PROGRESS_SETUP_MODULES_START = 0.0;
                this.PROGRESS_SETUP_MODULES_SIZE = 0.2;
                this.PROGRESS_SETUP_PROJECT_START = this.PROGRESS_SETUP_MODULES_START + this.PROGRESS_SETUP_MODULES_SIZE;
                this.PROGRESS_SETUP_PROJECT_SIZE = 0.2;
                this.PROGRESS_COMMIT_START = this.PROGRESS_SETUP_PROJECT_START + this.PROGRESS_SETUP_PROJECT_SIZE;
                this.PROGRESS_COMMIT_SIZE = 0.4;
                this.PROGRESS_GENERATE_SOURCES_START = this.PROGRESS_COMMIT_START + this.PROGRESS_COMMIT_SIZE;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                BuildVariantUpdater.getLog().info("Starting setup of cached variant");
                List<IdeModifiableModelsProvider> modelsProviders = this.setUpModules(affectedAndroidFacets, affectedNdkFacets, indicator);
                this.setUpProject(project, indicator);
                this.commitChanges(project, modelsProviders, indicator);
                this.generateSourcesIfNeeded(project, affectedAndroidFacets, indicator);
                if (application.isUnitTestMode()) {
                    variantSelectionChangeListeners.run();
                } else {
                    application.invokeLater(variantSelectionChangeListeners);
                }
                BuildVariantUpdater.getLog().info("Finished setup of cached variant");
            }

            private List<IdeModifiableModelsProvider> setUpModules(@NotNull List<AndroidFacet> affectedAndroidFacets2, @NotNull List<NdkFacet> affectedNdkFacets2, @NotNull ProgressIndicator indicator) {
                if (affectedAndroidFacets2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (affectedNdkFacets2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (indicator == null) {
                    2.$$$reportNull$$$0(3);
                }
                indicator.setIndeterminate(false);
                indicator.setText("Setting up modules");
                indicator.setFraction(this.PROGRESS_SETUP_MODULES_START);
                ArrayList<IdeModifiableModelsProvider> modelsProviders = new ArrayList<IdeModifiableModelsProvider>();
                for (NdkFacet ndkFacet : affectedNdkFacets2) {
                    NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNdkModelIfNotJustDummy(ndkFacet);
                    if (ndkModuleModel == null) continue;
                    modelsProviders.add(BuildVariantUpdater.this.setUpModule(ndkFacet.getModule(), ndkModuleModel));
                }
                for (AndroidFacet androidFacet : affectedAndroidFacets2) {
                    AndroidModuleModel androidModel = BuildVariantUpdater.getAndroidModel(androidFacet);
                    if (androidModel == null) continue;
                    modelsProviders.add(BuildVariantUpdater.this.setUpModule(androidFacet.getModule(), androidModel));
                }
                return modelsProviders;
            }

            private void setUpProject(@NotNull Project project2, @NotNull ProgressIndicator indicator) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (indicator == null) {
                    2.$$$reportNull$$$0(5);
                }
                indicator.setText("Setting up project");
                indicator.setFraction(this.PROGRESS_SETUP_PROJECT_START);
                PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
                PostSyncProjectSetup.getInstance(project2).setUpProject(setupRequest, null, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void commitChanges(@NotNull Project project2, @NotNull List<IdeModifiableModelsProvider> providers2, @NotNull ProgressIndicator indicator) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(6);
                }
                if (providers2 == null) {
                    2.$$$reportNull$$$0(7);
                }
                if (indicator == null) {
                    2.$$$reportNull$$$0(8);
                }
                BatchUpdatesUtil.startBatchUpdate(project2);
                try {
                    this.doCommitChanges(project2, providers2, indicator);
                }
                finally {
                    BatchUpdatesUtil.finishBatchUpdate(project2);
                }
            }

            private void doCommitChanges(@NotNull Project project2, @NotNull List<IdeModifiableModelsProvider> providers2, @NotNull ProgressIndicator indicator) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(9);
                }
                if (providers2 == null) {
                    2.$$$reportNull$$$0(10);
                }
                if (indicator == null) {
                    2.$$$reportNull$$$0(11);
                }
                indicator.setText("Committing changes");
                indicator.setFraction(this.PROGRESS_COMMIT_START);
                double step = this.PROGRESS_COMMIT_SIZE / (double)(providers2.size() + 1);
                double progress = this.PROGRESS_COMMIT_START;
                for (IdeModifiableModelsProvider provider2 : providers2) {
                    GradleProjects.executeProjectChanges(project2, () -> {
                        try {
                            provider2.commit();
                        }
                        catch (Throwable t) {
                            provider2.dispose();
                            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
                        }
                    });
                    indicator.setFraction(progress += step);
                }
            }

            private void generateSourcesIfNeeded(@NotNull Project project2, @NotNull List<AndroidFacet> affectedAndroidFacets2, @NotNull ProgressIndicator indicator) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(12);
                }
                if (affectedAndroidFacets2 == null) {
                    2.$$$reportNull$$$0(13);
                }
                if (indicator == null) {
                    2.$$$reportNull$$$0(14);
                }
                if (!affectedAndroidFacets2.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
                    indicator.setFraction(this.PROGRESS_GENERATE_SOURCES_START);
                    GradleProjectBuilder.getInstance(project2).generateSources();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "affectedAndroidFacets";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "affectedNdkFacets";
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 7: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "providers";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setUpModules";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setUpProject";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commitChanges";
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doCommitChanges";
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[2] = "generateSourcesIfNeeded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (application.isUnitTestMode()) {
            task2.run((ProgressIndicator)new EmptyProgressIndicator());
        } else {
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
        }
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String moduleName2) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(57);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(58);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName2);
    }

    private IdeModifiableModelsProvider setUpModule(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        if (module == null) {
            BuildVariantUpdater.$$$reportNull$$$0(59);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(60);
        }
        IdeModifiableModelsProvider modelsProvider = this.myModifiableModelsProviderFactory.create(module.getProject());
        ModuleSetupContext context = this.myModuleSetupContextFactory.create(module, modelsProvider);
        try {
            this.myAndroidModuleSetupSteps.setUpModule(context, androidModel);
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        return modelsProvider;
    }

    private IdeModifiableModelsProvider setUpModule(@NotNull Module module, @NotNull NdkModuleModel ndkModuleModel) {
        if (module == null) {
            BuildVariantUpdater.$$$reportNull$$$0(61);
        }
        if (ndkModuleModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(62);
        }
        IdeModifiableModelsProvider modelsProvider = this.myModifiableModelsProviderFactory.create(module.getProject());
        ModuleSetupContext context = this.myModuleSetupContextFactory.create(module, modelsProvider);
        try {
            this.myNdkModuleSetupSteps.setUpModule(context, ndkModuleModel);
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        return modelsProvider;
    }

    @Nullable
    private static AndroidModuleModel getAndroidModel(@NotNull AndroidFacet facet2) {
        AndroidModuleModel androidModel;
        if (facet2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(63);
        }
        if ((androidModel = AndroidModuleModel.get(facet2)) == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find AndroidProject for module '%1$s'.", facet2.getModule().getName()));
        }
        return androidModel;
    }

    @Nullable
    private static NdkModuleModel getNdkModelIfNotJustDummy(@NotNull NdkFacet facet2) {
        NdkModuleModel ndkModuleModel;
        if (facet2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(64);
        }
        if ((ndkModuleModel = NdkModuleModel.get(facet2)) == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find NativeAndroidProject for module '%1$s'.", facet2.getModule().getName()));
            return null;
        }
        if (ndkModuleModel.getSelectedVariant().getName().equals("------")) {
            return null;
        }
        return ndkModuleModel;
    }

    @Nullable
    private static NdkModuleModel getNdkModelIfNotJustDummy(@NotNull Module module) {
        NdkModuleModel ndkModuleModel;
        if (module == null) {
            BuildVariantUpdater.$$$reportNull$$$0(65);
        }
        if ((ndkModuleModel = NdkModuleModel.get(module)) == null) {
            return null;
        }
        if (ndkModuleModel.getSelectedVariant().getName().equals("------")) {
            return null;
        }
        return ndkModuleModel;
    }

    private static void logAndShowBuildVariantFailure(@NotNull String reason) {
        if (reason == null) {
            BuildVariantUpdater.$$$reportNull$$$0(66);
        }
        String prefix = "Unable to select build variant:\n";
        String msg = prefix + reason;
        BuildVariantUpdater.getLog().error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }

    private static void logAndShowAbiNameFailure(@NotNull String reason) {
        if (reason == null) {
            BuildVariantUpdater.$$$reportNull$$$0(67);
        }
        String prefix = "Unable to select ABI:\n";
        String msg = prefix + reason;
        BuildVariantUpdater.getLog().error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(BuildVariantUpdater.class);
        if (logger2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(68);
        }
        return logger2;
    }

    @NotNull
    private static String getNdkBuildVariantName(@NotNull String buildVariantNameWithoutAbi, @NotNull String abiName) {
        if (buildVariantNameWithoutAbi == null) {
            BuildVariantUpdater.$$$reportNull$$$0(69);
        }
        if (abiName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(70);
        }
        String string = buildVariantNameWithoutAbi + "-" + abiName;
        if (string == null) {
            BuildVariantUpdater.$$$reportNull$$$0(71);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 68: 
            case 71: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 68: 
            case 71: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSetupContextFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProviderFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModuleSetup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModuleSetup";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 50: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedBuildVariant";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedAbiName";
                break;
            }
            case 16: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildVariantName";
                break;
            }
            case 21: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantToSelect";
                break;
            }
            case 22: 
            case 32: 
            case 36: 
            case 41: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedAndroidFacets";
                break;
            }
            case 23: 
            case 27: 
            case 33: 
            case 37: 
            case 42: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedNdkFacets";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkFacet";
                break;
            }
            case 25: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModuleModel";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 30: 
            case 35: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectVariant";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModel";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVariant";
                break;
            }
            case 47: 
            case 48: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantSelectionChangeListeners";
                break;
            }
            case 59: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildVariantNameWithoutAbi";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abiName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getNdkBuildVariantName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 68: 
            case 71: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectionChangeListener";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedBuildVariant";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedAbi";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedVariant";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setVariantSwitchedProperty";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findAndUpdateAffectedFacets";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateAffectedFacetsForNdkModule";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateAffectedFacetsForAndroidModule";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedVariantsForDependencyModules";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateDependencyModule";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "resolveNewNdkVariant";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "hasBuildFilesChanged";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "requestFullGradleSync";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getSyncListener";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "requestVariantOnlyGradleSync";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "setupCachedVariant";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setUpModule";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidModel";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getNdkModelIfNotJustDummy";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "logAndShowBuildVariantFailure";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "logAndShowAbiNameFailure";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getNdkBuildVariantName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 68: 
            case 71: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class IdeModifiableModelsProviderFactory {
        IdeModifiableModelsProviderFactory() {
        }

        @NotNull
        IdeModifiableModelsProvider create(@NotNull Project project) {
            if (project == null) {
                IdeModifiableModelsProviderFactory.$$$reportNull$$$0(0);
            }
            return new IdeModifiableModelsProviderImpl(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater$IdeModifiableModelsProviderFactory", "create"));
        }
    }
}

