/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.Projects;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.util.PropertiesFiles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalProperties {
    @NotNull
    private final File myPropertiesFilePath;
    @NotNull
    private final File myProjectFolderPath;
    @NotNull
    private final Properties myProperties;
    @Nullable
    private File myNewAndroidSdkPath;
    private boolean myAndroidSdkPathModified;
    @Nullable
    private File myNewAndroidNdkPath;
    private boolean myAndroidNdkPathModified;
    @Nullable
    private File myNewAndroidCmakePath;
    private boolean myAndroidCmakePathModified;

    public LocalProperties(@NotNull Project project) throws IOException {
        if (project == null) {
            LocalProperties.$$$reportNull$$$0(0);
        }
        this(Projects.getBaseDirPath((Project)project));
    }

    public LocalProperties(@NotNull File projectFolderPath) throws IOException {
        if (projectFolderPath == null) {
            LocalProperties.$$$reportNull$$$0(1);
        }
        this.myProjectFolderPath = projectFolderPath;
        this.myPropertiesFilePath = new File(projectFolderPath, "local.properties");
        this.myProperties = PropertiesFiles.getProperties(this.myPropertiesFilePath);
    }

    @Nullable
    public File getAndroidSdkPath() {
        if (this.myAndroidSdkPathModified) {
            return this.myNewAndroidSdkPath;
        }
        return this.getAndroidSdkPathFromFile();
    }

    @Nullable
    public File getAndroidNdkPath() {
        if (this.myAndroidNdkPathModified) {
            return this.myNewAndroidNdkPath;
        }
        return this.getAndroidNdkPathFromFile();
    }

    @Nullable
    public File getAndroidCmakePath() {
        if (this.myAndroidCmakePathModified) {
            return this.myNewAndroidCmakePath;
        }
        return this.getAndroidCmakePathFromFile();
    }

    public void setAndroidSdkPath(@NotNull Sdk androidSdk) {
        if (androidSdk == null) {
            LocalProperties.$$$reportNull$$$0(2);
        }
        String androidSdkPath = androidSdk.getHomePath();
        assert (androidSdkPath != null);
        this.setAndroidSdkPath(androidSdkPath);
    }

    public void setAndroidSdkPath(@NotNull String androidSdkPath) {
        if (androidSdkPath == null) {
            LocalProperties.$$$reportNull$$$0(3);
        }
        this.setAndroidSdkPath(FilePaths.toSystemDependentPath((String)androidSdkPath));
    }

    public void setAndroidSdkPath(@NotNull File androidSdkPath) {
        if (androidSdkPath == null) {
            LocalProperties.$$$reportNull$$$0(4);
        }
        this.myNewAndroidSdkPath = androidSdkPath;
        this.myAndroidSdkPathModified = true;
    }

    public void setAndroidNdkPath(@NotNull String androidNdkPath) {
        if (androidNdkPath == null) {
            LocalProperties.$$$reportNull$$$0(5);
        }
        this.setAndroidNdkPath(FilePaths.toSystemDependentPath((String)androidNdkPath));
    }

    public void setAndroidNdkPath(@Nullable File androidNdkPath) {
        this.myNewAndroidNdkPath = androidNdkPath;
        this.myAndroidNdkPathModified = true;
    }

    public void setAndroidCmakePath(@Nullable File androidNdkPath) {
        this.myNewAndroidCmakePath = androidNdkPath;
        this.myAndroidCmakePathModified = true;
    }

    public boolean hasAndroidDirProperty() {
        String property2 = this.getProperty("android.dir");
        return !Strings.isNullOrEmpty((String)property2);
    }

    @Nullable
    public String getProperty(@NotNull String key) {
        if (key == null) {
            LocalProperties.$$$reportNull$$$0(6);
        }
        return this.myProperties.getProperty(key);
    }

    public void save() throws IOException {
        this.setPathIfApplicable(this.myAndroidSdkPathModified, "sdk.dir", this.getAndroidSdkPathFromFile(), this.myNewAndroidSdkPath);
        this.setPathIfApplicable(this.myAndroidNdkPathModified, "ndk.dir", this.getAndroidNdkPathFromFile(), this.myNewAndroidNdkPath);
        this.setPathIfApplicable(this.myAndroidCmakePathModified, "cmake.dir", this.getAndroidCmakePathFromFile(), this.myNewAndroidCmakePath);
        if (this.myAndroidSdkPathModified || this.myAndroidNdkPathModified || this.myAndroidCmakePathModified) {
            PropertiesFiles.savePropertiesToFile(this.myProperties, this.myPropertiesFilePath, LocalProperties.getHeaderComment());
        }
        this.myNewAndroidNdkPath = null;
        this.myNewAndroidSdkPath = null;
        this.myNewAndroidCmakePath = null;
        this.myAndroidNdkPathModified = false;
        this.myAndroidSdkPathModified = false;
        this.myAndroidCmakePathModified = false;
    }

    private void setPathIfApplicable(boolean pathModified, @NotNull String propertyName, @Nullable File currentPath, @Nullable File newPath) {
        if (propertyName == null) {
            LocalProperties.$$$reportNull$$$0(7);
        }
        if (pathModified && !FileUtil.filesEqual((File)currentPath, (File)newPath)) {
            String path2;
            String string = path2 = newPath != null ? newPath.getPath() : null;
            if (StringUtil.isNotEmpty((String)path2)) {
                this.myProperties.setProperty(propertyName, path2);
            } else {
                this.myProperties.remove(propertyName);
            }
        }
    }

    @Nullable
    private File getAndroidSdkPathFromFile() {
        return this.getPath("sdk.dir");
    }

    @Nullable
    private File getAndroidNdkPathFromFile() {
        return this.getPath("ndk.dir");
    }

    @Nullable
    private File getAndroidCmakePathFromFile() {
        return this.getPath("cmake.dir");
    }

    @Nullable
    private File getPath(String property2) {
        String path2 = this.getProperty(property2);
        if (StringUtil.isNotEmpty((String)path2)) {
            String canonicalPath;
            File file;
            if (!FileUtil.isAbsolute((String)path2) && !(file = new File(canonicalPath = FileUtil.toCanonicalPath((String)new File(this.myProjectFolderPath, FileUtil.toSystemDependentName((String)path2)).getPath()))).isDirectory()) {
                return new File(path2);
            }
            return FilePaths.toSystemDependentPath((String)path2);
        }
        return null;
    }

    @NotNull
    private static String getHeaderComment() {
        Object[] lines = new String[]{"# This file must *NOT* be checked into Version Control Systems,", "# as it contains information specific to your local configuration.", "", "# Location of the SDK. This is only used by Gradle.", "# For customization when using a Version Control System, please read the", "# header note."};
        String string = Joiner.on((String)SystemProperties.getLineSeparator()).join(lines);
        if (string == null) {
            LocalProperties.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public File getPropertiesFilePath() {
        File file = this.myPropertiesFilePath;
        if (file == null) {
            LocalProperties.$$$reportNull$$$0(9);
        }
        return file;
    }

    @VisibleForTesting
    @NotNull
    Properties properties() {
        Properties properties = this.myProperties;
        if (properties == null) {
            LocalProperties.$$$reportNull$$$0(10);
        }
        return properties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFolderPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdk";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdkPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidNdkPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/LocalProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/LocalProperties";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderComment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAndroidSdkPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAndroidNdkPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPathIfApplicable";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

