/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.util.PropertiesFiles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleWrapper {
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Pattern GRADLE_DISTRIBUTION_URL_PATTERN = Pattern.compile(".*/gradle-([^-]+)(-[^\\/\\\\]+)?-(bin|all).zip");
    @NotNull
    private final File myPropertiesFilePath;
    @Nullable
    private final Project myProject;

    @Nullable
    public static GradleWrapper find(@NotNull Project project) {
        String basePath;
        if (project == null) {
            GradleWrapper.$$$reportNull$$$0(0);
        }
        if ((basePath = project.getBasePath()) == null) {
            return null;
        }
        File baseDir = new File(basePath);
        File propertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(baseDir);
        return propertiesFilePath.isFile() ? new GradleWrapper(propertiesFilePath, project) : null;
    }

    @NotNull
    public static GradleWrapper get(@NotNull File propertiesFilePath) {
        if (propertiesFilePath == null) {
            GradleWrapper.$$$reportNull$$$0(1);
        }
        return new GradleWrapper(propertiesFilePath, null);
    }

    public static GradleWrapper create(@NotNull File projectPath) throws IOException {
        if (projectPath == null) {
            GradleWrapper.$$$reportNull$$$0(2);
        }
        return GradleWrapper.create(projectPath, "6.1.1");
    }

    public static GradleWrapper create(@NotNull File projectPath, @NotNull String gradleVersion2) throws IOException {
        File wrapperFolderPath;
        if (projectPath == null) {
            GradleWrapper.$$$reportNull$$$0(3);
        }
        if (gradleVersion2 == null) {
            GradleWrapper.$$$reportNull$$$0(4);
        }
        if (!(wrapperFolderPath = new File(projectPath, SdkConstants.FD_GRADLE_WRAPPER)).isDirectory()) {
            File srcFolderPath = new File(TemplateManager.getTemplateRootFolder(), SdkConstants.FD_GRADLE_WRAPPER);
            if (!srcFolderPath.exists()) {
                File root2;
                Iterator<File> iterator = TemplateManager.getExtraTemplateRootFolders().iterator();
                while (iterator.hasNext() && !(srcFolderPath = new File(root2 = iterator.next(), SdkConstants.FD_GRADLE_WRAPPER)).exists()) {
                    srcFolderPath = null;
                }
            }
            if (srcFolderPath == null) {
                return null;
            }
            FileUtil.copyDirContent((File)srcFolderPath, (File)projectPath);
        }
        File propertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(projectPath);
        GradleWrapper gradleWrapper = GradleWrapper.get(propertiesFilePath);
        gradleWrapper.updateDistributionUrl(gradleVersion2);
        return gradleWrapper;
    }

    private GradleWrapper(@NotNull File propertiesFilePath, @Nullable Project project) {
        if (propertiesFilePath == null) {
            GradleWrapper.$$$reportNull$$$0(5);
        }
        this.myProject = project;
        this.myPropertiesFilePath = propertiesFilePath;
    }

    @NotNull
    public File getPropertiesFilePath() {
        File file = this.myPropertiesFilePath;
        if (file == null) {
            GradleWrapper.$$$reportNull$$$0(6);
        }
        return file;
    }

    @Nullable
    public VirtualFile getPropertiesFile() {
        return VfsUtil.findFileByIoFile((File)this.myPropertiesFilePath, (boolean)true);
    }

    @NotNull
    public static File getDefaultPropertiesFilePath(@NotNull File projectPath) {
        if (projectPath == null) {
            GradleWrapper.$$$reportNull$$$0(7);
        }
        return new File(projectPath, GRADLEW_PROPERTIES_PATH);
    }

    public boolean updateDistributionUrlAndDisplayFailure(@NotNull String gradleVersion2) {
        if (gradleVersion2 == null) {
            GradleWrapper.$$$reportNull$$$0(8);
        }
        try {
            boolean updated = this.updateDistributionUrl(gradleVersion2);
            if (updated) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)this.myPropertiesFilePath, (boolean)true);
                if (virtualFile != null) {
                    virtualFile.refresh(false, false);
                }
                return true;
            }
        }
        catch (IOException e) {
            Object msg = String.format("Unable to update Gradle wrapper to use Gradle %1$s\n", gradleVersion2);
            msg = (String)msg + e.getMessage();
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
        }
        return false;
    }

    public boolean updateDistributionUrl(@NotNull String gradleVersion2) throws IOException {
        if (gradleVersion2 == null) {
            GradleWrapper.$$$reportNull$$$0(9);
        }
        Properties properties = this.getProperties();
        String distributionUrl = GradleWrapper.getDistributionUrl(gradleVersion2, false);
        String property2 = properties.getProperty("distributionUrl");
        if (property2 != null && (property2.equals(distributionUrl) || property2.equals(GradleWrapper.getDistributionUrl(gradleVersion2, true)))) {
            return false;
        }
        properties.setProperty("distributionUrl", distributionUrl);
        PropertiesFiles.savePropertiesToFile(properties, this.myPropertiesFilePath, null);
        return true;
    }

    public void updateDistributionUrl(@NotNull File gradleDistribution) throws IOException {
        String path2;
        if (gradleDistribution == null) {
            GradleWrapper.$$$reportNull$$$0(10);
        }
        if (!FileUtilRt.extensionEquals((String)(path2 = gradleDistribution.getPath()), (String)"zip")) {
            throw new IllegalArgumentException("'" + path2 + "' should be a zip file");
        }
        Properties properties = this.getProperties();
        properties.setProperty("distributionUrl", gradleDistribution.toURI().toURL().toString());
        PropertiesFiles.savePropertiesToFile(properties, this.myPropertiesFilePath, null);
    }

    @NotNull
    public Properties getProperties() throws IOException {
        Properties properties = PropertiesFiles.getProperties(this.myPropertiesFilePath);
        if (properties == null) {
            GradleWrapper.$$$reportNull$$$0(11);
        }
        return properties;
    }

    @Nullable
    public String getGradleVersion() throws IOException {
        Matcher m;
        String url = this.getProperties().getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @Nullable
    public String getGradleFullVersion() throws IOException {
        Matcher m;
        String url = this.getProperties().getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1) + Strings.nullToEmpty((String)m.group(2));
        }
        return null;
    }

    @Nullable
    public String getDistributionSha256Sum() throws IOException {
        return this.getProperties().getProperty("distributionSha256Sum");
    }

    @Nullable
    public String getDistributionUrl() throws IOException {
        return this.getProperties().getProperty("distributionUrl");
    }

    @VisibleForTesting
    @NotNull
    static String getDistributionUrl(@NotNull String gradleVersion2, boolean binOnly) {
        if (gradleVersion2 == null) {
            GradleWrapper.$$$reportNull$$$0(12);
        }
        String folderName = GradleWrapper.isSnapshot(gradleVersion2) ? "distributions-snapshots" : "distributions";
        String suffix = binOnly ? "bin" : "all";
        String string = String.format("https://services.gradle.org/%1$s/gradle-%2$s-%3$s.zip", folderName, gradleVersion2, suffix);
        if (string == null) {
            GradleWrapper.$$$reportNull$$$0(13);
        }
        return string;
    }

    @VisibleForTesting
    static boolean isSnapshot(@NotNull String gradleVersion2) {
        if (gradleVersion2 == null) {
            GradleWrapper.$$$reportNull$$$0(14);
        }
        return gradleVersion2.indexOf(45) != -1 && gradleVersion2.endsWith("+0000");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFilePath";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/GradleWrapper";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleDistribution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/GradleWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistributionUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPropertiesFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateDistributionUrlAndDisplayFailure";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateDistributionUrl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDistributionUrl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSnapshot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

