/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.level2.IdeDependencies;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.utils.BuildScriptUtil;
import com.android.utils.FileUtils;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import icons.StudioIcons;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleUtil {
    public static final ProjectSystemId GRADLE_SYSTEM_ID = GradleConstants.SYSTEM_ID;
    @NonNls
    public static final String BUILD_DIR_DEFAULT_NAME = "build";
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Logger LOG = Logger.getInstance(GradleUtil.class);
    private static final CharMatcher ILLEGAL_GRADLE_PATH_CHARS_MATCHER = CharMatcher.anyOf((CharSequence)"\\/");
    private static final Pattern PLUGIN_VERSION_PATTERN = Pattern.compile("[012]\\..*");

    private GradleUtil() {
    }

    @NotNull
    public static File getCacheFolderRootPath(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(0);
        }
        return new File(project.getBasePath(), FileUtil.join((String[])new String[]{".idea", "caches"}));
    }

    public static boolean isSupportedGradleVersion(@NotNull GradleVersion gradleVersion2) {
        GradleVersion supported;
        if (gradleVersion2 == null) {
            GradleUtil.$$$reportNull$$$0(1);
        }
        return (supported = GradleVersion.parse((String)"6.1.1")).compareTo(gradleVersion2) <= 0;
    }

    @Deprecated
    @NotNull
    public static AndroidArtifactOutput getOutput(@NotNull AndroidArtifact artifact) {
        if (artifact == null) {
            GradleUtil.$$$reportNull$$$0(2);
        }
        Collection outputs = artifact.getOutputs();
        assert (!outputs.isEmpty());
        AndroidArtifactOutput output = (AndroidArtifactOutput)ContainerUtil.getFirstItem((Collection)outputs);
        assert (output != null);
        AndroidArtifactOutput androidArtifactOutput = output;
        if (androidArtifactOutput == null) {
            GradleUtil.$$$reportNull$$$0(3);
        }
        return androidArtifactOutput;
    }

    @NotNull
    public static Icon getModuleIcon(@NotNull Module module) {
        AndroidModuleModel androidModel;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(4);
        }
        if ((androidModel = AndroidModuleModel.get(module)) != null) {
            return GradleUtil.getAndroidModuleIcon(androidModel);
        }
        Icon icon2 = AndroidProjectInfo.getInstance(module.getProject()).requiresAndroidModel() ? AllIcons.Nodes.PpJdk : StudioIcons.Shell.Filetree.ANDROID_MODULE;
        if (icon2 == null) {
            GradleUtil.$$$reportNull$$$0(5);
        }
        return icon2;
    }

    @NotNull
    public static Icon getAndroidModuleIcon(@NotNull AndroidModuleModel androidModuleModel) {
        if (androidModuleModel == null) {
            GradleUtil.$$$reportNull$$$0(6);
        }
        return GradleUtil.getAndroidModuleIcon(androidModuleModel.getAndroidProject().getProjectType());
    }

    @NotNull
    public static Icon getAndroidModuleIcon(int androidProjectType) {
        switch (androidProjectType) {
            case 0: {
                Icon icon2 = StudioIcons.Shell.Filetree.ANDROID_MODULE;
                if (icon2 == null) {
                    GradleUtil.$$$reportNull$$$0(7);
                }
                return icon2;
            }
            case 5: {
                Icon icon3 = StudioIcons.Shell.Filetree.FEATURE_MODULE;
                if (icon3 == null) {
                    GradleUtil.$$$reportNull$$$0(8);
                }
                return icon3;
            }
            case 4: {
                Icon icon4 = StudioIcons.Shell.Filetree.INSTANT_APPS;
                if (icon4 == null) {
                    GradleUtil.$$$reportNull$$$0(9);
                }
                return icon4;
            }
            case 1: {
                Icon icon5 = StudioIcons.Shell.Filetree.LIBRARY_MODULE;
                if (icon5 == null) {
                    GradleUtil.$$$reportNull$$$0(10);
                }
                return icon5;
            }
            case 2: {
                Icon icon6 = StudioIcons.Shell.Filetree.ANDROID_TEST_ROOT;
                if (icon6 == null) {
                    GradleUtil.$$$reportNull$$$0(11);
                }
                return icon6;
            }
        }
        Icon icon7 = StudioIcons.Shell.Filetree.ANDROID_MODULE;
        if (icon7 == null) {
            GradleUtil.$$$reportNull$$$0(12);
        }
        return icon7;
    }

    @Nullable
    public static IdeAndroidProject getAndroidProject(@NotNull Module module) {
        AndroidModuleModel gradleModel;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(13);
        }
        return (gradleModel = AndroidModuleModel.get(module)) != null ? gradleModel.getAndroidProject() : null;
    }

    @Nullable
    public static NativeAndroidProject getNativeAndroidProject(@NotNull Module module) {
        NdkModuleModel ndkModuleModel;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(14);
        }
        return (ndkModuleModel = NdkModuleModel.get(module)) != null ? ndkModuleModel.getAndroidProject() : null;
    }

    @Nullable
    public static String getGradlePath(@NotNull Module module) {
        GradleFacet facet2;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(15);
        }
        return (facet2 = GradleFacet.getInstance(module)) != null ? ((GradleFacetConfiguration)facet2.getConfiguration()).GRADLE_PROJECT_PATH : null;
    }

    public static boolean isRootModuleWithNoSources(@NotNull Module module) {
        String gradlePath;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(16);
        }
        if (ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 0 && ((gradlePath = GradleUtil.getGradlePath(module)) == null || gradlePath.equals(":"))) {
            return ModuleManager.getInstance((Project)module.getProject()).getModuleGrouper(null).getGroupPath(module).size() <= 1;
        }
        return false;
    }

    @NotNull
    public static List<Library> getModuleDependencies(@NotNull IdeVariant variant) {
        if (variant == null) {
            GradleUtil.$$$reportNull$$$0(17);
        }
        ArrayList libraries = new ArrayList();
        IdeAndroidArtifact mainArtifact = variant.getMainArtifact();
        IdeDependencies dependencies2 = mainArtifact.getLevel2Dependencies();
        libraries.addAll(dependencies2.getModuleDependencies());
        for (IdeBaseArtifact testArtifact : variant.getTestArtifacts()) {
            dependencies2 = testArtifact.getLevel2Dependencies();
            libraries.addAll(dependencies2.getModuleDependencies());
        }
        List<Library> list = libraries.stream().distinct().collect(Collectors.toList());
        if (list == null) {
            GradleUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Nullable
    public static Module findModuleByGradlePath(@NotNull Project project, @NotNull String gradlePath) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(19);
        }
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(20);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null || !gradlePath.equals(((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH)) continue;
            return module;
        }
        return null;
    }

    @NotNull
    public static List<String> getPathSegments(@NotNull String gradlePath) {
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(21);
        }
        List list = Splitter.on((String)":").omitEmptyStrings().splitToList((CharSequence)gradlePath);
        if (list == null) {
            GradleUtil.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull Module module) {
        GradleModuleModel moduleModel;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(23);
        }
        if ((moduleModel = GradleUtil.getGradleModuleModel(module)) != null) {
            return moduleModel.getBuildFile();
        }
        File moduleRoot = AndroidRootUtil.findModuleRootFolderPath(module);
        return moduleRoot != null ? GradleUtil.getGradleBuildFile(moduleRoot) : null;
    }

    public static boolean isGradleScript(@NotNull VirtualFile file) {
        if (file == null) {
            GradleUtil.$$$reportNull$$$0(24);
        }
        return !file.isDirectory() && (file.getName().endsWith("gradle") || file.getName().endsWith("gradle.kts"));
    }

    @Nullable
    public static VirtualFile findGradleBuildFile(@NotNull VirtualFile parentDir) {
        if (parentDir == null) {
            GradleUtil.$$$reportNull$$$0(25);
        }
        return GradleUtil.findFileWithNames(parentDir, "build.gradle", "build.gradle.kts");
    }

    @Nullable
    public static VirtualFile findGradleSettingsFile(@NotNull VirtualFile parentDir) {
        if (parentDir == null) {
            GradleUtil.$$$reportNull$$$0(26);
        }
        return GradleUtil.findFileWithNames(parentDir, "settings.gradle", "settings.gradle.kts");
    }

    @Nullable
    private static VirtualFile findFileWithNames(@NotNull VirtualFile parentDir, String ... names) {
        if (parentDir == null) {
            GradleUtil.$$$reportNull$$$0(27);
        }
        if (names == null) {
            GradleUtil.$$$reportNull$$$0(28);
        }
        for (String name : names) {
            VirtualFile file = parentDir.findChild(name);
            if (file == null || file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    @Nullable
    private static GradleModuleModel getGradleModuleModel(Module module) {
        GradleFacet gradleFacet = GradleFacet.getInstance(module);
        if (gradleFacet == null) {
            return null;
        }
        return gradleFacet.getGradleModuleModel();
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        File gradleBuildFilePath;
        VirtualFile result2;
        if (dirPath == null) {
            GradleUtil.$$$reportNull$$$0(29);
        }
        return (result2 = VfsUtil.findFileByIoFile((File)(gradleBuildFilePath = BuildScriptUtil.findGradleBuildFile((File)dirPath)), (boolean)false)) != null && result2.isValid() ? result2 : null;
    }

    @Nullable
    public static VirtualFile getGradleSettingsFile(@NotNull File dirPath) {
        File gradleSettingsFilePath;
        VirtualFile result2;
        if (dirPath == null) {
            GradleUtil.$$$reportNull$$$0(30);
        }
        return (result2 = VfsUtil.findFileByIoFile((File)(gradleSettingsFilePath = BuildScriptUtil.findGradleSettingsFile((File)dirPath)), (boolean)false)) != null && result2.isValid() ? result2 : null;
    }

    @NotNull
    public static GradleExecutionSettings getOrCreateGradleExecutionSettings(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(31);
        }
        GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(project);
        if (IdeInfo.getInstance().isAndroidStudio()) {
            File jdkPath;
            if (executionSettings == null) {
                File gradlePath = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionPath();
                assert (gradlePath != null && gradlePath.isDirectory());
                executionSettings = new GradleExecutionSettings(gradlePath.getPath(), null, DistributionType.LOCAL, null, false);
            }
            if ((jdkPath = IdeSdks.getInstance().getJdkPath()) != null) {
                executionSettings.setJavaHome(jdkPath.getPath());
            }
        }
        if (executionSettings == null) {
            executionSettings = new GradleExecutionSettings(null, null, DistributionType.BUNDLED, null, false);
        }
        GradleExecutionSettings gradleExecutionSettings = executionSettings;
        if (gradleExecutionSettings == null) {
            GradleUtil.$$$reportNull$$$0(32);
        }
        return gradleExecutionSettings;
    }

    @Nullable
    public static GradleExecutionSettings getGradleExecutionSettings(@NotNull Project project) {
        GradleProjectSettings projectSettings;
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(33);
        }
        if ((projectSettings = GradleUtil.getGradleProjectSettings(project)) == null) {
            File baseDirPath = Projects.getBaseDirPath((Project)project);
            String msg = String.format("Unable to obtain Gradle project settings for project '%1$s', located at '%2$s'", project.getName(), baseDirPath.getPath());
            LOG.info(msg);
            return null;
        }
        try {
            return (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectSettings.getExternalProjectPath(), (ProjectSystemId)GRADLE_SYSTEM_ID);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Failed to obtain Gradle execution settings", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static GradleProjectSettings getGradleProjectSettings(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(34);
        }
        return GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
    }

    @VisibleForTesting
    @Nullable
    static String getGradleInvocationJvmArg(@Nullable BuildMode buildMode) {
        if (BuildMode.ASSEMBLE_TRANSLATE == buildMode) {
            return AndroidGradleSettings.createJvmArg((String)"enableTranslation", (boolean)true);
        }
        return null;
    }

    public static void stopAllGradleDaemonsAndRestart() {
        DefaultGradleConnector.close();
        Application application = ApplicationManager.getApplication();
        if (application instanceof ApplicationEx) {
            ((ApplicationEx)application).restart(true);
        } else {
            application.restart();
        }
    }

    @NotNull
    public static String getDefaultPhysicalPathFromGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(35);
        }
        List<String> segments = GradleUtil.getPathSegments(gradlePath);
        String string = FileUtil.join((String[])ArrayUtilRt.toStringArray(segments));
        if (string == null) {
            GradleUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    public static boolean isDirectChild(String childPath, String parentPath) {
        List<String> childSegments = GradleUtil.getPathSegments(childPath);
        return !childSegments.isEmpty() && childSegments.subList(0, childSegments.size() - 1).equals(GradleUtil.getPathSegments(parentPath));
    }

    @NotNull
    public static Set<String> getAllParentModulesPaths(@NotNull String gradlePath) {
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(37);
        }
        ImmutableSet.Builder result2 = ImmutableSet.builder();
        String parentPath = GradleUtil.getParentModulePath(gradlePath);
        while (!parentPath.isEmpty()) {
            result2.add((Object)parentPath);
            parentPath = GradleUtil.getParentModulePath(parentPath);
        }
        ImmutableSet immutableSet = result2.build();
        if (immutableSet == null) {
            GradleUtil.$$$reportNull$$$0(38);
        }
        return immutableSet;
    }

    @NotNull
    public static String getParentModulePath(@NotNull String gradlePath) {
        int parentPathEnd;
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(39);
        }
        if ((parentPathEnd = gradlePath.lastIndexOf(":")) <= 0) {
            return "";
        }
        String string = gradlePath.substring(0, parentPathEnd);
        if (string == null) {
            GradleUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    public static Path getModuleDefaultPath(@NotNull Path parentDir, @NotNull String gradlePath) {
        if (parentDir == null) {
            GradleUtil.$$$reportNull$$$0(41);
        }
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(42);
        }
        assert (!gradlePath.isEmpty());
        Path path2 = parentDir.resolve(GradleUtil.getDefaultPhysicalPathFromGradlePath(gradlePath));
        if (path2 == null) {
            GradleUtil.$$$reportNull$$$0(43);
        }
        return path2;
    }

    public static int isValidGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(44);
        }
        return ILLEGAL_GRADLE_PATH_CHARS_MATCHER.indexIn((CharSequence)gradlePath);
    }

    public static boolean hasModule(@Nullable Project project, @NotNull String gradlePath) {
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(45);
        }
        if (project == null) {
            return false;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!gradlePath.equals(GradleUtil.getGradlePath(module))) continue;
            return true;
        }
        Path location = GradleUtil.getModuleDefaultPath(Paths.get(project.getBasePath(), new String[0]), gradlePath);
        if (Files.isRegularFile(location, new LinkOption[0])) {
            return true;
        }
        if (Files.isDirectory(location, new LinkOption[0])) {
            File[] children = location.toFile().listFiles();
            return children == null || children.length > 0;
        }
        return false;
    }

    @Nullable
    public static GradleVersion getAndroidGradleModelVersionInUse(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(46);
        }
        HashSet<String> foundInLibraries = new HashSet<String>();
        HashSet<String> foundInApps = new HashSet<String>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null) continue;
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            String modelVersion = androidProject.getModelVersion();
            if (androidModel.getAndroidProject().getProjectType() == 0) {
                foundInApps.add(modelVersion);
                continue;
            }
            foundInLibraries.add(modelVersion);
        }
        String found = null;
        if (foundInApps.size() == 1) {
            found = (String)Iterables.getOnlyElement(foundInApps);
        } else if (foundInApps.isEmpty() && foundInLibraries.size() == 1) {
            found = (String)Iterables.getOnlyElement(foundInLibraries);
        }
        return found != null ? GradleVersion.tryParse((String)found) : null;
    }

    @Nullable
    public static GradleVersion getAndroidGradleModelVersionInUse(@NotNull Module module) {
        AndroidModuleModel androidModel;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(47);
        }
        if ((androidModel = AndroidModuleModel.get(module)) != null) {
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            return GradleVersion.tryParse((String)androidProject.getModelVersion());
        }
        return null;
    }

    public static void attemptToUseEmbeddedGradle(@NotNull Project project) {
        GradleWrapper gradleWrapper;
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(48);
        }
        if (IdeInfo.getInstance().isAndroidStudio() && (gradleWrapper = GradleWrapper.find(project)) != null) {
            GradleProjectSettings gradleSettings;
            File embeddedGradlePath;
            String gradleVersion2 = null;
            try {
                Properties properties = gradleWrapper.getProperties();
                String url = properties.getProperty("distributionUrl");
                gradleVersion2 = GradleUtil.getGradleWrapperVersionOnlyIfComingForGradleDotOrg(url);
            }
            catch (IOException e) {
                LOG.warn("Failed to read file " + gradleWrapper.getPropertiesFilePath().getPath());
            }
            if (gradleVersion2 != null && GradleUtil.isCompatibleWithEmbeddedGradleVersion(gradleVersion2) && !GradleLocalCache.getInstance().containsGradleWrapperVersion(gradleVersion2, project) && (embeddedGradlePath = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionPath()) != null && (gradleSettings = GradleUtil.getGradleProjectSettings(project)) != null) {
                gradleSettings.setDistributionType(DistributionType.LOCAL);
                gradleSettings.setGradleHome(embeddedGradlePath.getPath());
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static String getGradleWrapperVersionOnlyIfComingForGradleDotOrg(@Nullable String url) {
        String version2;
        String expectedPrefix;
        String protocol;
        int foundIndex;
        if (url != null && (foundIndex = url.indexOf("://")) != -1 && ((protocol = url.substring(0, foundIndex)).equals("http") || protocol.equals("https")) && url.startsWith(expectedPrefix = protocol + "://services.gradle.org/distributions/gradle-") && (foundIndex = url.indexOf(45, expectedPrefix.length())) != -1 && StringUtil.isNotEmpty((String)(version2 = url.substring(expectedPrefix.length(), foundIndex)))) {
            return version2;
        }
        return null;
    }

    private static boolean isCompatibleWithEmbeddedGradleVersion(@NotNull String gradleVersion2) {
        if (gradleVersion2 == null) {
            GradleUtil.$$$reportNull$$$0(49);
        }
        return gradleVersion2.equals("6.1.1") || gradleVersion2.equals("6.1.1");
    }

    public static boolean dependsOn(AndroidModuleModel androidModel, String artifact) {
        IdeDependencies dependencies2 = androidModel.getSelectedMainCompileLevel2Dependencies();
        return GradleUtil.dependsOnAndroidLibrary(dependencies2, artifact);
    }

    public static boolean dependsOnJavaLibrary(AndroidModuleModel androidModel, String artifact) {
        IdeDependencies dependencies2 = androidModel.getSelectedMainCompileLevel2Dependencies();
        for (Library library : dependencies2.getJavaLibraries()) {
            if (!GradleUtil.dependsOn(library, artifact)) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOnAndroidTest(AndroidModuleModel androidModel, String artifact) {
        IdeDependencies dependencies2 = androidModel.getSelectedAndroidTestCompileDependencies();
        if (dependencies2 == null) {
            return false;
        }
        return GradleUtil.dependsOnAndroidLibrary(dependencies2, artifact);
    }

    private static boolean dependsOnAndroidLibrary(IdeDependencies dependencies2, String artifact) {
        for (Library library : dependencies2.getAndroidLibraries()) {
            if (!GradleUtil.dependsOn(library, artifact)) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOn(AndroidLibrary library, String artifact, boolean transitively) {
        return GradleUtil.getDependencyVersion(library, artifact, transitively) != null;
    }

    private static String getDependencyVersion(AndroidLibrary library, String artifact, boolean transitively) {
        MavenCoordinates resolvedCoordinates = library.getResolvedCoordinates();
        if (resolvedCoordinates != null && artifact.endsWith(resolvedCoordinates.getArtifactId()) && artifact.equals(resolvedCoordinates.getGroupId() + ":" + resolvedCoordinates.getArtifactId())) {
            return resolvedCoordinates.getVersion();
        }
        if (transitively) {
            for (AndroidLibrary dependency : library.getLibraryDependencies()) {
                String version2 = GradleUtil.getDependencyVersion(dependency, artifact, true);
                if (version2 == null) continue;
                return version2;
            }
        }
        return null;
    }

    public static boolean dependsOn(Library library, String artifact) {
        return GradleUtil.getDependencyVersion(library, artifact) != null;
    }

    private static String getDependencyVersion(Library library, String artifact) {
        GradleCoordinate resolvedCoordinates = GradleCoordinate.parseCoordinateString((String)library.getArtifactAddress());
        if (resolvedCoordinates != null && artifact.equals(resolvedCoordinates.getGroupId() + ":" + resolvedCoordinates.getArtifactId())) {
            return resolvedCoordinates.getRevision();
        }
        return null;
    }

    public static boolean hasCause(@NotNull Throwable e, @NotNull Class<?> causeClass) {
        if (e == null) {
            GradleUtil.$$$reportNull$$$0(50);
        }
        if (causeClass == null) {
            GradleUtil.$$$reportNull$$$0(51);
        }
        String causeClassName = causeClass.getName();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!causeClassName.equals(ex.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static File getGradleUserSettingsFile() {
        String homePath = SystemProperties.getUserHome();
        if (homePath == null) {
            return null;
        }
        return new File(homePath, FileUtil.join((String[])new String[]{".gradle", "gradle.properties"}));
    }

    @Nullable
    public static Library findLibrary(@NotNull File bundleDir, @NotNull IdeVariant variant) {
        if (bundleDir == null) {
            GradleUtil.$$$reportNull$$$0(52);
        }
        if (variant == null) {
            GradleUtil.$$$reportNull$$$0(53);
        }
        IdeAndroidArtifact artifact = variant.getMainArtifact();
        IdeDependencies dependencies2 = artifact.getLevel2Dependencies();
        for (Library library : dependencies2.getAndroidLibraries()) {
            if (!FileUtil.filesEqual((File)bundleDir, (File)library.getFolder())) continue;
            return library;
        }
        return null;
    }

    @NotNull
    public static String mapConfigurationName(@NotNull String configuration, @Nullable GradleVersion pluginVersion, boolean preferApi) {
        if (configuration == null) {
            GradleUtil.$$$reportNull$$$0(54);
        }
        return GradleUtil.mapConfigurationName(configuration, pluginVersion != null ? pluginVersion.toString() : null, preferApi);
    }

    @NotNull
    public static String mapConfigurationName(@NotNull String configuration, @Nullable String pluginVersion, boolean preferApi) {
        if (configuration == null) {
            GradleUtil.$$$reportNull$$$0(55);
        }
        boolean compatibilityNames = pluginVersion != null && PLUGIN_VERSION_PATTERN.matcher(pluginVersion).matches();
        return GradleUtil.mapConfigurationName(configuration, compatibilityNames, preferApi);
    }

    @NotNull
    private static String mapConfigurationName(@NotNull String configuration, boolean useCompatibilityNames, boolean preferApi) {
        if (configuration == null) {
            GradleUtil.$$$reportNull$$$0(56);
        }
        if (useCompatibilityNames) {
            String string = configuration;
            if (string == null) {
                GradleUtil.$$$reportNull$$$0(57);
            }
            return string;
        }
        configuration = GradleUtil.replaceSuffixWithCase(configuration, "compile", preferApi ? "api" : "implementation");
        configuration = GradleUtil.replaceSuffixWithCase(configuration, "provided", "compileOnly");
        String string = configuration = GradleUtil.replaceSuffixWithCase(configuration, "apk", "runtimeOnly");
        if (string == null) {
            GradleUtil.$$$reportNull$$$0(58);
        }
        return string;
    }

    public static boolean useCompatibilityConfigurationNames(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(59);
        }
        return GradleUtil.useCompatibilityConfigurationNames(GradleUtil.getAndroidGradleModelVersionInUse(project));
    }

    public static boolean useCompatibilityConfigurationNames(@Nullable GradleVersion gradleVersion2) {
        return gradleVersion2 != null && gradleVersion2.getMajor() < 3;
    }

    private static String replaceSuffixWithCase(String s, String suffix, String newSuffix) {
        if (SdkUtils.endsWithIgnoreCase((String)s, (String)suffix)) {
            int suffixBegin = s.length() - suffix.length();
            if (Character.isUpperCase(s.charAt(suffixBegin))) {
                return s.substring(0, suffixBegin) + Character.toUpperCase(newSuffix.charAt(0)) + newSuffix.substring(1);
            }
            if (suffixBegin == 0) {
                return newSuffix;
            }
            return s.substring(0, suffixBegin) + suffix;
        }
        return s;
    }

    public static boolean isAaptGeneratedSourcesFolder(@NotNull File folder, @NotNull File buildFolder) {
        if (folder == null) {
            GradleUtil.$$$reportNull$$$0(60);
        }
        if (buildFolder == null) {
            GradleUtil.$$$reportNull$$$0(61);
        }
        File generatedFolder = new File(buildFolder, "generated");
        File generatedSourceR = FileUtils.join((File)generatedFolder, (String[])new String[]{"source", "r"});
        File rClassSources = new File(generatedFolder, "not_namespaced_r_class_sources");
        return FileUtil.isAncestor((File)generatedSourceR, (File)folder, (boolean)false) || FileUtil.isAncestor((File)rClassSources, (File)folder, (boolean)false);
    }

    @VisibleForTesting
    public static boolean isDataBindingGeneratedBaseClassesFolder(@NotNull File folder, @NotNull File buildFolder) {
        if (folder == null) {
            GradleUtil.$$$reportNull$$$0(62);
        }
        if (buildFolder == null) {
            GradleUtil.$$$reportNull$$$0(63);
        }
        File generatedFolder = new File(buildFolder, "generated");
        File dataBindingSources = new File(generatedFolder, "data_binding_base_class_source_out");
        return FileUtil.isAncestor((File)dataBindingSources, (File)folder, (boolean)false);
    }

    public static Collection<File> getGeneratedSourceFoldersToUse(@NotNull IdeBaseArtifact artifact, @NotNull AndroidModuleModel model2) {
        if (artifact == null) {
            GradleUtil.$$$reportNull$$$0(64);
        }
        if (model2 == null) {
            GradleUtil.$$$reportNull$$$0(65);
        }
        File buildFolder = model2.getAndroidProject().getBuildFolder();
        return artifact.getGeneratedSourceFolders().stream().filter(folder -> !GradleUtil.isAaptGeneratedSourcesFolder(folder, buildFolder)).filter(folder -> !GradleUtil.isDataBindingGeneratedBaseClassesFolder(folder, buildFolder)).collect(Collectors.toList());
    }

    public static Set<String> projectBuildFilesTypes(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(66);
        }
        HashSet<String> result2 = new HashSet<String>();
        GradleUtil.addBuildFileType(result2, GradleUtil.getGradleBuildFile(Projects.getBaseDirPath((Project)project)));
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            GradleUtil.addBuildFileType(result2, GradleUtil.getGradleBuildFile(module));
        }
        return result2;
    }

    public static boolean hasKtsBuildFiles(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(67);
        }
        return GradleUtil.projectBuildFilesTypes(project).contains(".kts");
    }

    public static boolean isKtsFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        HashSet<String> result2 = new HashSet<String>();
        GradleUtil.addBuildFileType(result2, file);
        return result2.contains(".kts");
    }

    private static void addBuildFileType(@NotNull HashSet<String> result2, @Nullable VirtualFile buildFile) {
        if (result2 == null) {
            GradleUtil.$$$reportNull$$$0(68);
        }
        if (buildFile != null) {
            Object buildFileExtension = buildFile.getExtension();
            if (buildFileExtension == null) {
                return;
            }
            if (((String)(buildFileExtension = "." + (String)buildFileExtension)).equalsIgnoreCase(".gradle")) {
                result2.add(".gradle");
            } else if (((String)buildFileExtension).equalsIgnoreCase(".kts")) {
                result2.add(".kts");
            }
        }
    }

    @Nullable
    public static String getLastKnownAndroidGradlePluginVersion(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(69);
        }
        for (Module module : ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(GradleFacet.getFacetTypeId())) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null) continue;
            GradleFacetConfiguration configuration = (GradleFacetConfiguration)gradleFacet.getConfiguration();
            String version2 = configuration.LAST_KNOWN_AGP_VERSION;
            if (version2 == null) continue;
            return version2;
        }
        return null;
    }

    @Nullable
    public static String getLastSuccessfulAndroidGradlePluginVersion(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(70);
        }
        for (Module module : ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(GradleFacet.getFacetTypeId())) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null) continue;
            GradleFacetConfiguration configuration = (GradleFacetConfiguration)gradleFacet.getConfiguration();
            String version2 = configuration.LAST_SUCCESSFUL_SYNC_AGP_VERSION;
            if (version2 == null) continue;
            return version2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 22: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 57: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 22: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 57: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 2: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 22: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/GradleUtil";
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModuleModel";
                break;
            }
            case 17: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 20: 
            case 21: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "causeClass";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleDir";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFolder";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/GradleUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutput";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleIcon";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidModuleIcon";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependencies";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathSegments";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateGradleExecutionSettings";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPhysicalPathFromGradlePath";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllParentModulesPaths";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentModulePath";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDefaultPath";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "mapConfigurationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCacheFolderRootPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedGradleVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOutput";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 22: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 57: 
            case 58: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidModuleIcon";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidProject";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNativeAndroidProject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getGradlePath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isRootModuleWithNoSources";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDependencies";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByGradlePath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPathSegments";
                break;
            }
            case 23: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getGradleBuildFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isGradleScript";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findGradleBuildFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findGradleSettingsFile";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findFileWithNames";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getGradleSettingsFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateGradleExecutionSettings";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getGradleExecutionSettings";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getGradleProjectSettings";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPhysicalPathFromGradlePath";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getAllParentModulesPaths";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getParentModulePath";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDefaultPath";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isValidGradlePath";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "hasModule";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidGradleModelVersionInUse";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "attemptToUseEmbeddedGradle";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleWithEmbeddedGradleVersion";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "hasCause";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "mapConfigurationName";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "useCompatibilityConfigurationNames";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isAaptGeneratedSourcesFolder";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isDataBindingGeneratedBaseClassesFolder";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedSourceFoldersToUse";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "projectBuildFilesTypes";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "hasKtsBuildFiles";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addBuildFileType";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getLastKnownAndroidGradlePluginVersion";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getLastSuccessfulAndroidGradlePluginVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 22: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 57: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

