/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.utils.FileUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class BuildFileProcessor {
    @NotNull
    public static BuildFileProcessor getInstance() {
        BuildFileProcessor buildFileProcessor = (BuildFileProcessor)ApplicationManager.getApplication().getService(BuildFileProcessor.class);
        if (buildFileProcessor == null) {
            BuildFileProcessor.$$$reportNull$$$0(0);
        }
        return buildFileProcessor;
    }

    public void processRecursively(@NotNull Project project, @NotNull Processor<? super GradleBuildModel> processor) {
        if (project == null) {
            BuildFileProcessor.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            BuildFileProcessor.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile projectRootFolder = ProjectUtil.guessProjectDir((Project)project);
            if (projectRootFolder == null) {
                return;
            }
            ProjectBuildModel projectBuildModel2 = ProjectBuildModel.getOrLog((Project)project);
            if (projectBuildModel2 == null) {
                return;
            }
            GradleSettingsModel settings = (GradleSettingsModel)GradleBuildModel.tryOrLog(() -> projectBuildModel2.getProjectSettingsModel());
            if (settings == null) {
                return;
            }
            for (String path2 : settings.modulePaths()) {
                boolean continueProcessing;
                GradleBuildModel buildModel = (GradleBuildModel)GradleBuildModel.tryOrLog(() -> settings.moduleModel(path2));
                if (buildModel == null || (continueProcessing = processor.process((Object)buildModel))) continue;
                return;
            }
        });
    }

    @NotNull
    public static List<File> getCompositeBuildFolderPaths(@NotNull Project project) {
        String projectBasePath;
        if (project == null) {
            BuildFileProcessor.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(projectBasePath = project.getBasePath()))) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                BuildFileProcessor.$$$reportNull$$$0(4);
            }
            return list;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(projectBasePath);
        if (projectSettings == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                BuildFileProcessor.$$$reportNull$$$0(5);
            }
            return list;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = projectSettings.getCompositeBuild();
        if (compositeBuild == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                BuildFileProcessor.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<File> list = compositeBuild.getCompositeParticipants().stream().map(p -> new File(FileUtils.toSystemDependentPath((String)p.getRootPath()))).collect(Collectors.toList());
        if (list == null) {
            BuildFileProcessor.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/BuildFileProcessor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/BuildFileProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeBuildFolderPaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processRecursively";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeBuildFolderPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

