/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.LocalMavenRepository;
import com.android.tools.idea.sdk.IdeSdks;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdkRepositories {
    public static final String ANDROID_REPOSITORY_NAME = "Android Repository";
    public static final String GOOGLE_REPOSITORY_NAME = "Google Repository";

    private AndroidSdkRepositories() {
    }

    @Nullable
    public static ArtifactRepository getAndroidRepository() {
        return AndroidSdkRepositories.getMavenRepository(SdkMavenRepository.ANDROID, ANDROID_REPOSITORY_NAME);
    }

    @Nullable
    public static ArtifactRepository getGoogleRepository() {
        return AndroidSdkRepositories.getMavenRepository(SdkMavenRepository.GOOGLE, GOOGLE_REPOSITORY_NAME);
    }

    @Nullable
    private static ArtifactRepository getMavenRepository(@NotNull SdkMavenRepository repository, @NotNull String name) {
        File location;
        if (repository == null) {
            AndroidSdkRepositories.$$$reportNull$$$0(0);
        }
        if (name == null) {
            AndroidSdkRepositories.$$$reportNull$$$0(1);
        }
        return (location = AndroidSdkRepositories.getRepositoryLocation(repository)) != null ? new LocalMavenRepository(location, name) : null;
    }

    @Nullable
    private static File getRepositoryLocation(@NotNull SdkMavenRepository repository) {
        if (repository == null) {
            AndroidSdkRepositories.$$$reportNull$$$0(2);
        }
        File androidSdkPath = IdeSdks.getInstance().getAndroidSdkPath();
        return repository.getRepositoryLocation(androidSdkPath, true, FileOpUtils.create());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/structure/model/repositories/search/AndroidSdkRepositories";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMavenRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRepositoryLocation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

