/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.pom;

import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MavenPoms {
    private static final Logger LOG = Logger.getInstance(MavenPoms.class);

    private MavenPoms() {
    }

    @NotNull
    public static List<PsArtifactDependencySpec> findDependenciesInPomFile(@Nullable File pomFilePath) {
        if (pomFilePath == null || !pomFilePath.isFile()) {
            List<PsArtifactDependencySpec> list = Collections.emptyList();
            if (list == null) {
                MavenPoms.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<PsArtifactDependencySpec> dependencies2 = new ArrayList<PsArtifactDependencySpec>();
        try {
            Document document = JDOMUtil.loadDocument((File)pomFilePath);
            Element rootElement = document.getRootElement();
            Element dependenciesElement = null;
            for (Element childElement : rootElement.getChildren()) {
                if (!"dependencies".equals(childElement.getName())) continue;
                dependenciesElement = childElement;
                break;
            }
            if (dependenciesElement != null) {
                for (Element childElement : dependenciesElement.getChildren()) {
                    PsArtifactDependencySpec spec;
                    if (!"dependency".equals(childElement.getName()) || (spec = MavenPoms.createSpec(childElement)) == null) continue;
                    dependencies2.add(spec);
                }
            }
        }
        catch (Exception e) {
            String msg = String.format("Failed to obtain dependencies in POM file '%1$s", pomFilePath.getPath());
            LOG.warn(msg, (Throwable)e);
        }
        ArrayList<PsArtifactDependencySpec> arrayList = dependencies2;
        if (arrayList == null) {
            MavenPoms.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    private static PsArtifactDependencySpec createSpec(@NotNull Element dependencyElement) {
        if (dependencyElement == null) {
            MavenPoms.$$$reportNull$$$0(2);
        }
        String artifactId = null;
        String groupId = null;
        String version2 = null;
        String scope = null;
        boolean optional = false;
        for (Element childElement : dependencyElement.getChildren()) {
            String name = childElement.getName();
            if ("artifactId".equals(name)) {
                artifactId = MavenPoms.textOf(childElement);
                continue;
            }
            if ("groupId".equals(name)) {
                groupId = MavenPoms.textOf(childElement);
                continue;
            }
            if ("version".equals(name)) {
                version2 = MavenPoms.textOf(childElement);
                continue;
            }
            if ("optional".equals(name)) {
                optional = Boolean.valueOf(MavenPoms.textOf(childElement));
                continue;
            }
            if (!"scope".equals(name)) continue;
            scope = MavenPoms.textOf(childElement);
        }
        if (StringUtil.isNotEmpty(artifactId) && !optional && ("compile".equals(scope) || "runtime".equals(scope) || StringUtil.isEmpty(scope))) {
            return PsArtifactDependencySpec.Companion.create(groupId, artifactId, version2);
        }
        return null;
    }

    @Nullable
    private static String textOf(@NotNull Element e) {
        if (e == null) {
            MavenPoms.$$$reportNull$$$0(3);
        }
        return StringUtil.nullize((String)e.getText(), (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/pom/MavenPoms";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependenciesInPomFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/pom/MavenPoms";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSpec";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "textOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

