/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.structure.configurables.PsPathRenderer;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsAndroidModuleVariantsAnalyzerKt;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsAndroidModuleVariantsAnalyzerKt$analyzeModuleDependency$;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsMissingBuildTypeFallbackQuickFix;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsMissingBuildTypeQuickFix;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsMissingProductFlavorFallbackQuickFix;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsMissingProductFlavorQuickFix;
import com.android.tools.idea.gradle.structure.model.PsGeneralIssue;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsQuickFix;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.android.tools.idea.gradle.structure.model.android.PsDeclaredModuleAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsFlavorDimension;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.android.tools.idea.gradle.structure.model.meta.ParsedValueKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"analyzeModuleDependencies", "Lkotlin/sequences/Sequence;", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "androidModule", "Lcom/android/tools/idea/gradle/structure/model/android/PsAndroidModule;", "pathRenderer", "Lcom/android/tools/idea/gradle/structure/configurables/PsPathRenderer;", "analyzeModuleDependency", "dependency", "Lcom/android/tools/idea/gradle/structure/model/android/PsDeclaredModuleAndroidDependency;", "analyzeProductFlavors", "Lcom/android/tools/idea/gradle/structure/model/PsGeneralIssue;", "model", "intellij.android.core"})
public final class PsAndroidModuleVariantsAnalyzerKt {
    @NotNull
    public static final Sequence<PsIssue> analyzeModuleDependencies(@NotNull PsAndroidModule androidModule, @NotNull PsPathRenderer pathRenderer) {
        Intrinsics.checkNotNullParameter((Object)androidModule, (String)"androidModule");
        Intrinsics.checkNotNullParameter((Object)pathRenderer, (String)"pathRenderer");
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)androidModule.getDependencies().getModules()), (Function1)((Function1)new Function1<PsDeclaredModuleAndroidDependency, Sequence<? extends PsIssue>>(pathRenderer){
            final /* synthetic */ PsPathRenderer $pathRenderer;

            @NotNull
            public final Sequence<PsIssue> invoke(@NotNull PsDeclaredModuleAndroidDependency it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency(it, this.$pathRenderer);
            }
            {
                this.$pathRenderer = psPathRenderer;
                super(1);
            }
        }));
    }

    @NotNull
    public static final Sequence<PsIssue> analyzeModuleDependency(@NotNull PsDeclaredModuleAndroidDependency dependency, @NotNull PsPathRenderer pathRenderer) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)pathRenderer, (String)"pathRenderer");
        boolean bl = false;
        boolean bl2 = false;
        PsPathRenderer $this$with = pathRenderer;
        boolean bl3 = false;
        PsAndroidModule sourceModule = dependency.getParent();
        PsModule psModule = dependency.getParent().getParent().findModuleByGradlePath(dependency.getGradlePath());
        if (!(psModule instanceof PsAndroidModule)) {
            psModule = null;
        }
        PsAndroidModule psAndroidModule = (PsAndroidModule)psModule;
        if (psAndroidModule == null) {
            return SequencesKt.emptySequence();
        }
        PsAndroidModule targetModule = psAndroidModule;
        Function0<Sequence<? extends PsGeneralIssue>> $fun$analyzeBuildTypes$1 = new Function0<Sequence<? extends PsGeneralIssue>>($this$with, targetModule, sourceModule, dependency){
            final /* synthetic */ PsPathRenderer $this_with;
            final /* synthetic */ PsAndroidModule $targetModule;
            final /* synthetic */ PsAndroidModule $sourceModule;
            final /* synthetic */ PsDeclaredModuleAndroidDependency $dependency$inlined;
            {
                this.$this_with = psPathRenderer;
                this.$targetModule = psAndroidModule;
                this.$sourceModule = psAndroidModule2;
                this.$dependency$inlined = psDeclaredModuleAndroidDependency;
                super(0);
            }

            @NotNull
            public final Sequence<PsGeneralIssue> invoke() {
                Function1<String, Boolean> $fun$targetBuildTypeExists$1 = new Function1<String, Boolean>(this){
                    final /* synthetic */ analyzeModuleDependency$$inlined$with$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final boolean invoke(@NotNull String buildTypeName) {
                        Intrinsics.checkNotNullParameter((Object)buildTypeName, (String)"buildTypeName");
                        return Intrinsics.areEqual((Object)buildTypeName, (Object)"debug") || Intrinsics.areEqual((Object)buildTypeName, (Object)"release") || this.this$0.$targetModule.findBuildType(buildTypeName) != null;
                    }
                };
                return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.$sourceModule.getBuildTypes().getItems()), (Function1)((Function1)new Function1<PsBuildType, PsGeneralIssue>(this, $fun$targetBuildTypeExists$1){
                    final /* synthetic */ analyzeModuleDependency$$inlined$with$lambda$1 this$0;
                    final /* synthetic */ analyzeModuleDependency$$inlined$with$lambda$1$1 $targetBuildTypeExists$1;
                    {
                        this.this$0 = var1_1;
                        this.$targetBuildTypeExists$1 = var2_2;
                        super(1);
                    }

                    @Nullable
                    public final PsGeneralIssue invoke(@NotNull PsBuildType sourceBuildType) {
                        Intrinsics.checkNotNullParameter((Object)sourceBuildType, (String)"sourceBuildType");
                        if (this.$targetBuildTypeExists$1.invoke(sourceBuildType.getName())) {
                            return null;
                        }
                        List<String> list = ParsedValueKt.getMaybeValue(sourceBuildType.getMatchingFallbacks());
                        if (list != null) {
                            boolean bl;
                            block6: {
                                Iterable $this$any$iv = list;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        String fallback = (String)element$iv;
                                        boolean bl2 = false;
                                        if (!this.$targetBuildTypeExists$1.invoke(fallback)) continue;
                                        bl = true;
                                        break block6;
                                    }
                                    bl = false;
                                }
                            }
                            if (bl) {
                                return null;
                            }
                        }
                        String string = "No build type in module '" + this.this$0.$this_with.renderNavigation((PsPath)this.this$0.$targetModule.getPath(), analyzeModuleDependency.1.2.INSTANCE) + "' " + "matches build type '" + PsPathRenderer.DefaultImpls.renderNavigation$default(this.this$0.$this_with, sourceBuildType.getPath(), null, 1, null) + "'.";
                        PsPath psPath = this.this$0.$dependency$inlined.getPath();
                        PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
                        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PsIssueType.PROJECT_ANALYSIS");
                        return new PsGeneralIssue(string, "", psPath, psIssueType, PsIssue.Severity.ERROR, CollectionsKt.listOf((Object[])new PsQuickFix[]{new PsMissingBuildTypeQuickFix(this.this$0.$targetModule, sourceBuildType), new PsMissingBuildTypeFallbackQuickFix(sourceBuildType)}));
                    }
                }));
            }
        };
        Function0<Sequence<? extends PsIssue>> $fun$analyzeProductFlavors$2 = new Function0<Sequence<? extends PsIssue>>($this$with, sourceModule, targetModule, dependency){
            final /* synthetic */ PsPathRenderer $this_with;
            final /* synthetic */ PsAndroidModule $sourceModule;
            final /* synthetic */ PsAndroidModule $targetModule;
            final /* synthetic */ PsDeclaredModuleAndroidDependency $dependency$inlined;
            {
                this.$this_with = psPathRenderer;
                this.$sourceModule = psAndroidModule;
                this.$targetModule = psAndroidModule2;
                this.$dependency$inlined = psDeclaredModuleAndroidDependency;
                super(0);
            }

            @NotNull
            public final Sequence<PsIssue> invoke() {
                return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.$sourceModule.getFlavorDimensions()), (Function1)((Function1)new Function1<PsFlavorDimension, Sequence<? extends PsIssue>>(this){
                    final /* synthetic */ analyzeModuleDependency$$inlined$with$lambda$2 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    @NotNull
                    public final Sequence<PsIssue> invoke(@NotNull PsFlavorDimension sourceDimension) {
                        Intrinsics.checkNotNullParameter((Object)sourceDimension, (String)"sourceDimension");
                        if (this.this$0.$targetModule.findFlavorDimension(sourceDimension.getName()) == null) {
                            return SequencesKt.emptySequence();
                        }
                        return SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.this$0.$sourceModule.getProductFlavors().getItems()), (Function1)((Function1)new Function1<PsProductFlavor, Boolean>(sourceDimension){
                            final /* synthetic */ PsFlavorDimension $sourceDimension;
                            {
                                this.$sourceDimension = psFlavorDimension;
                                super(1);
                            }

                            public final boolean invoke(@NotNull PsProductFlavor it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return Intrinsics.areEqual((Object)it.getEffectiveDimension(), (Object)this.$sourceDimension.getName());
                            }
                        })), (Function1)((Function1)new Function1<PsProductFlavor, PsGeneralIssue>(this, sourceDimension){
                            final /* synthetic */ analyzeModuleDependency$$inlined$with$lambda$2$1 this$0;
                            final /* synthetic */ PsFlavorDimension $sourceDimension;
                            {
                                this.this$0 = var1_1;
                                this.$sourceDimension = psFlavorDimension;
                                super(1);
                            }

                            @Nullable
                            public final PsGeneralIssue invoke(@NotNull PsProductFlavor sourceProductFlavor) {
                                Intrinsics.checkNotNullParameter((Object)sourceProductFlavor, (String)"sourceProductFlavor");
                                if (this.this$0.this$0.$targetModule.findProductFlavor(this.$sourceDimension.getName(), sourceProductFlavor.getName()) != null) {
                                    return null;
                                }
                                List<String> list = ParsedValueKt.getMaybeValue(sourceProductFlavor.getMatchingFallbacks());
                                if (list != null) {
                                    boolean bl;
                                    block6: {
                                        Iterable $this$any$iv = list;
                                        boolean $i$f$any = false;
                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                            bl = false;
                                        } else {
                                            for (T element$iv : $this$any$iv) {
                                                String fallback = (String)element$iv;
                                                boolean bl2 = false;
                                                if (!(this.this$0.this$0.$targetModule.findProductFlavor(this.$sourceDimension.getName(), fallback) != null)) continue;
                                                bl = true;
                                                break block6;
                                            }
                                            bl = false;
                                        }
                                    }
                                    if (bl) {
                                        return null;
                                    }
                                }
                                String string = "No product flavor in module '" + this.this$0.this$0.$this_with.renderNavigation((PsPath)this.this$0.this$0.$targetModule.getPath(), analyzeModuleDependency.1.2.INSTANCE) + "' " + "matches product flavor '" + PsPathRenderer.DefaultImpls.renderNavigation$default(this.this$0.this$0.$this_with, sourceProductFlavor.getPath(), null, 1, null) + "' " + "in dimension '" + PsPathRenderer.DefaultImpls.renderNavigation$default(this.this$0.this$0.$this_with, this.$sourceDimension.getPath(), null, 1, null) + "'.";
                                PsPath psPath = this.this$0.this$0.$dependency$inlined.getPath();
                                PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
                                Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PsIssueType.PROJECT_ANALYSIS");
                                return new PsGeneralIssue(string, "", psPath, psIssueType, PsIssue.Severity.ERROR, CollectionsKt.listOf((Object[])new PsQuickFix[]{new PsMissingProductFlavorQuickFix(this.this$0.this$0.$targetModule, sourceProductFlavor), new PsMissingProductFlavorFallbackQuickFix(sourceProductFlavor)}));
                            }
                        }));
                    }
                }));
            }
        };
        Function0<Sequence<? extends PsGeneralIssue>> $fun$analyzeFlavorDimensions$3 = new Function0<Sequence<? extends PsGeneralIssue>>($this$with, targetModule, sourceModule, dependency){
            final /* synthetic */ PsPathRenderer $this_with;
            final /* synthetic */ PsAndroidModule $targetModule;
            final /* synthetic */ PsAndroidModule $sourceModule;
            final /* synthetic */ PsDeclaredModuleAndroidDependency $dependency$inlined;
            {
                this.$this_with = psPathRenderer;
                this.$targetModule = psAndroidModule;
                this.$sourceModule = psAndroidModule2;
                this.$dependency$inlined = psDeclaredModuleAndroidDependency;
                super(0);
            }

            @NotNull
            public final Sequence<PsGeneralIssue> invoke() {
                return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.$targetModule.getFlavorDimensions().getItems()), (Function1)((Function1)new Function1<PsFlavorDimension, Boolean>(this){
                    final /* synthetic */ analyzeModuleDependency$$inlined$with$lambda$3 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final boolean invoke(@NotNull PsFlavorDimension targetDimension) {
                        int n;
                        Intrinsics.checkNotNullParameter((Object)targetDimension, (String)"targetDimension");
                        Iterable $this$count$iv = this.this$0.$targetModule.getProductFlavors().getItems();
                        boolean $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n = 0;
                        } else {
                            int count$iv = 0;
                            for (T element$iv : $this$count$iv) {
                                PsProductFlavor it = (PsProductFlavor)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getEffectiveDimension(), (Object)targetDimension.getName())) continue;
                                int n2 = ++count$iv;
                                boolean bl2 = false;
                                if (n2 >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n = count$iv;
                        }
                        return n > 1;
                    }
                })), (Function1)((Function1)new Function1<PsFlavorDimension, Boolean>(this){
                    final /* synthetic */ analyzeModuleDependency$$inlined$with$lambda$3 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean invoke(@NotNull PsFlavorDimension targetDimension) {
                        ResolvedPropertyModel strategy;
                        List list;
                        Intrinsics.checkNotNullParameter((Object)targetDimension, (String)"targetDimension");
                        if (this.this$0.$sourceModule.findFlavorDimension(targetDimension.getName()) != null) return false;
                        GradleBuildModel gradleBuildModel = this.this$0.$sourceModule.getParsedModel();
                        List list2 = gradleBuildModel != null && (gradleBuildModel = gradleBuildModel.android()) != null && (gradleBuildModel = gradleBuildModel.defaultConfig()) != null ? gradleBuildModel.missingDimensionStrategies() : null;
                        boolean bl = false;
                        List list3 = list2;
                        if (list3 == null) {
                            list3 = CollectionsKt.emptyList();
                        }
                        Iterable $this$all$iv = list3;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            return true;
                        }
                        Iterator<T> iterator = $this$all$iv.iterator();
                        do {
                            if (!iterator.hasNext()) return true;
                            T element$iv = iterator.next();
                            strategy = (ResolvedPropertyModel)element$iv;
                            boolean bl2 = false;
                        } while (Intrinsics.areEqual((Object)((list = strategy.toList()) != null && (list = (GradlePropertyModel)CollectionsKt.firstOrNull((List)list)) != null ? list.toString() : null), (Object)targetDimension.getName()) ^ true);
                        return false;
                    }
                })), (Function1)((Function1)new Function1<PsFlavorDimension, PsGeneralIssue>(this){
                    final /* synthetic */ analyzeModuleDependency$$inlined$with$lambda$3 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    @NotNull
                    public final PsGeneralIssue invoke(@NotNull PsFlavorDimension targetDimension) {
                        Intrinsics.checkNotNullParameter((Object)targetDimension, (String)"targetDimension");
                        String string = "No flavor dimension in module '" + this.this$0.$this_with.renderNavigation((PsPath)this.this$0.$sourceModule.getPath(), analyzeModuleDependency.1.1.INSTANCE) + "' matches " + "dimension '" + PsPathRenderer.DefaultImpls.renderNavigation$default(this.this$0.$this_with, targetDimension.getPath(), null, 1, null) + "' " + "from module " + this.this$0.$this_with.renderNavigation((PsPath)this.this$0.$targetModule.getPath(), analyzeModuleDependency.1.2.INSTANCE) + " on which " + "module '" + this.this$0.$this_with.renderNavigation(this.this$0.$sourceModule.getPath(), this.this$0.$dependency$inlined.getPath()) + "' depends.";
                        PsPath psPath = this.this$0.$dependency$inlined.getPath();
                        PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
                        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PsIssueType.PROJECT_ANALYSIS");
                        return new PsGeneralIssue(string, psPath, psIssueType, PsIssue.Severity.ERROR, null);
                    }
                }));
            }
        };
        return SequencesKt.plus((Sequence)SequencesKt.plus($fun$analyzeBuildTypes$1.invoke(), $fun$analyzeProductFlavors$2.invoke()), $fun$analyzeFlavorDimensions$3.invoke());
    }

    @NotNull
    public static final Sequence<PsGeneralIssue> analyzeProductFlavors(@NotNull PsAndroidModule model2, @NotNull PsPathRenderer pathRenderer) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)pathRenderer, (String)"pathRenderer");
        boolean bl = false;
        boolean bl2 = false;
        PsPathRenderer $this$with = pathRenderer;
        boolean bl3 = false;
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)model2.getProductFlavors()), (Function1)analyzeProductFlavors.1.1.INSTANCE), (Function1)((Function1)new Function1<PsProductFlavor, PsGeneralIssue>($this$with){
            final /* synthetic */ PsPathRenderer $this_with;

            @NotNull
            public final PsGeneralIssue invoke(@NotNull PsProductFlavor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String configuredFlavorDimension = ParsedValueKt.getMaybeValue(it.getConfiguredDimension());
                CharSequence charSequence = configuredFlavorDimension;
                boolean bl = false;
                boolean bl2 = false;
                String string = charSequence == null || charSequence.length() == 0 ? "Flavor '" + PsPathRenderer.DefaultImpls.renderNavigation$default(this.$this_with, it.getPath(), null, 1, null) + "' has no flavor dimension." : "Flavor '" + PsPathRenderer.DefaultImpls.renderNavigation$default(this.$this_with, it.getPath(), null, 1, null) + "' has unknown dimension '" + configuredFlavorDimension + "'.";
                PsPath psPath = it.getPath();
                PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
                Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PsIssueType.PROJECT_ANALYSIS");
                return new PsGeneralIssue(string, psPath, psIssueType, PsIssue.Severity.ERROR, null);
            }
            {
                this.$this_with = psPathRenderer;
                super(1);
            }
        }));
    }
}

