/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.structure.model.PsGeneralIssue;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u001a,\u0010\f\u001a\u001c\u0012\u0004\u0012\u00020\u000e\u0012\u0012\u0012\u0010\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00060\u00060\u000f0\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"URL_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "createIssueFrom", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "syncIssue", "Lcom/android/builder/model/SyncIssue;", "path", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "getSeverity", "Lcom/android/tools/idea/gradle/structure/model/PsIssue$Severity;", "issue", "transferSyncIssues", "", "", "", "gradleModel", "Lcom/android/tools/idea/gradle/project/model/AndroidModuleModel;", "intellij.android.core"})
public final class PsAndroidModuleAnalyzerKt {
    private static final Pattern URL_PATTERN = Pattern.compile("\\(?http://[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]");

    @VisibleForTesting
    @NotNull
    public static final PsIssue createIssueFrom(@NotNull SyncIssue syncIssue, @NotNull PsPath path2) {
        Intrinsics.checkNotNullParameter((Object)syncIssue, (String)"syncIssue");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String message2 = XmlStringUtil.escapeString((String)syncIssue.getMessage());
        Matcher matcher = URL_PATTERN.matcher(message2);
        boolean result2 = matcher.find();
        while (result2) {
            String url = matcher.group();
            String string = message2;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message");
            String string2 = url;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url");
            message2 = StringsKt.replace$default((String)string, (String)string2, (String)("<a href='" + url + "'>" + url + "</a>"), (boolean)false, (int)4, null);
            result2 = matcher.find();
        }
        String string = message2;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message");
        PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PROJECT_ANALYSIS");
        return new PsGeneralIssue(string, path2, psIssueType, PsAndroidModuleAnalyzerKt.getSeverity(syncIssue), null, 16, null);
    }

    private static final PsIssue.Severity getSeverity(SyncIssue issue2) {
        int severity = issue2.getSeverity();
        switch (severity) {
            case 2: {
                return PsIssue.Severity.ERROR;
            }
            case 1: {
                return PsIssue.Severity.WARNING;
            }
        }
        return PsIssue.Severity.INFO;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, List<SyncIssue>> transferSyncIssues(AndroidModuleModel gradleModel) {
        Object object;
        Object object2 = gradleModel;
        if (object2 != null && (object2 = ((AndroidModuleModel)object2).getAndroidProject()) != null && (object2 = object2.getSyncIssues()) != null) {
            void $this$groupByTo$iv$iv;
            SyncIssue it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SyncIssue)element$iv$iv;
                boolean bl = false;
                SyncIssue syncIssue = it;
                Intrinsics.checkNotNullExpressionValue((Object)syncIssue, (String)"it");
                CharSequence charSequence = syncIssue.getData();
                boolean bl2 = false;
                boolean bl3 = false;
                if (!(!(charSequence == null || charSequence.length() == 0))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object3;
                String key$iv$iv;
                it = (SyncIssue)element$iv$iv;
                boolean bl = false;
                SyncIssue syncIssue = it;
                Intrinsics.checkNotNullExpressionValue((Object)syncIssue, (String)"it");
                Intrinsics.checkNotNull((Object)syncIssue.getData());
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv;
        } else {
            object = null;
        }
        Map map2 = object;
        boolean bl = false;
        Map map3 = map2;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        return map3;
    }

    public static final /* synthetic */ Map access$transferSyncIssues(AndroidModuleModel gradleModel) {
        return PsAndroidModuleAnalyzerKt.transferSyncIssues(gradleModel);
    }
}

