/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.dependencies;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.DependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.configurables.ui.ChooseModuleDialog;
import com.android.tools.idea.gradle.structure.configurables.ui.EmptyPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.DependencyInfoPanel;
import com.android.tools.idea.gradle.structure.dependencies.AddJarDependencyDialog;
import com.android.tools.idea.gradle.structure.dependencies.AddLibraryDependencyDialog;
import com.android.tools.idea.gradle.structure.dependencies.AddModuleDependencyDialog;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.structure.dialog.Header;
import com.android.tools.idea.structure.dialog.TrackedConfigurableKt;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDependenciesPanel
extends JPanel
implements Place.Navigator,
Disposable {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final EmptyPanel myEmptyDetailsPanel;
    @NotNull
    private final DependencyInfoPanel myInfoPanel;
    @NotNull
    private final JScrollPane myInfoScrollPane;
    @NotNull
    private final Header myHeader;
    @NotNull
    private final JPanel myContentsPanel;
    @NotNull
    private final String myEmptyText;
    @NotNull
    private final List<DependencyDetails> myDependencyDetails;
    @Nullable
    private final PsModule myModule;
    private DependencyDetails myCurrentDependencyDetails;
    private History myHistory;
    private IssuesViewer myIssuesViewer;
    private AddLibraryDependencyAction myAddLibraryDependencyAction;
    private AddJarDependencyAction myAddJarDependencyAction;

    protected AbstractDependenciesPanel(@NotNull String title, @NotNull PsContext context, @Nullable PsModule module) {
        if (title == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myDependencyDetails = new ArrayList<DependencyDetails>();
        this.myContext = context;
        this.myModule = module;
        this.myEmptyText = String.format("Please select a dependency from the '%1$s' view", title);
        this.myEmptyDetailsPanel = new EmptyPanel(this.myEmptyText);
        this.myInfoPanel = new DependencyInfoPanel();
        this.myInfoScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myEmptyDetailsPanel, (int)20, (int)31);
        this.myInfoScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myHeader = new Header(title);
        this.add((Component)this.myHeader, "North");
        JBSplitter splitter = new JBSplitter(true, "psd.editable.dependencies.main.horizontal.splitter.proportion", 0.55f);
        this.myContentsPanel = new JPanel(new BorderLayout());
        this.myContentsPanel.setBorder((Border)new SideBorder(OnePixelDivider.BACKGROUND, 8));
        splitter.setFirstComponent((JComponent)this.myContentsPanel);
        splitter.setSecondComponent((JComponent)this.myInfoScrollPane);
        this.add((Component)splitter, "Center");
    }

    @NotNull
    public abstract JComponent getPreferredFocusedComponent();

    protected void addDetails(@NotNull DependencyDetails details) {
        if (details == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(2);
        }
        this.myDependencyDetails.add(details);
    }

    protected void setIssuesViewer(@NotNull IssuesViewer issuesViewer) {
        if (issuesViewer == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(3);
        }
        this.myIssuesViewer = issuesViewer;
        this.myIssuesViewer.setShowEmptyText(false);
        this.myInfoPanel.setIssuesViewer(this.myIssuesViewer);
    }

    protected void displayIssues(@NotNull Collection<PsIssue> issues, @Nullable PsPath scope) {
        if (issues == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(4);
        }
        assert (this.myIssuesViewer != null);
        this.myIssuesViewer.display(issues, scope);
        this.myInfoPanel.revalidateAndRepaintPanel();
    }

    protected void updateDetails(@Nullable PsBaseDependency selected) {
        if (selected != null) {
            DependencyDetails newDetails = this.findDetails(selected);
            if (this.myCurrentDependencyDetails != newDetails) {
                this.myCurrentDependencyDetails = newDetails;
                if (this.myCurrentDependencyDetails != null) {
                    this.myInfoPanel.setDependencyDetails(this.myCurrentDependencyDetails);
                }
                this.myInfoScrollPane.setViewportView(this.myCurrentDependencyDetails == null ? this.myEmptyDetailsPanel : this.myInfoPanel.getPanel());
            }
            if (this.myCurrentDependencyDetails != null) {
                this.myCurrentDependencyDetails.display(selected);
            }
        } else {
            this.myCurrentDependencyDetails = null;
            this.myInfoScrollPane.setViewportView(this.myEmptyDetailsPanel);
        }
    }

    @Nullable
    private DependencyDetails findDetails(@NotNull PsBaseDependency selected) {
        if (selected == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(5);
        }
        for (DependencyDetails details : this.myDependencyDetails) {
            if (!details.getSupportedModelType().isInstance(selected)) continue;
            return details;
        }
        return null;
    }

    @Nullable
    protected DependencyDetails getCurrentDependencyDetails() {
        return this.myCurrentDependencyDetails;
    }

    @NotNull
    protected final JPanel createActionsPanel() {
        final JPanel actionsPanel = new JPanel(new BorderLayout());
        DefaultActionGroup actions2 = new DefaultActionGroup();
        DumbAwareAction addDependencyAction = new DumbAwareAction(AndroidBundle.messagePointer("action.DumbAware.AbstractDependenciesPanel.text.add.dependency", new Object[0]), () -> "", IconUtil.getAddIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<AbstractPopupAction>(null, AbstractDependenciesPanel.this.getPopupActions()){

                    public Icon getIconFor(AbstractPopupAction action2) {
                        return action2.icon;
                    }

                    public boolean isMnemonicsNavigationEnabled() {
                        return true;
                    }

                    public PopupStep<?> onChosen(AbstractPopupAction action2, boolean finalChoice) {
                        return this.doFinalStep(action2::execute);
                    }

                    @NotNull
                    public String getTextFor(AbstractPopupAction action2) {
                        String string = "&" + action2.index + "  " + action2.text;
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDependenciesPanel$1$1", "getTextFor"));
                    }
                });
                popup2.show(new RelativePoint((Component)actionsPanel, new Point(0, actionsPanel.getHeight() - 1)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDependenciesPanel$1", "actionPerformed"));
            }
        };
        addDependencyAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("NewElement").getShortcutSet(), (JComponent)this.myContentsPanel);
        actions2.add((AnAction)addDependencyAction);
        List<AnAction> extraToolbarActions = this.getExtraToolbarActions(this.myContentsPanel);
        if (!extraToolbarActions.isEmpty()) {
            actions2.addSeparator();
            actions2.addAll(extraToolbarActions);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TOP", (ActionGroup)actions2, true);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setBorder(IdeBorderFactory.createBorder((int)8));
        actionsPanel.add((Component)toolbarComponent, "Center");
        JPanel jPanel = actionsPanel;
        if (jPanel == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    protected List<AnAction> getExtraToolbarActions(@NotNull JComponent focusComponent) {
        if (focusComponent == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(7);
        }
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private List<AbstractPopupAction> getPopupActions() {
        if (this.myAddLibraryDependencyAction == null) {
            this.myAddLibraryDependencyAction = new AddLibraryDependencyAction();
        }
        if (this.myAddJarDependencyAction == null) {
            this.myAddJarDependencyAction = new AddJarDependencyAction();
        }
        ArrayList actions2 = Lists.newArrayList((Object[])new AbstractPopupAction[]{this.myAddLibraryDependencyAction, this.myAddJarDependencyAction});
        PsProject project = this.myContext.getProject();
        if (project.getModelCount() > 1) {
            actions2.add(new AddModuleDependencyAction());
        }
        ArrayList arrayList = actions2;
        if (arrayList == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    protected JPanel getContentsPanel() {
        JPanel jPanel = this.myContentsPanel;
        if (jPanel == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    @NotNull
    protected PsContext getContext() {
        PsContext psContext = this.myContext;
        if (psContext == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(11);
        }
        return psContext;
    }

    @NotNull
    public Header getHeader() {
        Header header = this.myHeader;
        if (header == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(12);
        }
        return header;
    }

    @NotNull
    public String getEmptyText() {
        String string = this.myEmptyText;
        if (string == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    @Nullable
    protected History getHistory() {
        return this.myHistory;
    }

    public void queryPlace(@NotNull Place place) {
        PsBaseDependency model2;
        if (place == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(14);
        }
        String dependency = "";
        DependencyDetails details = this.getCurrentDependencyDetails();
        if (details != null && (model2 = details.getModel()) != null) {
            dependency = model2.toText();
        }
        this.putPath(place, dependency);
    }

    public void putPath(@NotNull Place place, @NotNull String dependency) {
        if (place == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(15);
        }
        if (dependency == null) {
            AbstractDependenciesPanel.$$$reportNull$$$0(16);
        }
        place.putPath(this.getPlaceName(), (Object)dependency);
    }

    @NotNull
    protected abstract String getPlaceName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issuesViewer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issues";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDependenciesPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusComponent";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDependenciesPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraToolbarActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentsPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeader";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDetails";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setIssuesViewer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "displayIssues";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDetails";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExtraToolbarActions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class AbstractPopupAction
    implements ActionListener {
        @NotNull
        final String text;
        @NotNull
        final Icon icon;
        final int index;

        AbstractPopupAction(@NotNull String text, @NotNull Icon icon2, int index) {
            if (text == null) {
                AbstractPopupAction.$$$reportNull$$$0(0);
            }
            if (icon2 == null) {
                AbstractPopupAction.$$$reportNull$$$0(1);
            }
            this.text = text;
            this.icon = icon2;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.execute();
        }

        abstract void execute();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDependenciesPanel$AbstractPopupAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class AbstractAddDependencyAction
    extends AbstractPopupAction {
        @NotNull
        private final String myTitle;

        AbstractAddDependencyAction(@NotNull String title, @NotNull String text, Icon icon2, int index) {
            if (title == null) {
                AbstractAddDependencyAction.$$$reportNull$$$0(0);
            }
            if (text == null) {
                AbstractAddDependencyAction.$$$reportNull$$$0(1);
            }
            if (icon2 == null) {
                AbstractAddDependencyAction.$$$reportNull$$$0(2);
            }
            super(text, icon2, index);
            this.myTitle = title;
        }

        @Override
        void execute() {
            if (AbstractDependenciesPanel.this.myModule == null) {
                PsProject project = AbstractDependenciesPanel.this.myContext.getProject();
                int modelCount = project.getModelCount();
                if (modelCount == 1) {
                    Ref moduleRef = new Ref();
                    project.forEachModule(arg_0 -> ((Ref)moduleRef).set(arg_0));
                    PsModule module = (PsModule)moduleRef.get();
                    assert (module != null);
                    this.showAddDependencyDialog(module);
                    return;
                }
                Consumer<PsModule> onOkTask = this::showAddDependencyDialog;
                ChooseModuleDialog dialog2 = new ChooseModuleDialog(project, onOkTask, this.myTitle);
                dialog2.showAndGet();
                return;
            }
            this.showAddDependencyDialog(AbstractDependenciesPanel.this.myModule);
        }

        protected abstract void showAddDependencyDialog(@NotNull PsModule var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDependenciesPanel$AbstractAddDependencyAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddModuleDependencyAction
    extends AbstractAddDependencyAction {
        AddModuleDependencyAction() {
            super("Add Module Dependency", "Module Dependency", AllIcons.Nodes.Module, 3);
        }

        @Override
        protected void showAddDependencyDialog(@NotNull PsModule module) {
            AddModuleDependencyDialog dialog2;
            if (module == null) {
                AddModuleDependencyAction.$$$reportNull$$$0(0);
            }
            if ((dialog2 = new AddModuleDependencyDialog(module)).showAndGet()) {
                TrackedConfigurableKt.logUsagePsdAction(module.getParent().getIdeProject(), AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_DEPENDENCIES_ADD_MODULE);
                dialog2.addNewDependencies();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDependenciesPanel$AddModuleDependencyAction", "showAddDependencyDialog"));
        }
    }

    private class AddJarDependencyAction
    extends AbstractAddDependencyAction {
        AddJarDependencyAction() {
            super("Add Jar/Aar Dependency", "Jar Dependency", PlatformIcons.JAR_ICON, 2);
        }

        @Override
        protected void showAddDependencyDialog(@NotNull PsModule module) {
            AddJarDependencyDialog dialog2;
            if (module == null) {
                AddJarDependencyAction.$$$reportNull$$$0(0);
            }
            if ((dialog2 = new AddJarDependencyDialog(module)).showAndGet()) {
                TrackedConfigurableKt.logUsagePsdAction(module.getParent().getIdeProject(), AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_DEPENDENCIES_ADD_JAR);
                dialog2.addNewDependencies();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDependenciesPanel$AddJarDependencyAction", "showAddDependencyDialog"));
        }
    }

    private class AddLibraryDependencyAction
    extends AbstractAddDependencyAction {
        AddLibraryDependencyAction() {
            super("Add Library Dependency", "Library Dependency", PlatformIcons.LIBRARY_ICON, 1);
        }

        @Override
        protected void showAddDependencyDialog(@NotNull PsModule module) {
            AddLibraryDependencyDialog dialog2;
            if (module == null) {
                AddLibraryDependencyAction.$$$reportNull$$$0(0);
            }
            if ((dialog2 = new AddLibraryDependencyDialog(AbstractDependenciesPanel.this.myContext, module)).showAndGet()) {
                TrackedConfigurableKt.logUsagePsdAction(module.getParent().getIdeProject(), AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_DEPENDENCIES_ADD_LIBRARY);
                dialog2.addNewDependencies();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDependenciesPanel$AddLibraryDependencyAction", "showAddDependencyDialog"));
        }
    }
}

