/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowHeader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.openapi.wm.impl.StripeButtonUI;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolWindowPanel
extends JPanel
implements Disposable {
    @NotNull
    private final ToolWindowHeader myHeader;
    @NotNull
    private final EventDispatcher<RestoreListener> myEventDispatcher;
    private JPanel myMinimizedPanel;
    private AnchoredToolWindowButton myAnchoredButton;

    protected ToolWindowPanel(@NotNull String title, @NotNull Icon icon2, @Nullable ToolWindowAnchor anchor) {
        if (title == null) {
            ToolWindowPanel.$$$reportNull$$$0(0);
        }
        if (icon2 == null) {
            ToolWindowPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myEventDispatcher = EventDispatcher.create(RestoreListener.class);
        this.myHeader = ToolWindowHeader.createAndAdd(title, icon2, this, anchor);
        if (anchor != null) {
            this.myAnchoredButton = new AnchoredToolWindowButton(this.myHeader, anchor);
            this.myAnchoredButton.addActionListener(e -> {
                this.myAnchoredButton.setSelected(false);
                ((RestoreListener)this.myEventDispatcher.getMulticaster()).restored();
            });
            this.myMinimizedPanel = new MinimizedContainerPanel(this.myAnchoredButton);
        }
    }

    public void addRestoreListener(@NotNull RestoreListener listener2) {
        if (listener2 == null) {
            ToolWindowPanel.$$$reportNull$$$0(2);
        }
        this.myEventDispatcher.addListener((EventListener)listener2, (Disposable)this);
    }

    @Nullable
    public JPanel getMinimizedPanel() {
        return this.myMinimizedPanel;
    }

    @NotNull
    public ToolWindowHeader getHeader() {
        ToolWindowHeader toolWindowHeader = this.myHeader;
        if (toolWindowHeader == null) {
            ToolWindowPanel.$$$reportNull$$$0(3);
        }
        return toolWindowHeader;
    }

    @Nullable
    public ToolWindowAnchor getAnchor() {
        return this.myAnchoredButton != null ? this.myAnchoredButton.getAnchor() : null;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myHeader);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addRestoreListener";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AnchoredToolWindowButton
    extends AnchoredButton {
        @NotNull
        private final ToolWindowAnchor myAnchor;

        AnchoredToolWindowButton(@NotNull ToolWindowHeader header, @NotNull ToolWindowAnchor anchor) {
            if (header == null) {
                AnchoredToolWindowButton.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                AnchoredToolWindowButton.$$$reportNull$$$0(1);
            }
            super(header.getTitle(), header.getIcon());
            this.myAnchor = anchor;
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusable(false);
            this.setRolloverEnabled(true);
            this.setOpaque(false);
        }

        public void updateUI() {
            this.setUI(StripeButtonUI.createUI((JComponent)((Object)this)));
            this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        }

        public int getMnemonic2() {
            return 0;
        }

        @NotNull
        public ToolWindowAnchor getAnchor() {
            ToolWindowAnchor toolWindowAnchor = this.myAnchor;
            if (toolWindowAnchor == null) {
                AnchoredToolWindowButton.$$$reportNull$$$0(2);
            }
            return toolWindowAnchor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "header";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel$AnchoredToolWindowButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel$AnchoredToolWindowButton";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MinimizedContainerPanel
    extends JPanel {
        @NotNull
        private final AnchoredToolWindowButton myAnchoredButton;

        MinimizedContainerPanel(@NotNull AnchoredToolWindowButton anchoredButton) {
            if (anchoredButton == null) {
                MinimizedContainerPanel.$$$reportNull$$$0(0);
            }
            this.myAnchoredButton = anchoredButton;
            this.configureBorder();
            this.add((Component)((Object)this.myAnchoredButton));
        }

        private void configureBorder() {
            int borderStyle;
            ToolWindowAnchor anchor = this.myAnchoredButton.getAnchor();
            if (anchor == ToolWindowAnchor.LEFT) {
                borderStyle = 4;
            } else if (anchor == ToolWindowAnchor.RIGHT) {
                borderStyle = 1;
            } else if (anchor == ToolWindowAnchor.BOTTOM) {
                borderStyle = 2;
            } else {
                return;
            }
            this.setBorder(IdeBorderFactory.createBorder((int)borderStyle));
        }

        @Override
        public void doLayout() {
            Dimension size = this.myAnchoredButton.getPreferredSize();
            if (this.myAnchoredButton.getAnchor() == ToolWindowAnchor.BOTTOM) {
                this.myAnchoredButton.setBounds(0, 1, size.width, 25);
            } else {
                this.myAnchoredButton.setBounds(0, 0, this.getWidth(), size.height);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchoredButton", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel$MinimizedContainerPanel", "<init>"));
        }
    }

    public static interface RestoreListener
    extends EventListener {
        public void restored();
    }
}

