/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.gradle.structure.ProjectConfigurationError;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.KeyStrokeAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSdksConfigurable
implements Place.Navigator,
Configurable {
    @NonNls
    private static final String SDKS_PLACE = "sdks.place";
    @NonNls
    public static final String IDE_SDKS_LOCATION_VIEW = "IdeSdksView";
    private static final String CHOOSE_VALID_JDK_DIRECTORY_ERR_FORMAT = "Please choose a valid JDK %s directory.";
    private static final String CHOOSE_VALID_SDK_DIRECTORY_ERR = "Please choose a valid Android SDK directory.";
    private static final String CHOOSE_VALID_NDK_DIRECTORY_ERR = "Please choose a valid Android NDK directory.";
    public static final String JDK_LOCATION_WARNING_URL = "https://docs.gradle.org/current/userguide/gradle_daemon.html#sec:why_is_there_more_than_one_daemon_process_on_my_machine";
    public static final String JDK_LOCATION_TOOLTIP = "To share the same Gradle daemon between Android Studio and other external processes, create a JAVA_HOME environment variable with a valid JDK location and select it from the dropdown below.";
    private static final Logger LOG = Logger.getInstance(IdeSdksConfigurable.class);
    @Nullable
    private final Configurable myHost;
    @Nullable
    private final Project myProject;
    @NotNull
    private final BiMap<String, Component> myComponentsById;
    @NotNull
    private String myUserSelectedJdkHomePath;
    @Nullable
    private String myOriginalNdkHomePath;
    @Nullable
    private String myOriginalSdkHomePath;
    @Nullable
    private String myOriginalJdkHomePath;
    private HyperlinkLabel myNdkDownloadHyperlinkLabel;
    private TextFieldWithBrowseButton mySdkLocationTextField;
    private JPanel myWholePanel;
    private JPanel myNdkDownloadPanel;
    private AsyncProcessIcon myNdkCheckProcessIcon;
    private ComboboxWithBrowseButton myJdkLocationComboBox;
    private ComboboxWithBrowseButton myNdkLocationComboBox;
    private JBLabel myJdkLocationHelp;
    private DetailsComponent myDetailsComponent;
    private History myHistory;
    private String mySelectedComponentId;
    private boolean mySdkLoadingRequested;
    private boolean myIsJavaHomeValid;

    public IdeSdksConfigurable(@Nullable Configurable host, @Nullable Project project) {
        this.$$$setupUI$$$();
        this.myComponentsById = HashBiMap.create();
        this.myUserSelectedJdkHomePath = "";
        this.mySdkLoadingRequested = false;
        this.myHost = host;
        this.myProject = project;
        this.myWholePanel.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        this.myWholePanel.setName(IDE_SDKS_LOCATION_VIEW);
        this.myDetailsComponent = new DetailsComponent(false, false);
        this.myDetailsComponent.setContent((JComponent)this.myWholePanel);
        if (this.myProject == null || this.myProject.isDefault()) {
            this.myNdkLocationComboBox.setEnabled(false);
        }
        this.adjustNdkQuickFixVisibility();
        FocusAdapter historyUpdater = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (IdeSdksConfigurable.this.myHistory != null) {
                    String id;
                    IdeSdksConfigurable.this.mySelectedComponentId = id = (String)IdeSdksConfigurable.this.myComponentsById.inverse().get((Object)e.getComponent());
                    if (id != null) {
                        IdeSdksConfigurable.this.myHistory.pushQueryPlace();
                    }
                }
            }
        };
        this.addHistoryUpdater("mySdkLocationTextField", this.mySdkLocationTextField.getTextField(), historyUpdater);
        this.addHistoryUpdater("myJdkLocationComboBox", this.myJdkLocationComboBox.getComboBox(), historyUpdater);
        this.addHistoryUpdater("myNdkLocationComboBox", this.myNdkLocationComboBox.getComboBox(), historyUpdater);
    }

    private void maybeLoadSdks(@Nullable Project project) {
        if (this.mySdkLoadingRequested) {
            return;
        }
        this.mySdkLoadingRequested = true;
        CardLayout layout2 = (CardLayout)this.myNdkDownloadPanel.getLayout();
        layout2.show(this.myNdkDownloadPanel, "loading");
        StudioLoggerProgressIndicator logger2 = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager repoManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getSdkManager((ProgressIndicator)logger2);
        StudioProgressRunner runner = new StudioProgressRunner(false, false, "Loading Remote SDK", project);
        RepoManager.RepoLoadedCallback onComplete2 = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            if (packages.getRemotePackages().get("ndk-bundle") != null) {
                layout2.show(this.myNdkDownloadPanel, "link");
            } else {
                this.myNdkDownloadPanel.setVisible(false);
            }
        }, ModalityState.any());
        Runnable onError2 = () -> ApplicationManager.getApplication().invokeLater(() -> this.myNdkDownloadPanel.setVisible(false), ModalityState.any());
        repoManager.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of((Object)onComplete2), (List)ImmutableList.of((Object)onError2), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    private void addHistoryUpdater(@NotNull String id, @NotNull Component c, @NotNull FocusListener historyUpdater) {
        if (id == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(0);
        }
        if (c == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(1);
        }
        if (historyUpdater == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(2);
        }
        this.myComponentsById.put((Object)id, (Object)c);
        c.addFocusListener(historyUpdater);
    }

    public void disposeUIResources() {
        this.mySdkLoadingRequested = false;
    }

    public void reset() {
        this.myOriginalSdkHomePath = IdeSdksConfigurable.getIdeAndroidSdkPath();
        this.myOriginalNdkHomePath = this.getIdeNdkPath();
        this.myOriginalJdkHomePath = IdeSdksConfigurable.getIdeJdkPath();
        this.mySdkLocationTextField.setText(this.myOriginalSdkHomePath);
        this.myNdkLocationComboBox.getComboBox().setSelectedItem(this.myOriginalNdkHomePath);
        this.myJdkLocationComboBox.getComboBox().setSelectedItem(this.myOriginalJdkHomePath);
        this.myUserSelectedJdkHomePath = this.myOriginalJdkHomePath;
    }

    public void apply() throws ConfigurationException {
        if (!this.isModified()) {
            return;
        }
        if (this.validateJdkPath(this.getJdkLocation()) == null) {
            throw new ConfigurationException(IdeSdksConfigurable.generateChooseValidJdkDirectoryError());
        }
        List<ProjectConfigurationError> errors = this.validateState();
        if (!errors.isEmpty()) {
            throw new ConfigurationException(errors.get(0).getDescription().toString());
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.saveAndroidNdkPath();
            IdeSdks ideSdks = IdeSdks.getInstance();
            ideSdks.setJdkPath(this.getJdkLocation());
            ideSdks.setAndroidSdkPath(this.getSdkLocation(), this.myProject);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                IdeSdks.updateWelcomeRunAndroidSdkAction();
            }
        });
    }

    @NotNull
    public static String generateChooseValidJdkDirectoryError() {
        String string = String.format(CHOOSE_VALID_JDK_DIRECTORY_ERR_FORMAT, IdeSdks.getInstance().getRunningVersionOrDefault().getDescription());
        if (string == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void saveAndroidNdkPath() {
        if (this.myProject == null || this.myProject.isDefault()) {
            return;
        }
        try {
            LocalProperties localProperties = new LocalProperties(this.myProject);
            localProperties.setAndroidNdkPath(this.getNdkLocation());
            localProperties.save();
        }
        catch (IOException e) {
            LOG.info(String.format("Unable to update local.properties file in project '%1$s'.", this.myProject.getName()), (Throwable)e);
            String cause = e.getMessage();
            if (Strings.isNullOrEmpty((String)cause)) {
                cause = "[Unknown]";
            }
            String msg = String.format("Unable to update local.properties file in project '%1$s'.\n\nCause: %2$s\n\nPlease manually update the file's '%3$s' property value to \n'%4$s'\nand sync the project with Gradle files.", this.myProject.getName(), cause, "ndk.dir", this.getNdkLocation().getPath());
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Android Ndk Update");
        }
    }

    private void createUIComponents() {
        this.myNdkCheckProcessIcon = new AsyncProcessIcon("NDK check progress");
        this.createSdkLocationTextField();
        this.createNdkLocationComboBox();
        this.createNdkDownloadLink();
        this.createJdkLocationHelp();
        this.createJdkLocationComboBox();
    }

    private void createJdkLocationHelp() {
        this.myJdkLocationHelp = ContextHelpLabel.createWithLink(null, (String)JDK_LOCATION_TOOLTIP, (String)"Learn more", () -> BrowserUtil.browse((String)JDK_LOCATION_WARNING_URL));
    }

    private void createNdkLocationComboBox() {
        FileChooserDescriptor descriptor2 = IdeSdksConfigurable.createSingleFolderDescriptor("Choose NDK Location", (Function<File, Void>)((Function)file -> {
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidNdk(file, false);
            if (!validationResult.success) {
                this.adjustNdkQuickFixVisibility();
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = CHOOSE_VALID_NDK_DIRECTORY_ERR;
                }
                throw new IllegalArgumentException(msg);
            }
            JComboBox comboBox = this.myNdkLocationComboBox.getComboBox();
            IdeSdksConfigurable.setComboBoxFile(comboBox, file);
            return null;
        }));
        this.myNdkLocationComboBox = new ComboboxWithBrowseButton();
        this.myNdkLocationComboBox.addBrowseFolderListener(this.myProject, descriptor2);
        final JComboBox comboBox = this.myNdkLocationComboBox.getComboBox();
        File androidNdkPath = IdeSdks.getInstance().getAndroidNdkPath();
        if (androidNdkPath != null) {
            comboBox.addItem(new LabelAndFileForLocation("Default NDK (recommended)", androidNdkPath));
        }
        comboBox.setEditable(true);
        comboBox.setSelectedItem(IdeSdksConfigurable.getIdeAndroidSdkPath());
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Object selectedItem;
                if (event.getStateChange() == 1 && (selectedItem = event.getItem()) instanceof LabelAndFileForLocation) {
                    ApplicationManager.getApplication().invokeLater(() -> IdeSdksConfigurable.setComboBoxFile(comboBox, ((LabelAndFileForLocation)selectedItem).getFile()));
                }
            }
        });
        IdeSdksConfigurable.addTootlTipListener(comboBox);
    }

    private void createJdkLocationComboBox() {
        String value2;
        File envVarPath;
        String javaHomePath;
        File validatedPath;
        FileChooserDescriptor descriptor2 = IdeSdksConfigurable.createSingleFolderDescriptor("Choose JDK Location", (Function<File, Void>)((Function)file -> {
            File validatedFile = this.validateJdkPath((File)file);
            if (validatedFile == null) {
                throw new IllegalArgumentException(IdeSdksConfigurable.generateChooseValidJdkDirectoryError());
            }
            this.setJdkLocationComboBox((File)file);
            return null;
        }));
        this.myJdkLocationComboBox = new ComboboxWithBrowseButton();
        this.myJdkLocationComboBox.addBrowseFolderListener(this.myProject, descriptor2);
        JComboBox comboBox = this.myJdkLocationComboBox.getComboBox();
        IdeSdks ideSdks = IdeSdks.getInstance();
        File embeddedPath = ideSdks.getEmbeddedJdkPath();
        if (embeddedPath != null && (validatedPath = this.validateJdkPath(embeddedPath)) != null) {
            comboBox.addItem(new LabelAndFileForLocation("Embedded JDK", validatedPath));
        }
        if ((javaHomePath = IdeSdks.getJdkFromJavaHome()) != null) {
            File validatedPath2 = this.validateJdkPath(new File(javaHomePath));
            boolean bl = this.myIsJavaHomeValid = validatedPath2 != null;
            if (this.myIsJavaHomeValid) {
                comboBox.addItem(new LabelAndFileForLocation("JAVA_HOME", validatedPath2));
            }
        }
        if ((envVarPath = ideSdks.getEnvVariableJdk()) != null) {
            comboBox.addItem(new LabelAndFileForLocation("STUDIO_GRADLE_JDK", envVarPath));
        } else if (ideSdks.isJdkEnvVariableDefined() && (value2 = ideSdks.getEnvVariableJdkValue()) != null) {
            comboBox.addItem(new LabelAndPath("STUDIO_GRADLE_JDK", ideSdks.getEnvVariableJdkValue()));
        }
        comboBox.setEditable(true);
        IdeSdksConfigurable.setComboBoxFile(comboBox, this.getJdkLocation());
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    Object selectedItem = event.getItem();
                    if (selectedItem instanceof LabelAndFileForLocation) {
                        ApplicationManager.getApplication().invokeLater(() -> IdeSdksConfigurable.this.setJdkLocationComboBox(((LabelAndFileForLocation)selectedItem).getFile()));
                    } else if (selectedItem instanceof LabelAndPath) {
                        ApplicationManager.getApplication().invokeLater(() -> IdeSdksConfigurable.this.setJdkLocationComboBox(((LabelAndPath)selectedItem).getPath()));
                    }
                }
            }
        });
        IdeSdksConfigurable.addTootlTipListener(comboBox);
    }

    private static void addTootlTipListener(final @NotNull JComboBox comboBox) {
        if (comboBox == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(4);
        }
        Component component3 = comboBox.getEditor().getEditorComponent();
        component3.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                IdeSdksConfigurable.copyItemToToolTip(comboBox);
            }
        });
        component3.addKeyListener((KeyListener)new KeyStrokeAdapter(){

            public void keyTyped(KeyEvent event) {
                super.keyTyped(event);
                IdeSdksConfigurable.copyItemToToolTip(comboBox);
            }
        });
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeSdksConfigurable.copyItemToToolTip(comboBox);
            }
        });
    }

    private static void copyItemToToolTip(@NotNull JComboBox comboBox) {
        Object item;
        if (comboBox == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(5);
        }
        if ((item = comboBox.getEditor().getItem()) != null) {
            comboBox.setToolTipText(item.toString());
        } else {
            comboBox.setToolTipText("");
        }
    }

    private static void setComboBoxFile(@NotNull JComboBox comboBox, @NotNull File file) {
        if (comboBox == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(6);
        }
        if (file == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(7);
        }
        IdeSdksConfigurable.setComboBoxPath(comboBox, file.getPath());
    }

    private static void setComboBoxPath(@NotNull JComboBox comboBox, @NotNull String path2) {
        if (comboBox == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(8);
        }
        if (path2 == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(9);
        }
        comboBox.setSelectedItem(FileUtilRt.toSystemDependentName((String)path2));
    }

    private void createSdkLocationTextField() {
        FileChooserDescriptor descriptor2 = IdeSdksConfigurable.createSingleFolderDescriptor("Choose Android SDK Location", (Function<File, Void>)((Function)file -> {
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(file, false);
            if (!validationResult.success) {
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = CHOOSE_VALID_SDK_DIRECTORY_ERR;
                }
                throw new IllegalArgumentException(msg);
            }
            return null;
        }));
        final JTextField textField2 = new JTextField(10);
        this.mySdkLocationTextField = new TextFieldWithBrowseButton(textField2, e -> {
            VirtualFile chosen;
            VirtualFile suggestedDir = null;
            File sdkLocation = this.getSdkLocation();
            if (sdkLocation.isDirectory()) {
                suggestedDir = VfsUtil.findFileByIoFile((File)sdkLocation, (boolean)false);
            }
            if ((chosen = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, null, (VirtualFile)suggestedDir)) != null) {
                File f = VfsUtilCore.virtualToIoFile((VirtualFile)chosen);
                textField2.setText(FileUtilRt.toSystemDependentName((String)f.getPath()));
            }
        });
        textField2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateToolTip();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateToolTip();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateToolTip();
            }

            private void updateToolTip() {
                textField2.setToolTipText(textField2.getText());
            }
        });
    }

    private void createNdkDownloadLink() {
        this.myNdkDownloadHyperlinkLabel = new HyperlinkLabel();
        this.myNdkDownloadHyperlinkLabel.setHyperlinkText("", "Download", " Android NDK.");
        this.myNdkDownloadHyperlinkLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (IdeSdksConfigurable.this.validateAndroidSdkPath() != null) {
                    Messages.showErrorDialog((Component)IdeSdksConfigurable.this.getContentPanel(), (String)"Please select a valid SDK before downloading the NDK.");
                    return;
                }
                ImmutableList requested = ImmutableList.of((Object)"ndk-bundle");
                ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(IdeSdksConfigurable.this.myWholePanel, (Collection<String>)requested, false);
                if (dialog2 != null && dialog2.showAndGet()) {
                    File ndk = IdeSdks.getInstance().getAndroidNdkPath();
                    if (ndk != null) {
                        IdeSdksConfigurable.this.myNdkLocationComboBox.getComboBox().setSelectedItem(FileUtilRt.toSystemDependentName((String)ndk.getPath()));
                    }
                    IdeSdksConfigurable.this.validateState();
                }
            }
        });
    }

    @NotNull
    private static FileChooserDescriptor createSingleFolderDescriptor(@NotNull String title, final @NotNull Function<File, Void> validation2) {
        if (title == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(10);
        }
        if (validation2 == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(11);
        }
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(@NotNull VirtualFile[] files2) {
                if (files2 == null) {
                    9.$$$reportNull$$$0(0);
                }
                for (VirtualFile virtualFile : files2) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    validation2.fun((Object)file);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/gradle/structure/IdeSdksConfigurable$9", "validateSelectedFiles"));
            }
        };
        if (SystemInfo.isMac) {
            descriptor2.withShowHiddenFiles(true);
        }
        descriptor2.setTitle(title);
        FileChooserDescriptor fileChooserDescriptor2 = descriptor2;
        if (fileChooserDescriptor2 == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(12);
        }
        return fileChooserDescriptor2;
    }

    public String getDisplayName() {
        return AndroidBundle.message("configurable.IdeSdksConfigurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        this.maybeLoadSdks(this.myProject);
        return this.myDetailsComponent.getComponent();
    }

    @NotNull
    public JComponent getContentPanel() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(13);
        }
        return jPanel;
    }

    public boolean isModified() {
        return !Objects.equals(this.myOriginalSdkHomePath, this.getSdkLocation().getPath()) || !Objects.equals(this.myOriginalNdkHomePath, this.getNdkLocation().getPath()) || !Objects.equals(this.myOriginalJdkHomePath, this.getJdkLocation().getPath());
    }

    @Nullable
    private static Sdk getFirstDefaultAndroidSdk() {
        IdeSdks ideSdks = IdeSdks.getInstance();
        List<Sdk> allAndroidSdks = ideSdks.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdkData == null) {
            return null;
        }
        List<Sdk> sdks = ideSdks.createAndroidSdkPerAndroidTarget(sdkData.getLocation());
        return !sdks.isEmpty() ? sdks.get(0) : null;
    }

    @NotNull
    private static String getIdeAndroidSdkPath() {
        String sdkHome;
        File path2 = IdeSdks.getInstance().getAndroidSdkPath();
        if (path2 != null) {
            String string = path2.getPath();
            if (string == null) {
                IdeSdksConfigurable.$$$reportNull$$$0(14);
            }
            return string;
        }
        Sdk sdk = IdeSdksConfigurable.getFirstDefaultAndroidSdk();
        if (sdk != null && (sdkHome = sdk.getHomePath()) != null) {
            String string = FileUtilRt.toSystemDependentName((String)sdkHome);
            if (string == null) {
                IdeSdksConfigurable.$$$reportNull$$$0(15);
            }
            return string;
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private String getIdeNdkPath() {
        if (this.myProject != null && !this.myProject.isDefault()) {
            String string;
            try {
                File androidNdkPath = new LocalProperties(this.myProject).getAndroidNdkPath();
                if (androidNdkPath == null) return "";
                string = androidNdkPath.getPath();
            }
            catch (IOException e) {
                LOG.info(String.format("Unable to read local.properties file in project '%1$s'.", this.myProject.getName()), (Throwable)e);
                return "";
            }
            if (string != null) return string;
            IdeSdksConfigurable.$$$reportNull$$$0(16);
            return string;
        } else {
            File path2 = IdeSdks.getInstance().getAndroidNdkPath();
            if (path2 == null) return "";
            String string = path2.getPath();
            if (string != null) return string;
            IdeSdksConfigurable.$$$reportNull$$$0(17);
            return string;
        }
    }

    @NotNull
    private static String getIdeJdkPath() {
        File javaHome = IdeSdks.getInstance().getJdkPath();
        return javaHome != null ? javaHome.getPath() : "";
    }

    @NotNull
    private File getSdkLocation() {
        String sdkLocation = this.mySdkLocationTextField.getText();
        File file = FilePaths.toSystemDependentPath((String)sdkLocation);
        if (file == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(18);
        }
        return file;
    }

    @NotNull
    private File getNdkLocation() {
        return IdeSdksConfigurable.getLocationFromComboBoxWithBrowseButton(this.myNdkLocationComboBox);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Component toFocus = (Component)this.myComponentsById.get((Object)this.mySelectedComponentId);
        JComponent jComponent = toFocus instanceof JComponent ? (JComponent)toFocus : this.mySdkLocationTextField.getTextField();
        if (jComponent == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(19);
        }
        return jComponent;
    }

    public boolean validate() throws ConfigurationException {
        String msg = this.validateAndroidSdkPath();
        if (msg != null) {
            throw new ConfigurationException(msg);
        }
        if (this.validateJdkPath(this.getJdkLocation()) == null) {
            throw new ConfigurationException(IdeSdksConfigurable.generateChooseValidJdkDirectoryError());
        }
        msg = this.validateAndroidNdkPath();
        if (msg != null) {
            throw new ConfigurationException(msg);
        }
        return true;
    }

    @NotNull
    public List<ProjectConfigurationError> validateState() {
        ProjectConfigurationError error;
        ArrayList<ProjectConfigurationError> errors = new ArrayList<ProjectConfigurationError>();
        String msg = this.validateAndroidSdkPath();
        if (msg != null) {
            error = new ProjectConfigurationError(msg, this.mySdkLocationTextField.getTextField());
            errors.add(error);
        }
        if (this.validateJdkPath(this.getJdkLocation()) == null) {
            error = new ProjectConfigurationError(IdeSdksConfigurable.generateChooseValidJdkDirectoryError(), this.myJdkLocationComboBox.getComboBox());
            errors.add(error);
        }
        if ((msg = this.validateAndroidNdkPath()) != null) {
            error = new ProjectConfigurationError(msg, this.myNdkLocationComboBox.getComboBox());
            errors.add(error);
        }
        ArrayList<ProjectConfigurationError> arrayList = errors;
        if (arrayList == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Nullable
    private String validateAndroidSdkPath() {
        Validator.Result result2 = PathValidator.forAndroidSdkLocation().validate(this.getSdkLocation());
        Validator.Severity severity = result2.getSeverity();
        if (severity == Validator.Severity.ERROR) {
            return result2.getMessage();
        }
        SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(this.getSdkLocation(), false);
        if (!validationResult.success) {
            String msg = validationResult.message;
            if (StringUtil.isEmpty((String)msg)) {
                msg = CHOOSE_VALID_SDK_DIRECTORY_ERR;
            }
            return msg;
        }
        return null;
    }

    @Nullable
    private String validateAndroidNdkPath() {
        this.hideNdkQuickfixLink();
        Object selectedItem = this.myNdkLocationComboBox.getComboBox().getSelectedItem();
        String value2 = "";
        if (selectedItem != null) {
            value2 = selectedItem.toString();
        }
        if (!value2.isEmpty()) {
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidNdk(this.getNdkLocation(), false);
            if (!validationResult.success) {
                this.adjustNdkQuickFixVisibility();
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = CHOOSE_VALID_NDK_DIRECTORY_ERR;
                }
                return msg;
            }
        } else if (this.myNdkLocationComboBox.isVisible()) {
            this.adjustNdkQuickFixVisibility();
        }
        return null;
    }

    private void adjustNdkQuickFixVisibility() {
        boolean hasNdk = IdeSdks.getInstance().getAndroidNdkPath() != null;
        this.myNdkDownloadPanel.setVisible(!hasNdk);
    }

    private void hideNdkQuickfixLink() {
        this.myNdkDownloadPanel.setVisible(false);
    }

    @NotNull
    private File getUserSelectedJdkLocation() {
        String jdkLocation = Strings.nullToEmpty((String)this.myUserSelectedJdkHomePath);
        File file = FilePaths.toSystemDependentPath((String)jdkLocation);
        if (file == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(21);
        }
        return file;
    }

    @NotNull
    private File getJdkLocation() {
        return IdeSdksConfigurable.getLocationFromComboBoxWithBrowseButton(this.myJdkLocationComboBox);
    }

    @NotNull
    public static File getLocationFromComboBoxWithBrowseButton(@NotNull ComboboxWithBrowseButton comboboxWithBrowseButton) {
        Object item;
        if (comboboxWithBrowseButton == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(22);
        }
        if ((item = comboboxWithBrowseButton.getComboBox().getEditor().getItem()) instanceof LabelAndFileForLocation) {
            File file = ((LabelAndFileForLocation)item).getFile();
            if (file == null) {
                IdeSdksConfigurable.$$$reportNull$$$0(23);
            }
            return file;
        }
        String jdkLocation = item.toString();
        File file = FilePaths.toSystemDependentPath((String)jdkLocation);
        if (file == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(24);
        }
        return file;
    }

    @Nullable
    private File validateJdkPath(@NotNull File file) {
        File possiblePath;
        if (file == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(25);
        }
        if ((possiblePath = IdeSdks.getInstance().validateJdkPath(file)) != null) {
            this.setJdkLocationComboBox(possiblePath);
            return possiblePath;
        }
        return null;
    }

    private void setJdkLocationComboBox(@NotNull File file) {
        if (file == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(26);
        }
        this.setJdkLocationComboBox(file.getPath());
    }

    private void setJdkLocationComboBox(@NotNull String path2) {
        if (path2 == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(27);
        }
        IdeSdksConfigurable.setComboBoxPath(this.myJdkLocationComboBox.getComboBox(), path2);
    }

    public static boolean isNeeded() {
        String jdkPath = IdeSdksConfigurable.getIdeJdkPath();
        String sdkPath = IdeSdksConfigurable.getIdeAndroidSdkPath();
        IdeSdks ideSdks = IdeSdks.getInstance();
        boolean validJdk = ideSdks.isUsingEmbeddedJdk() || !jdkPath.isEmpty() && JdkUtil.checkForJdk((File)new File(jdkPath));
        boolean validSdk = !sdkPath.isEmpty() && ideSdks.isValidAndroidSdkPath(new File(sdkPath));
        return !validJdk || !validSdk;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Object path2;
        if (place != null && (path2 = place.getPath(SDKS_PLACE)) instanceof String) {
            Component c = (Component)this.myComponentsById.get(path2);
            if (requestFocus && c != null) {
                c.requestFocusInWindow();
            }
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            IdeSdksConfigurable.$$$reportNull$$$0(28);
        }
        place.putPath(SDKS_PLACE, (Object)this.mySelectedComponentId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyUpdater";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/IdeSdksConfigurable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 7: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validation";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboboxWithBrowseButton";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/IdeSdksConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateChooseValidJdkDirectoryError";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingleFolderDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPanel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeAndroidSdkPath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeNdkPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkLocation";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "validateState";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserSelectedJdkLocation";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationFromComboBoxWithBrowseButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addHistoryUpdater";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTootlTipListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyItemToToolTip";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setComboBoxFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setComboBoxPath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSingleFolderDescriptor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLocationFromComboBoxWithBrowseButton";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "validateJdkPath";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setJdkLocationComboBox";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(24, 20, 0, 20), 0, 0, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 2, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 3, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.mySdkLocationTextField;
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 9, 0, 7, 3, new Dimension(518, -1), null, new Dimension(518, -1)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 3, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html><b>Android SDK location</b><br> This location will be used for new projects and for existing projects that do not have a local.properties file with a sdk.dir property.</html>");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 7, 3, null, null, new Dimension(518, -1)));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 7, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(34, 0, 0, 0), 0, 2, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myNdkLocationComboBox;
        jPanel5.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 0, 1, 1, 9, 0, 7, 3, new Dimension(518, -1), null, new Dimension(518, -1)));
        this.myNdkDownloadPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myNdkDownloadHyperlinkLabel;
        jPanel.add((Component)hyperlinkLabel, "link");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, "loading");
        AsyncProcessIcon asyncProcessIcon = this.myNdkCheckProcessIcon;
        jPanel6.add((Component)asyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 7, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Checking availability...");
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 7, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 3, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html><b>Android NDK location</b><br> This location will be saved as ndk.dir property in the local.properties file.</html>");
        jPanel7.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, new Dimension(518, -1), new Dimension(518, -1), new Dimension(518, -1)));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(34, 0, 0, 0), 0, 2, false, false));
        jPanel2.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 1, 1, 7, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 3, 0, 0), 0, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("<html><b>JDK location</b><br>The Java Development Kit (JDK) you want Gradle to use when building your project.</html>");
        jPanel9.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        JBLabel jBLabel2 = this.myJdkLocationHelp;
        jPanel9.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 10, 0, 1, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel9.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton2 = this.myJdkLocationComboBox;
        jPanel8.add((Component)comboboxWithBrowseButton2, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 3, new Dimension(518, -1), new Dimension(130, 27), new Dimension(518, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    public static class LabelAndPath {
        @NotNull
        private String myLabel;
        @NotNull
        private String myPath;

        public LabelAndPath(@NotNull String label, @NotNull String path2) {
            if (label == null) {
                LabelAndPath.$$$reportNull$$$0(0);
            }
            if (path2 == null) {
                LabelAndPath.$$$reportNull$$$0(1);
            }
            this.myLabel = label;
            this.myPath = path2;
        }

        @NotNull
        public String getLabel() {
            String string = this.myLabel;
            if (string == null) {
                LabelAndPath.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                LabelAndPath.$$$reportNull$$$0(3);
            }
            return string;
        }

        public String toString() {
            return this.myLabel + ": " + this.myPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/structure/IdeSdksConfigurable$LabelAndPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/structure/IdeSdksConfigurable$LabelAndPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLabel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class LabelAndFileForLocation {
        @NotNull
        private String myLabel;
        @NotNull
        private File myFile;

        public LabelAndFileForLocation(@NotNull String label, @NotNull File file) {
            if (label == null) {
                LabelAndFileForLocation.$$$reportNull$$$0(0);
            }
            if (file == null) {
                LabelAndFileForLocation.$$$reportNull$$$0(1);
            }
            this.myLabel = label;
            this.myFile = file;
        }

        @NotNull
        public String getLabel() {
            String string = this.myLabel;
            if (string == null) {
                LabelAndFileForLocation.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public File getFile() {
            File file = this.myFile;
            if (file == null) {
                LabelAndFileForLocation.$$$reportNull$$$0(3);
            }
            return file;
        }

        @NotNull
        public String getSystemDependentPath() {
            String string = FileUtilRt.toSystemDependentName((String)this.myFile.getPath());
            if (string == null) {
                LabelAndFileForLocation.$$$reportNull$$$0(4);
            }
            return string;
        }

        public String toString() {
            return this.myLabel + ": " + this.getSystemDependentPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/structure/IdeSdksConfigurable$LabelAndFileForLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/structure/IdeSdksConfigurable$LabelAndFileForLocation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLabel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSystemDependentPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

