/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.run.AndroidDeviceSpec;
import com.android.tools.idea.gradle.run.BeforeRunBuilder;
import com.android.tools.idea.gradle.run.DefaultGradleBuilder;
import com.android.tools.idea.gradle.run.GradleEditTaskDialog;
import com.android.tools.idea.gradle.run.GradleModuleTasksProvider;
import com.android.tools.idea.gradle.run.GradleTaskRunner;
import com.android.tools.idea.gradle.run.MakeBeforeRunTask;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.run.OutputBuildActionUtil;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.run.AndroidAppRunConfigurationBase;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.stats.RunStats;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Ordering;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import icons.AndroidIcons;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeBeforeRunTaskProvider
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    @NotNull
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Android.Gradle.BeforeRunTask");
    private static int DEVICE_SPEC_TIMEOUT_SECONDS = 10;
    public static final String TASK_NAME = "Gradle-aware Make";
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final GradleTaskRunnerFactory myTaskRunnerFactory;

    public MakeBeforeRunTaskProvider(@NotNull Project project) {
        if (project == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myAndroidProjectInfo = AndroidProjectInfo.getInstance(project);
        this.myGradleProjectInfo = GradleProjectInfo.getInstance(project);
        this.myTaskRunnerFactory = new GradleTaskRunnerFactory(this.myProject);
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @Nullable
    public Icon getTaskIcon(MakeBeforeRunTask task2) {
        return AndroidIcons.Android;
    }

    public String getName() {
        return TASK_NAME;
    }

    public String getDescription(MakeBeforeRunTask task2) {
        String goal = task2.getGoal();
        return StringUtil.isEmpty((String)goal) ? TASK_NAME : "gradle " + goal;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public MakeBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if (this.configurationTypeIsSupported(runConfiguration)) {
            MakeBeforeRunTask task2 = new MakeBeforeRunTask();
            if (this.configurationTypeIsEnabledByDefault(runConfiguration)) {
                task2.setEnabled(true);
            }
            return task2;
        }
        return null;
    }

    public boolean configurationTypeIsSupported(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        if (this.myAndroidProjectInfo.isApkProject()) {
            return false;
        }
        return runConfiguration instanceof PreferGradleMake || MakeBeforeRunTaskProvider.isUnitTestConfiguration(runConfiguration);
    }

    public boolean configurationTypeIsEnabledByDefault(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        return runConfiguration instanceof PreferGradleMake;
    }

    private static boolean isUnitTestConfiguration(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        return runConfiguration instanceof JUnitConfiguration || runConfiguration.getClass().getSimpleName().equals("TestNGConfiguration");
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull MakeBeforeRunTask task2) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (task2 == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        GradleEditTaskDialog dialog2 = new GradleEditTaskDialog(this.myProject);
        dialog2.setGoal(task2.getGoal());
        dialog2.setAvailableGoals(this.createAvailableTasks());
        if (!dialog2.showAndGet()) {
            task2.setInvalid();
            return false;
        }
        task2.setGoal(dialog2.getGoal());
        return true;
    }

    @NotNull
    private List<String> createAvailableTasks() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ArrayList<String> gradleTasks = new ArrayList<String>();
        for (Module module : moduleManager.getModules()) {
            GradleModuleModel gradleModuleModel;
            GradleFacet facet2 = GradleFacet.getInstance(module);
            if (facet2 == null || (gradleModuleModel = facet2.getGradleModuleModel()) == null) continue;
            gradleTasks.addAll(gradleModuleModel.getTaskNames());
        }
        ArrayList<String> arrayList = gradleTasks;
        if (arrayList == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull MakeBeforeRunTask task2) {
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        if (task2 == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(9);
        }
        return task2.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull MakeBeforeRunTask task2) {
        if (context == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(11);
        }
        if (env == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(12);
        }
        if (task2 == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(13);
        }
        RunStats stats = RunStats.from(env);
        try {
            stats.beginBeforeRunTasks();
            boolean bl = this.doExecuteTask(context, configuration, env, task2);
            return bl;
        }
        finally {
            stats.endBeforeRunTasks();
        }
    }

    @VisibleForTesting
    @NotNull
    SyncNeeded isSyncNeeded(@NotNull DataContext context, @NotNull RunConfiguration configuration) {
        if (context == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(14);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(15);
        }
        if (GradleSyncState.getInstance(this.myProject).isSyncNeeded() != ThreeState.NO && (AndroidGradleBuildConfiguration.getInstance((Project)this.myProject).SYNC_PROJECT_BEFORE_BUILD || !this.isPostBuildSyncSupported(context, configuration))) {
            SyncNeeded syncNeeded = SyncNeeded.SINGLE_VARIANT_SYNC_NEEDED;
            if (syncNeeded == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(16);
            }
            return syncNeeded;
        }
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            NdkModuleModel ndkModel = NdkModuleModel.get(module);
            if (ndkModel == null || ndkModel.getVariants().size() >= ndkModel.getNdkVariantNames().size()) continue;
            SyncNeeded syncNeeded = SyncNeeded.FULL_SYNC_NEEDED;
            if (syncNeeded == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(17);
            }
            return syncNeeded;
        }
        SyncNeeded syncNeeded = SyncNeeded.NOT_NEEDED;
        if (syncNeeded == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(18);
        }
        return syncNeeded;
    }

    @Nullable
    private String runSync(@NotNull SyncNeeded syncNeeded) {
        if (syncNeeded == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(19);
        }
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_RUN_SYNC_NEEDED_BEFORE_RUNNING);
        request.runInBackground = false;
        request.forceFullVariantsSync = syncNeeded.isFullSync;
        final AtomicReference errorMsgRef = new AtomicReference();
        GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, request, new GradleSyncListener(){

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                errorMsgRef.set(errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "errorMessage";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$1";
                objectArray[2] = "syncFailed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        String result2 = (String)errorMsgRef.get();
        return result2;
    }

    private boolean isPostBuildSyncSupported(@NotNull DataContext context, @NotNull RunConfiguration configuration) {
        Module[] modules;
        if (context == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(20);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(21);
        }
        for (Module module : modules = this.getModules(context, configuration)) {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel == null || androidModuleModel.getFeatures().isPostBuildSyncSupported()) continue;
            return false;
        }
        return true;
    }

    private boolean doExecuteTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, MakeBeforeRunTask task2) {
        List<String> cmdLineArgs;
        String errorMsg;
        if (!this.myAndroidProjectInfo.requiresAndroidModel() || !this.myGradleProjectInfo.isDirectGradleBuildEnabled()) {
            CompileStepBeforeRun regularMake = new CompileStepBeforeRun(this.myProject);
            return regularMake.executeTask(context, configuration, env, new CompileStepBeforeRun.MakeBeforeRunTask());
        }
        SyncNeeded syncNeeded = this.isSyncNeeded(context, configuration);
        if (syncNeeded != SyncNeeded.NOT_NEEDED && (errorMsg = this.runSync(syncNeeded)) != null) {
            MakeBeforeRunTaskProvider.getLog().info("Unable to launch 'Gradle-aware Make' task. Project sync failed with message: " + errorMsg);
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (configuration instanceof RunProfileWithCompileBeforeLaunchOption && ((RunProfileWithCompileBeforeLaunchOption)configuration).isExcludeCompileBeforeLaunchOption()) {
            return true;
        }
        Module[] modules = this.getModules(context, configuration);
        DeviceFutures deviceFutures = (DeviceFutures)env.getCopyableUserData(DeviceFutures.KEY);
        List<AndroidDevice> targetDevices = deviceFutures == null ? Collections.emptyList() : deviceFutures.getDevices();
        try {
            cmdLineArgs = MakeBeforeRunTaskProvider.getCommonArguments(modules, configuration, targetDevices);
        }
        catch (Exception e) {
            MakeBeforeRunTaskProvider.getLog().warn("Error generating command line arguments for Gradle task", (Throwable)e);
            return false;
        }
        BeforeRunBuilder builder2 = MakeBeforeRunTaskProvider.createBuilder(modules, configuration, targetDevices, task2.getGoal());
        GradleTaskRunner.DefaultGradleTaskRunner runner = this.myTaskRunnerFactory.createTaskRunner(configuration);
        BuildSettings.getInstance(this.myProject).setRunConfigurationTypeId(configuration.getType().getId());
        try {
            boolean success2 = builder2.build(runner, cmdLineArgs);
            if (configuration instanceof AndroidRunConfigurationBase) {
                Object model2 = runner.getModel();
                if (model2 instanceof OutputBuildAction.PostBuildProjectModels) {
                    ((AndroidRunConfigurationBase)configuration).setOutputModel(new PostBuildModel((OutputBuildAction.PostBuildProjectModels)model2));
                } else {
                    MakeBeforeRunTaskProvider.getLog().info("Couldn't get post build models.");
                }
            }
            MakeBeforeRunTaskProvider.getLog().info("Gradle invocation complete, success = " + success2);
            return success2;
        }
        catch (InvocationTargetException e) {
            MakeBeforeRunTaskProvider.getLog().info("Unexpected error while launching gradle before run tasks", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            MakeBeforeRunTaskProvider.getLog().info("Interrupted while launching gradle before run tasks");
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(MakeBeforeRunTask.class);
        if (logger2 == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(22);
        }
        return logger2;
    }

    @NotNull
    private static List<String> getCommonArguments(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) throws IOException {
        if (modules == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(23);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(24);
        }
        if (targetDevices == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(25);
        }
        ArrayList<String> cmdLineArgs = new ArrayList<String>();
        cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getDeviceSpecificArguments(modules, configuration, targetDevices));
        cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getProfilingOptions(configuration, targetDevices));
        ArrayList<String> arrayList = cmdLineArgs;
        if (arrayList == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getDeviceSpecificArguments(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> devices2) throws IOException {
        AndroidDeviceSpec deviceSpec;
        if (modules == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(27);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(28);
        }
        if (devices2 == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(29);
        }
        if ((deviceSpec = AndroidDeviceSpec.create(devices2, MakeBeforeRunTaskProvider.shouldCollectListOfLanguages(modules, configuration, devices2), DEVICE_SPEC_TIMEOUT_SECONDS, TimeUnit.SECONDS)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(30);
            }
            return list;
        }
        ArrayList<String> properties = new ArrayList<String>(3);
        if (MakeBeforeRunTaskProvider.useSelectApksFromBundleBuilder(modules, configuration, devices2)) {
            File deviceSpecFile = deviceSpec.writeToJsonTempFile();
            properties.add(AndroidGradleSettings.createProjectProperty((String)"android.inject.apkselect.config", (String)deviceSpecFile.getAbsolutePath()));
            if (configuration instanceof AndroidAppRunConfigurationBase) {
                String featureList;
                AndroidAppRunConfigurationBase androidRunConfigurationbase = (AndroidAppRunConfigurationBase)configuration;
                if (((AndroidAppRunConfigurationBase)configuration).DEPLOY_AS_INSTANT) {
                    properties.add(AndroidGradleSettings.createProjectProperty((String)"android.inject.bundle.extractinstant", (boolean)true));
                }
                if (androidRunConfigurationbase.DEPLOY_APK_FROM_BUNDLE && !(featureList = MakeBeforeRunTaskProvider.getEnabledDynamicFeatureList(modules, androidRunConfigurationbase)).isEmpty()) {
                    properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.modules.install.list", (String)featureList));
                }
            }
        } else {
            properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.api", (String)Integer.toString(deviceSpec.getApiLevel())));
            if (deviceSpec.getApiCodeName() != null) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.codename", (String)deviceSpec.getApiCodeName()));
            }
            if (deviceSpec.getBuildDensity() != null) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.density", (String)deviceSpec.getBuildDensity().getResourceValue()));
            }
            if (!deviceSpec.getBuildAbis().isEmpty()) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.abi", (String)Joiner.on((char)',').join(deviceSpec.getBuildAbis())));
            }
            if (configuration instanceof AndroidAppRunConfigurationBase && ((AndroidAppRunConfigurationBase)configuration).DEPLOY_AS_INSTANT) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.deploy.instant-app", (boolean)true));
            }
        }
        ArrayList<String> arrayList = properties;
        if (arrayList == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    private static String getEnabledDynamicFeatureList(@NotNull Module[] modules, @NotNull AndroidAppRunConfigurationBase configuration) {
        if (modules == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(32);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(33);
        }
        HashSet<String> disabledFeatures = new HashSet<String>(configuration.getDisabledDynamicFeatures());
        String string = Arrays.stream(modules).flatMap(module -> DynamicAppUtils.getDependentFeatureModulesForBase(module).stream()).map(Module::getName).filter(name -> !disabledFeatures.contains(name)).map(moduleName2 -> {
            int index = moduleName2.lastIndexOf(46);
            return index < 0 ? moduleName2 : moduleName2.substring(index + 1);
        }).collect(Collectors.joining(","));
        if (string == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static List<String> getProfilingOptions(@NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> devices2) throws IOException {
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(35);
        }
        if (devices2 == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(36);
        }
        if (!(configuration instanceof AndroidRunConfigurationBase) || devices2.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(37);
            }
            return list;
        }
        List versionLists = devices2.stream().map(AndroidDevice::getVersion).collect(Collectors.toList());
        AndroidVersion minVersion = (AndroidVersion)Ordering.natural().min(versionLists);
        LinkedList<String> arguments = new LinkedList<String>();
        ProfilerState state = ((AndroidRunConfigurationBase)configuration).getProfilerState();
        if (state.ADVANCED_PROFILING_ENABLED && minVersion.getFeatureLevel() >= 21 && minVersion.getFeatureLevel() < 26) {
            File file = EmbeddedDistributionPaths.getInstance().findEmbeddedProfilerTransform(minVersion);
            arguments.add(AndroidGradleSettings.createProjectProperty((String)"android.advanced.profiling.transforms", (String)file.getAbsolutePath()));
            Properties profilerProperties = state.toProperties();
            File propertiesFile = FileUtil.createTempFile((String)"profiler", (String)".properties");
            propertiesFile.deleteOnExit();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(propertiesFile), Charsets.UTF_8);
            profilerProperties.store(writer, "Android Studio Profiler Gradle Plugin Properties");
            ((Writer)writer).close();
            arguments.add(AndroidGradleSettings.createJvmArg((String)"android.profiler.properties", (String)propertiesFile.getAbsolutePath()));
        }
        LinkedList<String> linkedList = arguments;
        if (linkedList == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(38);
        }
        return linkedList;
    }

    @NotNull
    private static BeforeRunBuilder createBuilder(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices, @Nullable String userGoal) {
        if (modules == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(39);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(40);
        }
        if (targetDevices == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(41);
        }
        if (modules.length == 0) {
            throw new IllegalStateException("Unable to determine list of modules to build");
        }
        if (!StringUtil.isEmpty((String)userGoal)) {
            ArrayListMultimap tasks = ArrayListMultimap.create();
            ((StreamEx)StreamEx.of((Object[])modules).map(module -> ExternalSystemApiUtil.getExternalRootProjectPath((Module)module)).nonNull().distinct()).map(path2 -> Paths.get(path2, new String[0])).forEach(arg_0 -> MakeBeforeRunTaskProvider.lambda$createBuilder$5((ListMultimap)tasks, userGoal, arg_0));
            return new DefaultGradleBuilder((ListMultimap<Path, String>)tasks, null);
        }
        GradleModuleTasksProvider gradleTasksProvider = new GradleModuleTasksProvider(modules);
        TestCompileType testCompileType = TestCompileType.get(configuration.getType().getId());
        if (testCompileType == TestCompileType.UNIT_TESTS) {
            BuildMode buildMode = BuildMode.COMPILE_JAVA;
            return new DefaultGradleBuilder(gradleTasksProvider.getUnitTestTasks(buildMode), buildMode);
        }
        if (MakeBeforeRunTaskProvider.useSelectApksFromBundleBuilder(modules, configuration, targetDevices)) {
            return new DefaultGradleBuilder(gradleTasksProvider.getTasksFor(BuildMode.APK_FROM_BUNDLE, testCompileType), BuildMode.APK_FROM_BUNDLE);
        }
        return new DefaultGradleBuilder(gradleTasksProvider.getTasksFor(BuildMode.ASSEMBLE, testCompileType), BuildMode.ASSEMBLE);
    }

    private static boolean useSelectApksFromBundleBuilder(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        if (modules == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(42);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(43);
        }
        if (targetDevices == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(44);
        }
        return Arrays.stream(modules).anyMatch(module -> DynamicAppUtils.useSelectApksFromBundleBuilder(module, configuration, targetDevices));
    }

    private static boolean shouldCollectListOfLanguages(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        if (modules == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(45);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(46);
        }
        if (targetDevices == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(47);
        }
        return Arrays.stream(modules).allMatch(module -> DynamicAppUtils.shouldCollectListOfLanguages(module, configuration, targetDevices));
    }

    @NotNull
    private Module[] getModules(@Nullable DataContext context, @Nullable RunConfiguration configuration) {
        if (configuration instanceof ModuleRunProfile) {
            if (configuration instanceof AndroidJUnitConfiguration) {
                Module[] moduleArray = ((AndroidJUnitConfiguration)configuration).getModulesToCompile();
                if (moduleArray == null) {
                    MakeBeforeRunTaskProvider.$$$reportNull$$$0(48);
                }
                return moduleArray;
            }
            Module[] moduleArray = ((ModuleRunProfile)configuration).getModules();
            if (moduleArray == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(49);
            }
            return moduleArray;
        }
        Module[] moduleArray = this.myGradleProjectInfo.getModulesToBuildFromSelection(context);
        if (moduleArray == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(50);
        }
        return moduleArray;
    }

    @Nullable
    public static IDevice getLaunchedDevice(@NotNull AndroidDevice device) {
        if (device == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(51);
        }
        if (!device.getLaunchedDevice().isDone()) {
            return null;
        }
        try {
            return (IDevice)device.getLaunchedDevice().get(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
    }

    private static /* synthetic */ void lambda$createBuilder$5(ListMultimap tasks, String userGoal, Path path2) {
        tasks.put((Object)path2, (Object)userGoal);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 48: 
            case 49: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 48: 
            case 49: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 21: 
            case 24: 
            case 28: 
            case 33: 
            case 35: 
            case 40: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncNeeded";
                break;
            }
            case 23: 
            case 27: 
            case 32: 
            case 39: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 25: 
            case 41: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDevices";
                break;
            }
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAvailableTasks";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "isSyncNeeded";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonArguments";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceSpecificArguments";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledDynamicFeatureList";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingOptions";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "configurationTypeIsSupported";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configurationTypeIsEnabledByDefault";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnitTestConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureTask";
                break;
            }
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 48: 
            case 49: 
            case 50: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canExecuteTask";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSyncNeeded";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runSync";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPostBuildSyncSupported";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCommonArguments";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceSpecificArguments";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledDynamicFeatureList";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getProfilingOptions";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "useSelectApksFromBundleBuilder";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "shouldCollectListOfLanguages";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchedDevice";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 48: 
            case 49: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class GradleTaskRunnerFactory {
        @NotNull
        private final Project myProject;

        GradleTaskRunnerFactory(@NotNull Project project) {
            if (project == null) {
                GradleTaskRunnerFactory.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @NotNull
        GradleTaskRunner.DefaultGradleTaskRunner createTaskRunner(@NotNull RunConfiguration configuration) {
            if (configuration == null) {
                GradleTaskRunnerFactory.$$$reportNull$$$0(1);
            }
            if (configuration instanceof AndroidRunConfigurationBase) {
                ArrayList<Module> modules = new ArrayList<Module>();
                Module selectedModule = ((JavaRunConfigurationModule)((AndroidRunConfigurationBase)configuration).getConfigurationModule()).getModule();
                if (selectedModule != null) {
                    Module baseModule;
                    modules.add(selectedModule);
                    if (configuration instanceof AndroidTestRunConfiguration && (baseModule = DynamicAppUtils.getBaseFeature(selectedModule)) != null) {
                        modules.add(baseModule);
                    }
                }
                GradleTaskRunner.DefaultGradleTaskRunner defaultGradleTaskRunner = GradleTaskRunner.newRunner(this.myProject, OutputBuildActionUtil.create(modules));
                if (defaultGradleTaskRunner == null) {
                    GradleTaskRunnerFactory.$$$reportNull$$$0(2);
                }
                return defaultGradleTaskRunner;
            }
            GradleTaskRunner.DefaultGradleTaskRunner defaultGradleTaskRunner = GradleTaskRunner.newRunner(this.myProject, null);
            if (defaultGradleTaskRunner == null) {
                GradleTaskRunnerFactory.$$$reportNull$$$0(3);
            }
            return defaultGradleTaskRunner;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$GradleTaskRunnerFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$GradleTaskRunnerFactory";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTaskRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createTaskRunner";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @VisibleForTesting
    static enum SyncNeeded {
        NOT_NEEDED(false),
        SINGLE_VARIANT_SYNC_NEEDED(false),
        FULL_SYNC_NEEDED(true);

        public final boolean isFullSync;

        private SyncNeeded(boolean isFullSync) {
            this.isFullSync = isFullSync;
        }
    }
}

