/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.android.tools.idea.gradle.util.GeneratedSourceFolders;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ExtraGeneratedFolderValidationStrategy
extends AndroidProjectValidationStrategy {
    @NotNull
    private final List<File> myExtraGeneratedSourceFolderPaths;
    @NotNull
    private final GeneratedSourceFolders myGeneratedSourceFolders;

    ExtraGeneratedFolderValidationStrategy(@NotNull Project project) {
        if (project == null) {
            ExtraGeneratedFolderValidationStrategy.$$$reportNull$$$0(0);
        }
        this(project, new GeneratedSourceFolders());
    }

    ExtraGeneratedFolderValidationStrategy(@NotNull Project project, @NotNull GeneratedSourceFolders generatedSourceFolders) {
        if (project == null) {
            ExtraGeneratedFolderValidationStrategy.$$$reportNull$$$0(1);
        }
        if (generatedSourceFolders == null) {
            ExtraGeneratedFolderValidationStrategy.$$$reportNull$$$0(2);
        }
        super(project);
        this.myExtraGeneratedSourceFolderPaths = new ArrayList<File>();
        this.myGeneratedSourceFolders = generatedSourceFolders;
    }

    @Override
    void validate(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        File[] sourceFolderPaths;
        if (module == null) {
            ExtraGeneratedFolderValidationStrategy.$$$reportNull$$$0(3);
        }
        if (androidModel == null) {
            ExtraGeneratedFolderValidationStrategy.$$$reportNull$$$0(4);
        }
        IdeAndroidProject androidProject = androidModel.getAndroidProject();
        for (File path2 : sourceFolderPaths = androidModel.getExtraGeneratedSourceFolderPaths()) {
            if (this.myGeneratedSourceFolders.isFolderGeneratedInCorrectLocation(path2, androidProject)) continue;
            this.myExtraGeneratedSourceFolderPaths.add(path2);
        }
    }

    @Override
    void fixAndReportFoundIssues() {
        if (!this.myExtraGeneratedSourceFolderPaths.isEmpty()) {
            GradleSyncMessages messages = GradleSyncMessages.getInstance(this.getProject());
            Collections.sort(this.myExtraGeneratedSourceFolderPaths);
            for (File folder : this.myExtraGeneratedSourceFolderPaths) {
                String[] text = new String[]{"Folder " + folder.getPath()};
                messages.report(new SyncMessage("Generated Sources", MessageType.WARNING, text));
            }
            messages.report(new SyncMessage("Generated Sources", MessageType.INFO, "3rd-party Gradle plug-ins may be the cause"));
        }
    }

    @VisibleForTesting
    @NotNull
    List<File> getExtraGeneratedSourceFolderPaths() {
        List<File> list = this.myExtraGeneratedSourceFolderPaths;
        if (list == null) {
            ExtraGeneratedFolderValidationStrategy.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedSourceFolders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/validation/android/ExtraGeneratedFolderValidationStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/validation/android/ExtraGeneratedFolderValidationStrategy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraGeneratedSourceFolderPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

