/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.utils.BuildScriptUtil;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class IgnoredBuildScriptSetupStep
extends ProjectSetupStep {
    @Override
    public void setUpProject(@NotNull Project project) {
        File projectPath;
        File projectBuildPath;
        if (project == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(0);
        }
        if ((projectBuildPath = BuildScriptUtil.findGradleBuildFile((File)(projectPath = Projects.getBaseDirPath((Project)project)))).exists()) {
            IgnoredBuildScriptSetupStep.checkIsNotIgnored("Build script for project " + project.getName(), projectBuildPath, project);
        }
        File dotGradleFolder = new File(projectPath, ".gradle");
        IgnoredBuildScriptSetupStep.checkIsNotIgnored("Project " + project.getName() + " .gradle folder", dotGradleFolder, project);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            File buildPath;
            GradleModuleModel gradleModel;
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null || (gradleModel = gradleFacet.getGradleModuleModel()) == null || (buildPath = gradleModel.getBuildFilePath()) == null || !buildPath.exists() || FileUtils.isSameFile((File)buildPath, (File)projectBuildPath)) continue;
            IgnoredBuildScriptSetupStep.checkIsNotIgnored("Build script for module " + module.getName(), buildPath, project);
        }
    }

    @Override
    public boolean invokeOnFailedSync() {
        return false;
    }

    public static String getIgnoredFileTypesPathInSettings() {
        return String.format("%s \u2192 Editor \u2192 File Types", ShowSettingsUtil.getSettingsMenuName());
    }

    public static void checkIsNotIgnored(@NotNull String prefix, @NotNull File path2, @NotNull Project project) {
        if (prefix == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(1);
        }
        if (path2 == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(2);
        }
        if (project == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(3);
        }
        IgnoredBuildScriptSetupStep.checkIsNotIgnored(prefix, path2, FileTypeManager.getInstance(), GradleSyncMessages.getInstance(project));
    }

    @VisibleForTesting
    static void checkIsNotIgnored(@NotNull String prefix, @NotNull File path2, @NotNull FileTypeManager fileTypeManager, @NotNull GradleSyncMessages messages) {
        if (prefix == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(4);
        }
        if (path2 == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(5);
        }
        if (fileTypeManager == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(6);
        }
        if (messages == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(7);
        }
        if (fileTypeManager.isFileIgnored(path2.getPath())) {
            String[] text = new String[]{prefix + " is being ignored. This can cause issues on the IDE.", "You can change ignored files and folders from " + IgnoredBuildScriptSetupStep.getIgnoredFileTypesPathInSettings()};
            SyncMessage message2 = new SyncMessage("Gradle Sync Issues", MessageType.WARNING, text);
            message2.add(new NotificationHyperlink("open.settings.filetypes", "Open in Settings"){

                @Override
                protected void execute(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, "preferences.fileTypes");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/project/IgnoredBuildScriptSetupStep$1", "execute"));
                }
            });
            message2.add(new OpenFileHyperlink(path2.getPath(), "Open ignored " + (path2.isDirectory() ? "folder location" : "file"), -1, -1));
            messages.report(message2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/project/IgnoredBuildScriptSetupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpProject";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIsNotIgnored";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

