/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.android.tools.idea.project.AndroidNotification;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import java.util.Calendar;
import org.jetbrains.annotations.NotNull;

public class ExpiredPreviewBuildSetupStep
extends ProjectSetupStep {
    @NotNull
    private final ApplicationInfo myApplicationInfo;
    private volatile boolean myExpirationChecked;

    public ExpiredPreviewBuildSetupStep() {
        this(ApplicationInfo.getInstance());
    }

    public ExpiredPreviewBuildSetupStep(@NotNull ApplicationInfo applicationInfo) {
        if (applicationInfo == null) {
            ExpiredPreviewBuildSetupStep.$$$reportNull$$$0(0);
        }
        this.myApplicationInfo = applicationInfo;
    }

    @Override
    public void setUpProject(@NotNull Project project) {
        if (project == null) {
            ExpiredPreviewBuildSetupStep.$$$reportNull$$$0(1);
        }
        if (this.myExpirationChecked) {
            return;
        }
        String ideVersion = this.myApplicationInfo.getFullVersion();
        if (ExpiredPreviewBuildSetupStep.isPreview(ideVersion)) {
            Calendar expirationDate = (Calendar)this.myApplicationInfo.getBuildDate().clone();
            expirationDate.add(2, 2);
            Calendar now = Calendar.getInstance();
            if (now.after(expirationDate)) {
                String message2 = String.format("This preview build (%1$s) is old; please update to a newer preview or a stable version.", ideVersion);
                OpenUrlHyperlink hyperlink = new OpenUrlHyperlink("https://developer.android.com/r/studio-ui/download-canary.html", "Get the Latest Version");
                AndroidNotification.getInstance(project).showBalloon("Old Preview Build", message2, NotificationType.INFORMATION, hyperlink);
                this.myExpirationChecked = true;
            }
        }
    }

    private static boolean isPreview(@NotNull String ideVersion) {
        if (ideVersion == null) {
            ExpiredPreviewBuildSetupStep.$$$reportNull$$$0(2);
        }
        return ideVersion.contains("Preview") || ideVersion.contains("Beta") || ideVersion.contains("RC");
    }

    @Override
    public boolean invokeOnFailedSync() {
        return true;
    }

    @VisibleForTesting
    boolean isExpirationChecked() {
        return this.myExpirationChecked;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideVersion";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/project/ExpiredPreviewBuildSetupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPreview";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

