/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.annotations.concurrency.Slow;
import com.android.builder.model.SyncIssue;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectBuildFileChecksums;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.RunConfigurationChecker;
import com.android.tools.idea.gradle.project.SupportedModuleChecker;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncFailure;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupIssues;
import com.android.tools.idea.gradle.project.sync.setup.post.ComposeInBetaChecker;
import com.android.tools.idea.gradle.project.sync.setup.post.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetup;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProvider;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.profiles.ProjectProfileSelectionDialog;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PostSyncProjectSetup {
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final ProjectStructure myProjectStructure;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final GradleSyncInvoker mySyncInvoker;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final DependencySetupIssues myDependencySetupIssues;
    @NotNull
    private final ProjectSetup myProjectSetup;
    @NotNull
    private final ModuleSetup myModuleSetup;

    @NotNull
    public static PostSyncProjectSetup getInstance(@NotNull Project project) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(0);
        }
        PostSyncProjectSetup postSyncProjectSetup = (PostSyncProjectSetup)ServiceManager.getService((Project)project, PostSyncProjectSetup.class);
        if (postSyncProjectSetup == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(1);
        }
        return postSyncProjectSetup;
    }

    public PostSyncProjectSetup(@NotNull Project project) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(2);
        }
        this(project, IdeInfo.getInstance(), ProjectStructure.getInstance(project), GradleProjectInfo.getInstance(project), GradleSyncInvoker.getInstance(), GradleSyncState.getInstance(project), DependencySetupIssues.getInstance(project), new ProjectSetup(project), new ModuleSetup(project));
    }

    @NonInjectable
    @VisibleForTesting
    PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull ProjectStructure projectStructure, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull DependencySetupIssues dependencySetupIssues, @NotNull ProjectSetup projectSetup, @NotNull ModuleSetup moduleSetup) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(3);
        }
        if (ideInfo == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(4);
        }
        if (projectStructure == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(5);
        }
        if (gradleProjectInfo == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(6);
        }
        if (syncInvoker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(7);
        }
        if (syncState == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(8);
        }
        if (dependencySetupIssues == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(9);
        }
        if (projectSetup == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(10);
        }
        if (moduleSetup == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(11);
        }
        this.myProject = project;
        this.myIdeInfo = ideInfo;
        this.myProjectStructure = projectStructure;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.mySyncInvoker = syncInvoker;
        this.mySyncState = syncState;
        this.myDependencySetupIssues = dependencySetupIssues;
        this.myProjectSetup = projectSetup;
        this.myModuleSetup = moduleSetup;
    }

    @Slow
    public void setUpProject(@NotNull Request request, @Nullable ExternalSystemTaskId taskId, @Nullable GradleSyncListener syncListener) {
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(12);
        }
        try {
            ModuleSetupContext.removeSyncContextDataFrom(this.myProject);
            this.myGradleProjectInfo.setNewProject(false);
            this.myGradleProjectInfo.setImportedProject(false);
            boolean syncFailed2 = this.mySyncState.lastSyncFailed();
            if (syncFailed2 && request.usingCachedGradleModels) {
                this.onCachedModelsSetupFailure(taskId, request);
                return;
            }
            ComposeInBetaChecker.checkIfComposeProject(this.myProject);
            this.myDependencySetupIssues.reportIssues();
            if (this.mySyncState.lastSyncFailed()) {
                this.failTestsIfSyncIssuesPresent();
                this.myProjectSetup.setUpProject(true);
                String message2 = "Sync issues found";
                this.mySyncState.syncFailed(message2, new RuntimeException(message2), syncListener);
                PostSyncProjectSetup.finishFailedSync(taskId, this.myProject, message2);
                return;
            }
            SupportedModuleChecker.getInstance().checkForSupportedModules(this.myProject);
            this.findAndShowVariantConflicts();
            this.myProjectSetup.setUpProject(false);
            this.modifyJUnitRunConfigurations();
            RunConfigurationChecker.getInstance(this.myProject).ensureRunConfigsInvokeBuild();
            this.myProjectStructure.analyzeProjectStructure();
            this.updateJavaLanguageLevel();
            this.notifySyncFinished(request);
            this.myModuleSetup.setUpModules(null);
            this.finishSuccessfulSync(taskId);
        }
        catch (Throwable t) {
            this.mySyncState.syncFailed("setup project failed: " + t.getMessage(), t, syncListener);
            PostSyncProjectSetup.finishFailedSync(taskId, this.myProject, t.getMessage());
        }
    }

    @VisibleForTesting
    void updateJavaLanguageLevel() {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

            public void execute() {
                LanguageLevelProjectExtension ext;
                LanguageLevel langLevel;
                if (PostSyncProjectSetup.this.myProject.isOpen() && (langLevel = PostSyncProjectSetup.getMaxJavaLanguageLevel(PostSyncProjectSetup.this.myProject)) != null && langLevel != (ext = LanguageLevelProjectExtension.getInstance((Project)PostSyncProjectSetup.this.myProject)).getLanguageLevel()) {
                    ext.setLanguageLevel(langLevel);
                }
            }
        });
    }

    @VisibleForTesting
    @Nullable
    static LanguageLevel getMaxJavaLanguageLevel(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(13);
        }
        LanguageLevel maxLangLevel = null;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            LanguageLevel langLevel;
            AndroidModuleModel androidModel;
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
            if (facet2 == null || (androidModel = AndroidModuleModel.get(facet2)) == null || (langLevel = androidModel.getJavaLanguageLevel()) == null || maxLangLevel != null && maxLangLevel.compareTo((Enum)langLevel) >= 0) continue;
            maxLangLevel = langLevel;
        }
        return maxLangLevel;
    }

    private void finishSuccessfulSync(@Nullable ExternalSystemTaskId taskId) {
        if (taskId == null) {
            return;
        }
        GradleSyncMessages messages = GradleSyncMessages.getInstance(this.myProject);
        List<Failure> failures = messages.showEvents(taskId);
        Object result2 = failures.isEmpty() ? new SuccessResultImpl() : new FailureResultImpl(failures);
        FinishBuildEventImpl finishBuildEvent = new FinishBuildEventImpl((Object)taskId, null, System.currentTimeMillis(), "successful", (EventResult)result2);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myProject.isDisposed()) {
                ((SyncViewManager)ServiceManager.getService((Project)this.myProject, SyncViewManager.class)).onEvent((Object)taskId, (BuildEvent)finishBuildEvent);
            }
        });
    }

    public static void finishFailedSync(@Nullable ExternalSystemTaskId taskId, @NotNull Project project, @Nullable String exceptionMessage) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(14);
        }
        if (taskId != null) {
            GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
            ArrayList<Failure> failures = new ArrayList<Failure>(messages.showEvents(taskId));
            if (exceptionMessage != null && failures.isEmpty()) {
                NotificationData notificationData = new NotificationData(exceptionMessage, exceptionMessage, NotificationCategory.ERROR, NotificationSource.PROJECT_SYNC);
                failures.add(AndroidSyncFailure.create(notificationData));
            }
            FailureResultImpl failureResult = new FailureResultImpl(failures);
            FinishBuildEventImpl finishBuildEvent = new FinishBuildEventImpl((Object)taskId, null, System.currentTimeMillis(), "failed", (EventResult)failureResult);
            ((SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class)).onEvent((Object)taskId, (BuildEvent)finishBuildEvent);
        }
    }

    public void onCachedModelsSetupFailure(@Nullable ExternalSystemTaskId taskId, @NotNull Request request) {
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(15);
        }
        PostSyncProjectSetup.finishFailedSync(taskId, this.myProject, null);
        long syncTimestamp = request.lastSyncTimestamp;
        if (syncTimestamp < 0L) {
            syncTimestamp = System.currentTimeMillis();
        }
        this.mySyncState.syncSkipped(syncTimestamp, null);
        this.mySyncInvoker.requestProjectSync(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_CACHED_SETUP_FAILED);
    }

    private void failTestsIfSyncIssuesPresent() {
        if (ApplicationManager.getApplication().isUnitTestMode() && GradleSyncMessages.getInstance(this.myProject).getErrorCount() > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Sync issues found!").append('\n');
            this.myGradleProjectInfo.forEachAndroidModule((Consumer<AndroidFacet>)((Consumer)facet2 -> {
                Collection<SyncIssue> issues;
                AndroidModel androidModel = AndroidModel.get(facet2);
                if (androidModel instanceof AndroidModuleModel && (issues = ((AndroidModuleModel)androidModel).getSyncIssues()) != null && !issues.isEmpty()) {
                    buffer.append("Module '").append(facet2.getModule().getName()).append("':").append('\n');
                    for (SyncIssue issue2 : issues) {
                        buffer.append(issue2.getMessage()).append('\n');
                    }
                }
            }));
            throw new IllegalStateException(buffer.toString());
        }
    }

    private void notifySyncFinished(@NotNull Request request) {
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(16);
        }
        if (request.usingCachedGradleModels) {
            long timestamp = System.currentTimeMillis();
            this.mySyncState.syncSkipped(timestamp, null);
            GradleBuildState.getInstance(this.myProject).buildFinished(BuildStatus.SKIPPED);
        } else {
            if (this.mySyncState.lastSyncFailed()) {
                this.mySyncState.syncFailed("", null, null);
            } else {
                this.mySyncState.syncSucceeded();
            }
            ProjectBuildFileChecksums.saveToDisk(this.myProject);
        }
    }

    private void findAndShowVariantConflicts() {
        ConflictSet conflicts = ConflictSet.findConflicts(this.myProject);
        List<Conflict> structureConflicts = conflicts.getStructureConflicts();
        if (!structureConflicts.isEmpty() && SystemProperties.getBooleanProperty((String)"enable.project.profiles", (boolean)false)) {
            ProjectProfileSelectionDialog dialog2 = new ProjectProfileSelectionDialog(this.myProject, structureConflicts);
            dialog2.show();
        }
        conflicts.showSelectionConflicts();
    }

    private void modifyJUnitRunConfigurations() {
        AndroidJUnitConfigurationType junitConfigurationType = AndroidJUnitConfigurationType.getInstance();
        Key makeTaskId = this.myIdeInfo.isAndroidStudio() ? MakeBeforeRunTaskProvider.ID : CompileStepBeforeRun.ID;
        BeforeRunTaskProvider targetProvider = null;
        for (BeforeRunTaskProvider provider2 : BeforeRunTaskProvider.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            if (!makeTaskId.equals((Object)provider2.getId())) continue;
            targetProvider = provider2;
            break;
        }
        if (targetProvider != null) {
            RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
            HashMap currentTasks = new HashMap();
            for (RunConfiguration runConfiguration : runManager.getConfigurationsList((ConfigurationType)junitConfigurationType)) {
                currentTasks.put(runConfiguration, new ArrayList(runManager.getBeforeRunTasks(runConfiguration)));
            }
            for (ConfigurationFactory configurationFactory : junitConfigurationType.getConfigurationFactories()) {
                RunnerAndConfigurationSettings template = runManager.getConfigurationTemplate(configurationFactory);
                AndroidJUnitConfiguration runConfiguration = (AndroidJUnitConfiguration)template.getConfiguration();
                this.setMakeStepInJUnitConfiguration(targetProvider, (RunConfiguration)runConfiguration);
                runConfiguration.setWorkingDirectory("$MODULE_DIR$");
            }
            for (RunConfiguration runConfiguration : runManager.getConfigurationsList((ConfigurationType)junitConfigurationType)) {
                runManager.setBeforeRunTasks(runConfiguration, (List)currentTasks.get(runConfiguration));
            }
        }
    }

    private void setMakeStepInJUnitConfiguration(@NotNull BeforeRunTaskProvider targetProvider, @NotNull RunConfiguration runConfiguration) {
        if (targetProvider == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(17);
        }
        if (runConfiguration == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(18);
        }
        LinkedList<BeforeRunTask> newBeforeRunTasks = new LinkedList<BeforeRunTask>();
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
        for (BeforeRunTask beforeRunTask : runManager.getBeforeRunTasks(runConfiguration)) {
            if (beforeRunTask.getProviderId().equals((Object)CompileStepBeforeRun.ID)) {
                BeforeRunTask task2;
                if (!runManager.getBeforeRunTasks(runConfiguration, MakeBeforeRunTaskProvider.ID).isEmpty() || (task2 = targetProvider.createTask(runConfiguration)) == null) continue;
                task2.setEnabled(true);
                newBeforeRunTasks.add(task2);
                continue;
            }
            newBeforeRunTasks.add(beforeRunTask);
        }
        runManager.setBeforeRunTasks(runConfiguration, newBeforeRunTasks);
    }

    @NotNull
    public static ExternalSystemTaskId createProjectSetupFromCacheTaskWithStartMessage(Project project) {
        ExternalSystemTaskId taskId = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project);
        String workingDir = FileUtil.toCanonicalPath((String)Projects.getBaseDirPath((Project)project).getPath());
        DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor((Object)taskId, "Project setup", workingDir, System.currentTimeMillis());
        SyncViewManager syncManager = (SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class);
        syncManager.onEvent((Object)taskId, (BuildEvent)new StartBuildEventImpl((BuildDescriptor)buildDescriptor, "reading from cache..."));
        ExternalSystemTaskId externalSystemTaskId = taskId;
        if (externalSystemTaskId == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(19);
        }
        return externalSystemTaskId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectStructure";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncInvoker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencySetupIssues";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSetup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSetup";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProvider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectSetupFromCacheTaskWithStartMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 19: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setUpProject";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMaxJavaLanguageLevel";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "finishFailedSync";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onCachedModelsSetupFailure";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notifySyncFinished";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setMakeStepInJUnitConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Request {
        public boolean usingCachedGradleModels;
        public long lastSyncTimestamp = -1L;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.usingCachedGradleModels == request.usingCachedGradleModels && this.lastSyncTimestamp == request.lastSyncTimestamp;
        }

        public int hashCode() {
            return Objects.hash(this.usingCachedGradleModels, this.lastSyncTimestamp);
        }
    }
}

