/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.idea.java;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupIssues;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.JavaModuleDependenciesSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModuleSetupStep
extends JavaModuleSetupStep {
    private static final DependencyScope DEFAULT_DEPENDENCY_SCOPE = DependencyScope.COMPILE;
    @NotNull
    private final JavaModuleDependenciesSetup myDependenciesSetup;

    public DependenciesModuleSetupStep() {
        this(new JavaModuleDependenciesSetup());
    }

    @VisibleForTesting
    DependenciesModuleSetupStep(@NotNull JavaModuleDependenciesSetup dependenciesSetup) {
        if (dependenciesSetup == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(0);
        }
        this.myDependenciesSetup = dependenciesSetup;
    }

    @Override
    protected void doSetUpModule(@NotNull ModuleSetupContext context, @NotNull JavaModuleModel javaModuleModel) {
        if (context == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(1);
        }
        if (javaModuleModel == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(2);
        }
        Module module = context.getModule();
        IdeModifiableModelsProvider ideModelsProvider = context.getIdeModelsProvider();
        ArrayList<String> unresolved = new ArrayList<String>();
        for (JavaModuleDependency javaModuleDependency : javaModuleModel.getJavaModuleDependencies()) {
            DependenciesModuleSetupStep.updateDependency(context, javaModuleDependency);
        }
        for (JarLibraryDependency jarLibraryDependency : javaModuleModel.getJarLibraryDependencies()) {
            if (jarLibraryDependency.isResolved()) {
                this.updateDependency(module, ideModelsProvider, jarLibraryDependency);
                continue;
            }
            unresolved.add(jarLibraryDependency.getName());
        }
        UnresolvedDependenciesReporter.getInstance().report(unresolved, module);
    }

    private static void updateDependency(@NotNull ModuleSetupContext context, @NotNull JavaModuleDependency dependency) {
        if (context == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(3);
        }
        if (dependency == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(4);
        }
        Module module = context.getModule();
        IdeModifiableModelsProvider modelsProvider = context.getIdeModelsProvider();
        DependencySetupIssues setupIssues = DependencySetupIssues.getInstance(module.getProject());
        String moduleName2 = dependency.getModuleName();
        ModuleFinder moduleFinder = context.getModuleFinder();
        assert (moduleFinder != null);
        Module found = moduleFinder.findModuleByModuleId(dependency.getModuleId());
        if (found == null) {
            found = modelsProvider.findIdeModule(moduleName2);
        }
        ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
        if (found != null) {
            if (DependenciesModuleSetupStep.isSelfDependencyByTest(dependency, module, found)) {
                return;
            }
            AndroidFacet androidFacet = (AndroidFacet)Facets.findFacet(found, modelsProvider, AndroidFacet.ID);
            if (androidFacet == null) {
                ModuleOrderEntry entry = moduleModel.addModuleOrderEntry(found);
                entry.setExported(DependenciesModuleSetupStep.getExported());
                entry.setScope(DependenciesModuleSetupStep.parseScope(dependency.getScope()));
            } else {
                setupIssues.addInvalidModuleDependency(moduleModel.getModule(), found.getName(), "Java modules cannot depend on Android modules");
            }
            return;
        }
        setupIssues.addMissingModule(moduleName2, module.getName());
    }

    static boolean isSelfDependencyByTest(@NotNull JavaModuleDependency dependency, @NotNull Module module, @Nullable Module dependencyModule) {
        if (dependency == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(5);
        }
        if (module == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(6);
        }
        return module.equals(dependencyModule) && StringUtil.compare((String)dependency.getScope(), (String)"TEST", (boolean)true) == 0;
    }

    private void updateDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull JarLibraryDependency dependency) {
        if (module == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(7);
        }
        if (modelsProvider == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(8);
        }
        if (dependency == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(9);
        }
        DependencyScope scope = DependenciesModuleSetupStep.parseScope(dependency.getScope());
        File binaryPath = dependency.getBinaryPath();
        if (binaryPath == null) {
            DependencySetupIssues setupIssues = DependencySetupIssues.getInstance(module.getProject());
            setupIssues.addMissingBinaryPath(module.getName());
            return;
        }
        String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)binaryPath.getPath());
        this.myDependenciesSetup.setUpLibraryDependency(module, modelsProvider, name, scope, binaryPath, dependency.getSourcePath(), dependency.getJavadocPath(), DependenciesModuleSetupStep.getExported());
    }

    @VisibleForTesting
    static boolean getExported() {
        return true;
    }

    @NotNull
    private static DependencyScope parseScope(@Nullable String scope) {
        if (scope == null) {
            DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
            if (dependencyScope == null) {
                DependenciesModuleSetupStep.$$$reportNull$$$0(10);
            }
            return dependencyScope;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scope.equalsIgnoreCase(dependencyScope.toString())) continue;
            DependencyScope dependencyScope2 = dependencyScope;
            if (dependencyScope2 == null) {
                DependenciesModuleSetupStep.$$$reportNull$$$0(11);
            }
            return dependencyScope2;
        }
        DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
        if (dependencyScope == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(12);
        }
        return dependencyScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesSetup";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModuleModel";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/idea/java/DependenciesModuleSetupStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/idea/java/DependenciesModuleSetupStep";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doSetUpModule";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateDependency";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSelfDependencyByTest";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

