/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkModuleSetupStep
extends AndroidModuleSetupStep {
    @NotNull
    private final AndroidSdks myAndroidSdks;

    public SdkModuleSetupStep() {
        this(AndroidSdks.getInstance());
    }

    @VisibleForTesting
    SdkModuleSetupStep(@NotNull AndroidSdks androidSdks) {
        if (androidSdks == null) {
            SdkModuleSetupStep.$$$reportNull$$$0(0);
        }
        this.myAndroidSdks = androidSdks;
    }

    @Override
    protected void doSetUpModule(@NotNull ModuleSetupContext context, @NotNull AndroidModuleModel androidModel) {
        IdeAndroidProject androidProject;
        String compileTarget;
        Sdk sdk;
        File androidSdkHomePath;
        if (context == null) {
            SdkModuleSetupStep.$$$reportNull$$$0(1);
        }
        if (androidModel == null) {
            SdkModuleSetupStep.$$$reportNull$$$0(2);
        }
        if ((androidSdkHomePath = IdeSdks.getInstance().getAndroidSdkPath()) == null) {
            assert (!IdeInfo.getInstance().isAndroidStudio());
            SdkModuleSetupStep.logAndroidSdkHomeNotFound();
            return;
        }
        ModifiableRootModel moduleModel = context.getModifiableRootModel();
        LanguageLevel languageLevel = androidModel.getJavaLanguageLevel();
        if (languageLevel != null) {
            ((LanguageLevelModuleExtensionImpl)moduleModel.getModuleExtension(LanguageLevelModuleExtensionImpl.class)).setLanguageLevel(languageLevel);
        }
        if ((sdk = this.myAndroidSdks.findSuitableAndroidSdk(compileTarget = (androidProject = androidModel.getAndroidProject()).getCompileTarget())) == null) {
            AndroidSdkHandler sdkHandler = this.myAndroidSdks.tryToChooseSdkHandler();
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(SdkModuleSetupStep.class);
            sdkHandler.getSdkManager((ProgressIndicator)progress).reloadLocalIfNeeded((ProgressIndicator)progress);
            Sdk[] finalSdk = new Sdk[1];
            ApplicationManager.getApplication().invokeAndWait(() -> {
                finalSdk[0] = (Sdk)ApplicationManager.getApplication().runWriteAction(() -> this.myAndroidSdks.tryToCreate(androidSdkHomePath, compileTarget));
            });
            sdk = finalSdk[0];
            if (sdk == null) {
                sdk = this.findMatchingSdkForAddon(androidProject);
            }
        }
        Module module = context.getModule();
        if (sdk == null) {
            SdkModuleSetupStep.showPlatformNotFoundError(module, compileTarget);
            return;
        }
        moduleModel.setSdk(sdk);
        String sdkPath = sdk.getHomePath();
        if (sdkPath == null) {
            sdkPath = "<path not set>";
        }
        SdkModuleSetupStep.getLog().info(String.format("Set Android SDK '%1$s' (%2$s) to module '%3$s'", sdk.getName(), sdkPath, module.getName()));
    }

    private static void logAndroidSdkHomeNotFound() {
        Logger log = SdkModuleSetupStep.getLog();
        log.warn("Path to Android SDK not set");
        List<Sdk> sdks = IdeSdks.getInstance().getEligibleAndroidSdks();
        log.warn("# of eligible SDKs: " + sdks.size());
        for (Sdk sdk : sdks) {
            log.info("sdk: " + sdk.toString());
        }
    }

    private static void showPlatformNotFoundError(@NotNull Module module, @NotNull String compileTarget) {
        if (module == null) {
            SdkModuleSetupStep.$$$reportNull$$$0(3);
        }
        if (compileTarget == null) {
            SdkModuleSetupStep.$$$reportNull$$$0(4);
        }
        String text = String.format("Module '%1$s': platform '%2$s' not found.", module.getName(), compileTarget);
        SdkModuleSetupStep.getLog().warn(text);
        SyncMessage msg = new SyncMessage("SDK Setup Issues", MessageType.ERROR, text);
        GradleSyncMessages.getInstance(module.getProject()).report(msg);
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(SdkModuleSetupStep.class);
        if (logger2 == null) {
            SdkModuleSetupStep.$$$reportNull$$$0(5);
        }
        return logger2;
    }

    @Nullable
    private Sdk findMatchingSdkForAddon(@NotNull IdeAndroidProject androidProject) {
        File androidJarPath;
        Collection bootClasspath;
        if (androidProject == null) {
            SdkModuleSetupStep.$$$reportNull$$$0(6);
        }
        if ((bootClasspath = androidProject.getBootClasspath()).size() > 1 && (androidJarPath = SdkModuleSetupStep.findAndroidJarFilePath(bootClasspath)) != null) {
            return this.findSdk(androidJarPath);
        }
        return null;
    }

    @Nullable
    private static File findAndroidJarFilePath(@NotNull Collection<String> bootClasspath) {
        if (bootClasspath == null) {
            SdkModuleSetupStep.$$$reportNull$$$0(7);
        }
        for (String entry : bootClasspath) {
            File file = new File(entry);
            if (!"android.jar".equals(file.getName())) continue;
            return file;
        }
        return null;
    }

    @Nullable
    private Sdk findSdk(@NotNull File androidJarPath) {
        if (androidJarPath == null) {
            SdkModuleSetupStep.$$$reportNull$$$0(8);
        }
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            if (!SdkModuleSetupStep.containsPath(sdk, androidJarPath)) continue;
            return sdk;
        }
        return null;
    }

    private static boolean containsPath(@NotNull Sdk sdk, @NotNull File path2) {
        if (sdk == null) {
            SdkModuleSetupStep.$$$reportNull$$$0(9);
        }
        if (path2 == null) {
            SdkModuleSetupStep.$$$reportNull$$$0(10);
        }
        for (VirtualFile sdkFile : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            File sdkFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)sdkFile);
            if (!FileUtil.filesEqual((File)sdkFilePath, (File)path2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileTarget";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/android/SdkModuleSetupStep";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootClasspath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidJarPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/android/SdkModuleSetupStep";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doSetUpModule";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showPlatformNotFoundError";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingSdkForAddon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findAndroidJarFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSdk";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

