/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.SourceProvider;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFacetModuleSetupStep
extends AndroidModuleSetupStep {
    private static final String SEPARATOR = "/";

    @Override
    protected void doSetUpModule(@NotNull ModuleSetupContext context, @NotNull AndroidModuleModel androidModel) {
        if (context == null) {
            AndroidFacetModuleSetupStep.$$$reportNull$$$0(0);
        }
        if (androidModel == null) {
            AndroidFacetModuleSetupStep.$$$reportNull$$$0(1);
        }
        Module module = context.getModule();
        IdeModifiableModelsProvider ideModelsProvider = context.getIdeModelsProvider();
        AndroidFacet facet2 = (AndroidFacet)ideModelsProvider.getModifiableFacetModel(module).getFacetByType(AndroidFacet.ID);
        if (facet2 == null) {
            facet2 = AndroidFacetModuleSetupStep.createAndAddFacet(module, ideModelsProvider);
        }
        AndroidFacetModuleSetupStep.configureFacet(facet2, androidModel);
    }

    @NotNull
    private static AndroidFacet createAndAddFacet(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
        if (module == null) {
            AndroidFacetModuleSetupStep.$$$reportNull$$$0(2);
        }
        if (ideModelsProvider == null) {
            AndroidFacetModuleSetupStep.$$$reportNull$$$0(3);
        }
        ModifiableFacetModel model2 = ideModelsProvider.getModifiableFacetModel(module);
        AndroidFacetType facetType = AndroidFacet.getFacetType();
        AndroidFacet facet2 = facetType.createFacet(module, "Android", facetType.createDefaultConfiguration(), null);
        model2.addFacet((Facet)facet2);
        AndroidFacet androidFacet = facet2;
        if (androidFacet == null) {
            AndroidFacetModuleSetupStep.$$$reportNull$$$0(4);
        }
        return androidFacet;
    }

    private static void configureFacet(@NotNull AndroidFacet facet2, @NotNull AndroidModuleModel androidModel) {
        if (facet2 == null) {
            AndroidFacetModuleSetupStep.$$$reportNull$$$0(5);
        }
        if (androidModel == null) {
            AndroidFacetModuleSetupStep.$$$reportNull$$$0(6);
        }
        AndroidFacetProperties facetProperties = facet2.getProperties();
        facetProperties.ALLOW_USER_CONFIGURATION = false;
        facetProperties.PROJECT_TYPE = androidModel.getAndroidProject().getProjectType();
        File modulePath = androidModel.getRootDirPath();
        SourceProvider sourceProvider = androidModel.getDefaultSourceProvider();
        facetProperties.MANIFEST_FILE_RELATIVE_PATH = AndroidFacetModuleSetupStep.relativePath(modulePath, sourceProvider.getManifestFile());
        facetProperties.RES_FOLDER_RELATIVE_PATH = AndroidFacetModuleSetupStep.relativePath(modulePath, sourceProvider.getResDirectories());
        facetProperties.ASSETS_FOLDER_RELATIVE_PATH = AndroidFacetModuleSetupStep.relativePath(modulePath, sourceProvider.getAssetsDirectories());
        facetProperties.RES_FOLDERS_RELATIVE_PATH = Stream.concat(androidModel.getActiveSourceProviders().stream().flatMap(provider2 -> provider2.getResDirectories().stream()), androidModel.getMainArtifact().getGeneratedResourceFolders().stream()).map(it -> VfsUtilCore.pathToUrl((String)it.getAbsolutePath())).collect(Collectors.joining(";"));
        IdeAndroidArtifact androidTestArtifact = androidModel.getArtifactForAndroidTest();
        facetProperties.TEST_RES_FOLDERS_RELATIVE_PATH = Stream.concat(androidModel.getTestSourceProviders().stream().flatMap(provider2 -> provider2.getResDirectories().stream()), androidTestArtifact != null ? androidTestArtifact.getGeneratedResourceFolders().stream() : Stream.empty()).map(it -> VfsUtilCore.pathToUrl((String)it.getAbsolutePath())).collect(Collectors.joining(";"));
        AndroidFacetModuleSetupStep.syncSelectedVariant(facetProperties, androidModel);
        AndroidModel.set(facet2, androidModel);
        androidModel.syncSelectedVariantAndTestArtifact(facet2);
    }

    private static void syncSelectedVariant(@NotNull AndroidFacetProperties facetProperties, @NotNull AndroidModuleModel androidModel) {
        String variantStoredInFacet;
        if (facetProperties == null) {
            AndroidFacetModuleSetupStep.$$$reportNull$$$0(7);
        }
        if (androidModel == null) {
            AndroidFacetModuleSetupStep.$$$reportNull$$$0(8);
        }
        if (StringUtil.isNotEmpty((String)(variantStoredInFacet = facetProperties.SELECTED_BUILD_VARIANT)) && androidModel.getVariantNames().contains(variantStoredInFacet)) {
            androidModel.setSelectedVariantName(variantStoredInFacet);
        }
    }

    @NotNull
    private static String relativePath(@NotNull File basePath, @NotNull Collection<File> dirs) {
        if (basePath == null) {
            AndroidFacetModuleSetupStep.$$$reportNull$$$0(9);
        }
        if (dirs == null) {
            AndroidFacetModuleSetupStep.$$$reportNull$$$0(10);
        }
        return AndroidFacetModuleSetupStep.relativePath(basePath, (File)ContainerUtil.getFirstItem(dirs));
    }

    @NotNull
    private static String relativePath(@NotNull File basePath, @Nullable File file) {
        if (basePath == null) {
            AndroidFacetModuleSetupStep.$$$reportNull$$$0(11);
        }
        String relativePath = null;
        if (file != null) {
            relativePath = FileUtilRt.getRelativePath((File)basePath, (File)file);
        }
        if (relativePath != null && !relativePath.startsWith(SEPARATOR)) {
            String string = SEPARATOR + FileUtilRt.toSystemIndependentName((String)relativePath);
            if (string == null) {
                AndroidFacetModuleSetupStep.$$$reportNull$$$0(12);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModelsProvider";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetProperties";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAddFacet";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doSetUpModule";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddFacet";
                break;
            }
            case 4: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureFacet";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "syncSelectedVariant";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "relativePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

