/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.precheck.AndroidStudioSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class JdkPreSyncCheck
extends AndroidStudioSyncCheck {
    JdkPreSyncCheck() {
    }

    @Override
    @NotNull
    PreSyncCheckResult doCheckCanSyncAndTryToFix(@NotNull Project project) {
        String errorMessage;
        if (project == null) {
            JdkPreSyncCheck.$$$reportNull$$$0(0);
        }
        if ((errorMessage = JdkPreSyncCheck.getErrorMessage(IdeSdks.getInstance().getJdk())) != null) {
            SyncMessage syncMessage = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, errorMessage);
            List<NotificationHyperlink> quickFixes = Jdks.getInstance().getWrongJdkQuickFixes(project);
            syncMessage.add(quickFixes);
            GradleSyncMessages.getInstance(project).report(syncMessage);
            PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.failure("Invalid Jdk");
            if (preSyncCheckResult == null) {
                JdkPreSyncCheck.$$$reportNull$$$0(1);
            }
            return preSyncCheckResult;
        }
        PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.SUCCESS;
        if (preSyncCheckResult == null) {
            JdkPreSyncCheck.$$$reportNull$$$0(2);
        }
        return preSyncCheckResult;
    }

    private static String getErrorMessage(Sdk jdk) {
        if (jdk == null) {
            return "Jdk location is not set.";
        }
        String jdkHomePath = jdk.getHomePath();
        if (jdkHomePath == null) {
            return "Could not find valid Jdk home from the selected Jdk location.";
        }
        String selectedJdkMsg = "Selected Jdk location is " + jdkHomePath + ".\n";
        JavaSdkVersion runningJdkVersion = IdeSdks.getInstance().getRunningVersionOrDefault();
        if (!((Boolean)StudioFlags.ALLOW_DIFFERENT_JDK_VERSION.get()).booleanValue() && !IdeSdks.isJdkSameVersion(new File(jdkHomePath), runningJdkVersion)) {
            return "The version of selected Jdk doesn't match the Jdk used by Studio. Please choose a valid Jdk " + runningJdkVersion.getDescription() + " directory.\n" + selectedJdkMsg;
        }
        if (!JdkUtil.checkForJdk((String)jdkHomePath)) {
            return "The Jdk installation is invalid.\n" + selectedJdkMsg;
        }
        if (!Jdks.isJdkRunnableOnPlatform(jdk)) {
            return "The selected Jdk could not run on current OS.\nIf you are using embedded Jdk, please make sure to download Android Studio bundle compatible\nwith the current OS. For example, for x86 systems please choose a 32 bits download option.\n" + selectedJdkMsg;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/precheck/JdkPreSyncCheck";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/precheck/JdkPreSyncCheck";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doCheckCanSyncAndTryToFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCheckCanSyncAndTryToFix";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

