/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporterUtils;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.ui.QuickFixNotificationListener;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleDeduplicatingSyncIssueReporter
extends BaseSyncIssuesReporter {
    @Override
    final void report(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile, @NotNull SyncIssueUsageReporter usageReporter) {
        if (syncIssue == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(1);
        }
        if (usageReporter == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(2);
        }
        this.reportAll((List<SyncIssue>)ImmutableList.of((Object)syncIssue), (Map<SyncIssue, Module>)ImmutableMap.of((Object)syncIssue, (Object)module), (Map<Module, VirtualFile>)(buildFile == null ? ImmutableMap.of() : ImmutableMap.of((Object)module, (Object)buildFile)), usageReporter);
    }

    @Override
    final void reportAll(@NotNull List<SyncIssue> syncIssues, @NotNull Map<SyncIssue, Module> moduleMap, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull SyncIssueUsageReporter usageReporter) {
        if (syncIssues == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(3);
        }
        if (moduleMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(4);
        }
        if (buildFileMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(5);
        }
        if (usageReporter == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(6);
        }
        LinkedHashMap<Object, List> groupedIssues = new LinkedHashMap<Object, List>();
        for (SyncIssue issue2 : syncIssues) {
            groupedIssues.computeIfAbsent(this.getDeduplicationKey(issue2), config -> new ArrayList()).add(issue2);
        }
        for (List entry : groupedIssues.values()) {
            SyncIssue issue3;
            Module module;
            if (entry.isEmpty() || (module = moduleMap.get(issue3 = (SyncIssue)entry.get(0))) == null) continue;
            List<Module> affectedModules = entry.stream().map(moduleMap::get).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Module::getName)).collect(Collectors.toList());
            boolean isError = entry.stream().anyMatch(i2 -> i2.getSeverity() == 2);
            this.createNotificationDataAndReport(module.getProject(), entry, affectedModules, buildFileMap, isError, usageReporter);
        }
    }

    private void createNotificationDataAndReport(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, boolean isError, @NotNull SyncIssueUsageReporter usageReporter) {
        MessageType type;
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(7);
        }
        if (syncIssues == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(8);
        }
        if (affectedModules == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(9);
        }
        if (buildFileMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(10);
        }
        if (usageReporter == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(11);
        }
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        MessageType messageType = type = isError ? MessageType.ERROR : MessageType.INFO;
        assert (!syncIssues.isEmpty());
        NotificationData notification = this.setupNotificationData(project, syncIssues, affectedModules, buildFileMap, type);
        StringBuilder builder2 = new StringBuilder();
        List<NotificationHyperlink> customLinks = this.getCustomLinks(project, syncIssues, affectedModules, buildFileMap);
        messages.updateNotification(notification, notification.getMessage(), customLinks);
        SyncIssueUsageReporterUtils.collect(usageReporter, syncIssues.get(0).getType(), customLinks);
        Object message2 = notification.getMessage().trim();
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.getOrLog((Project)project);
        if (projectBuildModel2 != null && this.shouldIncludeModuleLinks() && !affectedModules.isEmpty()) {
            builder2.append("\nAffected Modules: ");
            Iterator<Module> it = affectedModules.iterator();
            while (it.hasNext()) {
                Module m = it.next();
                if (m == null) continue;
                this.doCreateModuleLink(project, notification, builder2, m, projectBuildModel2, syncIssues, buildFileMap.get(m));
                if (!it.hasNext()) continue;
                builder2.append(", ");
            }
        }
        message2 = (String)message2 + builder2.toString();
        notification.setMessage((String)message2);
        messages.report(notification);
    }

    private void doCreateModuleLink(@NotNull Project project, @NotNull NotificationData notification, @NotNull StringBuilder builder2, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel2, @NotNull List<SyncIssue> syncIssues, @Nullable VirtualFile buildFile) {
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(12);
        }
        if (notification == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(13);
        }
        if (builder2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(14);
        }
        if (module == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(15);
        }
        if (projectBuildModel2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(16);
        }
        if (syncIssues == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(17);
        }
        if (buildFile == null) {
            builder2.append(module.getName());
        } else {
            OpenFileHyperlink link = this.createModuleLink(project, module, projectBuildModel2, syncIssues, buildFile);
            builder2.append(link.toHtml());
            notification.setListener(link.getUrl(), (NotificationListener)new QuickFixNotificationListener(project, link));
        }
    }

    @NotNull
    protected OpenFileHyperlink createModuleLink(@NotNull Project project, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel2, @NotNull List<SyncIssue> syncIssues, @NotNull VirtualFile buildFile) {
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(18);
        }
        if (module == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(19);
        }
        if (projectBuildModel2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(20);
        }
        if (syncIssues == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(21);
        }
        if (buildFile == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(22);
        }
        return new OpenFileHyperlink(buildFile.getPath(), module.getName(), -1, -1);
    }

    @NotNull
    protected abstract Object getDeduplicationKey(@NotNull SyncIssue var1);

    protected boolean shouldIncludeModuleLinks() {
        return true;
    }

    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(23);
        }
        if (syncIssues == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(24);
        }
        if (affectedModules == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(25);
        }
        if (buildFileMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(26);
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(27);
        }
        return immutableList;
    }

    @NotNull
    protected NotificationData setupNotificationData(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        VirtualFile file;
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(28);
        }
        if (syncIssues == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(29);
        }
        if (affectedModules == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(30);
        }
        if (buildFileMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(31);
        }
        if (type == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(32);
        }
        assert (!syncIssues.isEmpty());
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        PositionInFile position = null;
        if (affectedModules.size() == 1 && (file = buildFileMap.get(affectedModules.get(0))) != null) {
            position = new PositionInFile(file);
        }
        NotificationData data = messages.createNotification("Gradle Sync Issues", syncIssues.get(0).getMessage(), type.convertToCategory(), position);
        if (position != null) {
            data.setNavigatable((Navigatable)new OpenFileDescriptor(project, position.file, position.line, position.column));
        }
        NotificationData notificationData = data;
        if (notificationData == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(33);
        }
        return notificationData;
    }

    public static int getLineNumberForElement(@NotNull Project project, @Nullable PsiElement element) {
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(34);
        }
        return (Integer)ApplicationManager.getApplication().runReadAction(() -> {
            Document document;
            if (element != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile())) != null) {
                return document.getLineNumber(element.getTextOffset());
            }
            return -1;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssue";
                break;
            }
            case 1: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageReporter";
                break;
            }
            case 3: 
            case 8: 
            case 17: 
            case 21: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssues";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMap";
                break;
            }
            case 5: 
            case 10: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileMap";
                break;
            }
            case 7: 
            case 12: 
            case 18: 
            case 23: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedModules";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectBuildModel";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/SimpleDeduplicatingSyncIssueReporter";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/SimpleDeduplicatingSyncIssueReporter";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomLinks";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "setupNotificationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportAll";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationDataAndReport";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doCreateModuleLink";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createModuleLink";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCustomLinks";
                break;
            }
            case 27: 
            case 33: {
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setupNotificationData";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumberForElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

