/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeprecatedConfigurationReporter
extends SimpleDeduplicatingSyncIssueReporter {
    @Override
    int getSupportedIssueType() {
        return 29;
    }

    @Override
    @NotNull
    protected OpenFileHyperlink createModuleLink(@NotNull Project project, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel2, @NotNull List<SyncIssue> syncIssues, @NotNull VirtualFile buildFile) {
        if (project == null) {
            DeprecatedConfigurationReporter.$$$reportNull$$$0(0);
        }
        if (module == null) {
            DeprecatedConfigurationReporter.$$$reportNull$$$0(1);
        }
        if (projectBuildModel2 == null) {
            DeprecatedConfigurationReporter.$$$reportNull$$$0(2);
        }
        if (syncIssues == null) {
            DeprecatedConfigurationReporter.$$$reportNull$$$0(3);
        }
        if (buildFile == null) {
            DeprecatedConfigurationReporter.$$$reportNull$$$0(4);
        }
        assert (!syncIssues.isEmpty());
        String config = DeprecatedConfigurationReporter.extractConfigurationName(syncIssues.get(0));
        GradleBuildModel buildModel = projectBuildModel2.getModuleBuildModel(buildFile);
        DependencyModel dependencyModel = buildModel.dependencies().all().stream().filter(model2 -> model2.configurationName().equals(config)).findFirst().orElse(null);
        if (dependencyModel == null) {
            OpenFileHyperlink openFileHyperlink = super.createModuleLink(project, module, projectBuildModel2, syncIssues, buildFile);
            if (openFileHyperlink == null) {
                DeprecatedConfigurationReporter.$$$reportNull$$$0(5);
            }
            return openFileHyperlink;
        }
        int lineNumber = DeprecatedConfigurationReporter.getLineNumberForElement(project, dependencyModel.getPsiElement());
        return new OpenFileHyperlink(buildFile.getPath(), module.getName(), lineNumber, -1);
    }

    @Override
    @NotNull
    protected String getDeduplicationKey(@NotNull SyncIssue issue2) {
        String config;
        if (issue2 == null) {
            DeprecatedConfigurationReporter.$$$reportNull$$$0(6);
        }
        String string = (config = DeprecatedConfigurationReporter.extractConfigurationName(issue2)) != null ? config : issue2.toString();
        if (string == null) {
            DeprecatedConfigurationReporter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static String extractConfigurationName(@NotNull SyncIssue issue2) {
        String data;
        if (issue2 == null) {
            DeprecatedConfigurationReporter.$$$reportNull$$$0(8);
        }
        if ((data = issue2.getData()) == null) {
            return null;
        }
        String[] parts = data.split("::");
        if (parts.length < 1) {
            return null;
        }
        return parts[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectBuildModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssues";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/DeprecatedConfigurationReporter";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/DeprecatedConfigurationReporter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleLink";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeduplicationKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModuleLink";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDeduplicationKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractConfigurationName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

