/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.android.AndroidModuleCleanupStep;
import com.android.tools.idea.gradle.project.sync.setup.post.MemorySettingsPostSyncChecker;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.project.sync.setup.post.TimeBasedReminder;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidModuleValidator;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AndroidModuleModelDataService
extends ModuleModelDataService<AndroidModuleModel> {
    @NotNull
    private final ModuleSetupContext.Factory myModuleSetupContextFactory;
    @NotNull
    private final AndroidModuleSetup myModuleSetup;
    @NotNull
    private final AndroidModuleValidator.Factory myModuleValidatorFactory;
    @NotNull
    private final AndroidModuleCleanupStep myCleanupStep;

    public AndroidModuleModelDataService() {
        this(new ModuleSetupContext.Factory(), new AndroidModuleSetup(), new AndroidModuleValidator.Factory(), new AndroidModuleCleanupStep());
    }

    @VisibleForTesting
    AndroidModuleModelDataService(@NotNull ModuleSetupContext.Factory moduleSetupContextFactory, @NotNull AndroidModuleSetup moduleSetup, @NotNull AndroidModuleValidator.Factory moduleValidatorFactory, @NotNull AndroidModuleCleanupStep cleanupStep) {
        if (moduleSetupContextFactory == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(0);
        }
        if (moduleSetup == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(1);
        }
        if (moduleValidatorFactory == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(2);
        }
        if (cleanupStep == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(3);
        }
        this.myModuleSetupContextFactory = moduleSetupContextFactory;
        this.myModuleSetup = moduleSetup;
        this.myModuleValidatorFactory = moduleValidatorFactory;
        this.myCleanupStep = cleanupStep;
    }

    @NotNull
    public Key<AndroidModuleModel> getTargetDataKey() {
        Key<AndroidModuleModel> key = AndroidProjectKeys.ANDROID_MODEL;
        if (key == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(4);
        }
        return key;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<AndroidModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, AndroidModuleModel> modelsByModuleName) {
        if (toImport == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(5);
        }
        if (project == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(6);
        }
        if (modelsProvider == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(7);
        }
        if (modelsByModuleName == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(8);
        }
        AndroidModuleValidator moduleValidator = this.myModuleValidatorFactory.create(project);
        for (Module module : modelsProvider.getModules()) {
            AndroidModuleModel androidModel = modelsByModuleName.get(module.getName());
            this.setUpModule(module, moduleValidator, modelsProvider, androidModel);
        }
        if (!modelsByModuleName.isEmpty()) {
            moduleValidator.fixAndReportFoundIssues();
        }
    }

    private void setUpModule(@NotNull Module module, @NotNull AndroidModuleValidator moduleValidator, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable AndroidModuleModel androidModel) {
        if (module == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(9);
        }
        if (moduleValidator == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(10);
        }
        if (modelsProvider == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(11);
        }
        if (androidModel != null) {
            ModuleSetupContext context = this.myModuleSetupContextFactory.create(module, modelsProvider);
            this.myModuleSetup.setUpModule(context, androidModel);
            moduleValidator.validate(module, androidModel);
        } else {
            this.onModelNotFound(module, modelsProvider);
        }
    }

    @Override
    protected void onModelNotFound(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (module == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(12);
        }
        if (modelsProvider == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(13);
        }
        this.myCleanupStep.cleanUpModule(module, modelsProvider);
    }

    @TestOnly
    @NotNull
    public AndroidModuleSetup getModuleSetup() {
        AndroidModuleSetup androidModuleSetup = this.myModuleSetup;
        if (androidModuleSetup == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(14);
        }
        return androidModuleSetup;
    }

    public void onSuccessImport(@NotNull Collection<DataNode<AndroidModuleModel>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        if (imported == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(15);
        }
        if (project == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(16);
        }
        if (modelsProvider == null) {
            AndroidModuleModelDataService.$$$reportNull$$$0(17);
        }
        if (!imported.isEmpty()) {
            if (GradlePluginUpgrade.shouldRecommendPluginUpgrade(project)) {
                GradlePluginUpgrade.recommendPluginUpgrade(project);
            }
            MemorySettingsPostSyncChecker.checkSettings(project, new TimeBasedReminder(project, "memory.settings.postsync", TimeUnit.DAYS.toMillis(1L)));
        }
        new ProjectStructureUsageTracker(project).trackProjectStructure();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSetupContextFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSetup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleValidatorFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupStep";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/data/service/AndroidModuleModelDataService";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsByModuleName";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleValidator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imported";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/data/service/AndroidModuleModelDataService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSetup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 14: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setUpModule";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onModelNotFound";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "onSuccessImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

