/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectBuildFileChecksums;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.IdeaSyncPopulateProjectTask;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectSetUpTask
implements ExternalProjectRefreshCallback {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PostSyncProjectSetup.Request mySetupRequest;
    @Nullable
    private final GradleSyncListener mySyncListener;

    ProjectSetUpTask(@NotNull Project project, @NotNull PostSyncProjectSetup.Request setupRequest, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            ProjectSetUpTask.$$$reportNull$$$0(0);
        }
        if (setupRequest == null) {
            ProjectSetUpTask.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySetupRequest = setupRequest;
        this.mySyncListener = syncListener;
    }

    @WorkerThread
    public void onSuccess(@NotNull ExternalSystemTaskId taskId, @Nullable DataNode<ProjectData> projectInfo) {
        if (taskId == null) {
            ProjectSetUpTask.$$$reportNull$$$0(2);
        }
        assert (projectInfo != null);
        if (this.mySyncListener != null) {
            this.mySyncListener.setupStarted(this.myProject);
        }
        GradleSyncState.getInstance(this.myProject).setupStarted();
        boolean importedProject = GradleProjectInfo.getInstance(this.myProject).isImportedProject();
        this.doPopulateProject(projectInfo, taskId);
        Runnable runnable2 = () -> {
            boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
            if (!isTest && importedProject) {
                GradleProjects.open(this.myProject);
            }
            if (importedProject) {
                AndroidGradleProjectComponent projectComponent = AndroidGradleProjectComponent.getInstance(this.myProject);
                projectComponent.configureGradleProject();
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            TransactionGuard.submitTransaction((Disposable)this.myProject, (Runnable)runnable2);
        }
    }

    @WorkerThread
    private void doPopulateProject(@NotNull DataNode<ProjectData> projectInfo, @NotNull ExternalSystemTaskId taskId) {
        if (projectInfo == null) {
            ProjectSetUpTask.$$$reportNull$$$0(3);
        }
        if (taskId == null) {
            ProjectSetUpTask.$$$reportNull$$$0(4);
        }
        IdeaSyncPopulateProjectTask task2 = new IdeaSyncPopulateProjectTask(this.myProject);
        task2.populateProject(projectInfo, taskId, this.mySetupRequest, this.mySyncListener);
    }

    public void onFailure(@NotNull ExternalSystemTaskId externalTaskId, @NotNull String errorMessage, @Nullable String errorDetails) {
        if (externalTaskId == null) {
            ProjectSetUpTask.$$$reportNull$$$0(5);
        }
        if (errorMessage == null) {
            ProjectSetUpTask.$$$reportNull$$$0(6);
        }
        if (errorMessage.contains(ExternalSystemBundle.message((String)"error.resolve.already.running", (Object[])new Object[]{""}))) {
            return;
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (!this.myProject.isDisposed()) {
                ExternalSystemUtil.ensureToolWindowContentInitialized((Project)this.myProject, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
            }
        });
        String exceptionMessage = errorDetails == null || errorMessage.contains(errorDetails) ? errorMessage : errorMessage + "\n" + errorDetails;
        String messageWithGuide = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{exceptionMessage});
        ProjectBuildFileChecksums.removeFrom(this.myProject);
        GradleSyncState.getInstance(this.myProject).syncFailed(messageWithGuide, null, this.mySyncListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupRequest";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalTaskId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/ProjectSetUpTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onSuccess";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doPopulateProject";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onFailure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

