/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaSyncPopulateProjectTask {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PostSyncProjectSetup myProjectSetup;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final ProjectDataManager myDataManager;

    public IdeaSyncPopulateProjectTask(@NotNull Project project) {
        if (project == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(0);
        }
        this(project, PostSyncProjectSetup.getInstance(project), GradleSyncState.getInstance(project), ProjectDataManager.getInstance());
    }

    @VisibleForTesting
    IdeaSyncPopulateProjectTask(@NotNull Project project, @NotNull PostSyncProjectSetup projectSetup, @NotNull GradleSyncState syncState, @NotNull ProjectDataManager dataManager) {
        if (project == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(1);
        }
        if (projectSetup == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(2);
        }
        if (syncState == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(3);
        }
        if (dataManager == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myProjectSetup = projectSetup;
        this.mySyncState = syncState;
        this.myDataManager = dataManager;
    }

    @WorkerThread
    public void populateProject(@NotNull DataNode<ProjectData> projectInfo, @NotNull ExternalSystemTaskId taskId, @Nullable PostSyncProjectSetup.Request setupRequest, @Nullable GradleSyncListener syncListener) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(5);
        }
        if (taskId == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(6);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            GradleSyncMessages.getInstance(this.myProject).removeAllMessages();
        });
        try {
            this.myDataManager.importData(projectInfo, this.myProject, true);
            if (syncListener != null) {
                if (setupRequest != null && setupRequest.usingCachedGradleModels) {
                    syncListener.syncSkipped(this.myProject);
                } else {
                    syncListener.syncSucceeded(this.myProject);
                }
            }
            if (setupRequest != null) {
                PostSyncProjectSetup.getInstance(this.myProject).setUpProject(setupRequest, taskId, syncListener);
            }
        }
        catch (Throwable unexpected) {
            if (setupRequest != null && setupRequest.usingCachedGradleModels) {
                this.myProjectSetup.onCachedModelsSetupFailure(taskId, setupRequest);
                return;
            }
            this.mySyncState.syncFailed(unexpected.getMessage(), unexpected, syncListener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSetup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/IdeaSyncPopulateProjectTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "populateProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

