/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.ProjectBuildFileChecksums;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.PsdModuleModels;
import com.android.tools.idea.gradle.project.sync.idea.ProjectSetUpTask;
import com.android.tools.idea.gradle.project.sync.idea.data.DataNodeCaches;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;

public class GradleSyncExecutor {
    private static final boolean SYNC_WITH_CACHED_MODEL_ONLY = SystemProperties.getBooleanProperty((String)"studio.sync.with.cached.model.only", (boolean)false);
    @NotNull
    private final Project myProject;
    @NotNull
    public static final com.intellij.openapi.util.Key<GradleSyncListener> LISTENER_KEY = new com.intellij.openapi.util.Key("GradleSyncListener");
    @NotNull
    public static final com.intellij.openapi.util.Key<Boolean> SINGLE_VARIANT_KEY = new com.intellij.openapi.util.Key("android.singlevariant.enabled");

    public GradleSyncExecutor(@NotNull Project project) {
        if (project == null) {
            GradleSyncExecutor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @WorkerThread
    public void sync(@NotNull GradleSyncInvoker.Request request, @Nullable GradleSyncListener listener2) {
        DataNodeCaches dataNodeCaches;
        DataNode<ProjectData> cache;
        ProjectBuildFileChecksums buildFileChecksums;
        if (request == null) {
            GradleSyncExecutor.$$$reportNull$$$0(1);
        }
        if ((SYNC_WITH_CACHED_MODEL_ONLY || request.useCachedGradleModels) && (buildFileChecksums = ProjectBuildFileChecksums.findFor(this.myProject)) != null && buildFileChecksums.canUseCachedData() && (cache = (dataNodeCaches = DataNodeCaches.getInstance(this.myProject)).getCachedProjectData()) != null && !dataNodeCaches.isCacheMissingModels(cache) && !GradleSyncExecutor.areCachedFilesMissing(this.myProject)) {
            PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
            setupRequest.usingCachedGradleModels = true;
            setupRequest.lastSyncTimestamp = buildFileChecksums.getLastGradleSyncTimestamp();
            ExternalSystemTaskId taskId = PostSyncProjectSetup.createProjectSetupFromCacheTaskWithStartMessage(this.myProject);
            ProjectSetUpTask setUpTask = new ProjectSetUpTask(this.myProject, setupRequest, listener2);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                setUpTask.onSuccess(taskId, cache);
            } else {
                ApplicationManager.getApplication().executeOnPooledThread(() -> setUpTask.onSuccess(taskId, cache));
            }
            return;
        }
        PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
        setupRequest.usingCachedGradleModels = false;
        boolean shouldUseSingleVariantSync = !request.forceFullVariantsSync && GradleSyncState.isSingleVariantSync();
        this.setProjectUserDataForAndroidGradleProjectResolver(shouldUseSingleVariantSync, listener2);
        Set androidProjectCandidatesPaths = GradleSettings.getInstance((Project)this.myProject).getLinkedProjectsSettings().stream().map(ExternalProjectSettings::getExternalProjectPath).collect(Collectors.toSet());
        if (androidProjectCandidatesPaths.isEmpty() && (IdeInfo.getInstance().isAndroidStudio() || ApplicationManager.getApplication().isUnitTestMode())) {
            String foundPath = GradleSyncExecutor.attemptToLinkGradleProject(this.myProject);
            if (foundPath != null) {
                androidProjectCandidatesPaths.add(foundPath);
            } else {
                GradleSyncState.getInstance(this.myProject).syncSkipped(System.currentTimeMillis(), listener2);
                return;
            }
        }
        for (String rootPath : androidProjectCandidatesPaths) {
            ProjectSetUpTask setUpTask = new ProjectSetUpTask(this.myProject, setupRequest, listener2);
            ProgressExecutionMode executionMode = request.getProgressExecutionMode();
            ExternalSystemUtil.refreshProject((String)rootPath, (ImportSpecBuilder)new ImportSpecBuilder(this.myProject, GradleUtil.GRADLE_SYSTEM_ID).callback((ExternalProjectRefreshCallback)setUpTask).use(executionMode));
        }
    }

    @Nullable
    public static String attemptToLinkGradleProject(@NotNull Project project) {
        String projectBasePath;
        if (project == null) {
            GradleSyncExecutor.$$$reportNull$$$0(2);
        }
        if ((projectBasePath = project.getBasePath()) == null) {
            return null;
        }
        String externalProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)projectBasePath);
        VirtualFile projectRootFolder = project.getBaseDir();
        projectRootFolder.refresh(false, true);
        if (!GradleProjectImportUtil.canOpenGradleProject((VirtualFile)projectRootFolder)) {
            return null;
        }
        GradleProjectSettings projectSettings = new GradleProjectSettings();
        GradleVersion gradleVersion2 = projectSettings.resolveGradleVersion();
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        GradleProjectImportUtil.setupGradleSettings((GradleSettings)settings);
        GradleProjectImportUtil.setupGradleProjectSettings((GradleProjectSettings)projectSettings, (Path)Paths.get(externalProjectPath, new String[0]));
        GradleJvmResolutionUtil.setupGradleJvm((Project)project, (GradleProjectSettings)projectSettings, (GradleVersion)gradleVersion2);
        GradleSettings.getInstance((Project)project).setStoreProjectFilesExternally(false);
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)projectSettings);
        return externalProjectPath;
    }

    private void setProjectUserDataForAndroidGradleProjectResolver(boolean singleVariant, @Nullable GradleSyncListener listener2) {
        this.myProject.putUserData(SINGLE_VARIANT_KEY, (Object)singleVariant);
        this.myProject.putUserData(LISTENER_KEY, (Object)listener2);
    }

    @NotNull
    public List<GradleModuleModels> fetchGradleModels() {
        GradleExecutionSettings settings = GradleUtil.getGradleExecutionSettings(this.myProject);
        ExternalSystemTaskId id = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        String projectPath = this.myProject.getBasePath();
        assert (projectPath != null);
        this.setProjectUserDataForAndroidGradleProjectResolver(false, null);
        GradleProjectResolver projectResolver = new GradleProjectResolver();
        DataNode projectDataNode = projectResolver.resolveProjectInfo(id, projectPath, false, (ExternalSystemExecutionSettings)settings, ExternalSystemTaskNotificationListenerAdapter.NULL_OBJECT);
        ImmutableList.Builder builder2 = ImmutableList.builder();
        if (projectDataNode != null) {
            Collection moduleNodes = ExternalSystemApiUtil.findAll((DataNode)projectDataNode, (Key)ProjectKeys.MODULE);
            for (DataNode moduleNode : moduleNodes) {
                DataNode gradleModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.GRADLE_MODULE_MODEL);
                if (gradleModelNode == null) continue;
                PsdModuleModels moduleModules = new PsdModuleModels(((ModuleData)moduleNode.getData()).getExternalName());
                moduleModules.addModel(GradleModuleModel.class, (GradleModuleModel)gradleModelNode.getData());
                DataNode androidModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.ANDROID_MODEL);
                if (androidModelNode != null) {
                    moduleModules.addModel(AndroidModuleModel.class, (AndroidModuleModel)androidModelNode.getData());
                    DataNode ndkModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.NDK_MODEL);
                    if (ndkModelNode != null) {
                        moduleModules.addModel(NdkModuleModel.class, (NdkModuleModel)ndkModelNode.getData());
                    }
                    builder2.add((Object)moduleModules);
                    continue;
                }
                DataNode javaModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.JAVA_MODULE_MODEL);
                if (javaModelNode == null) continue;
                moduleModules.addModel(JavaModuleModel.class, (JavaModuleModel)javaModelNode.getData());
                builder2.add((Object)moduleModules);
            }
        }
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            GradleSyncExecutor.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    private static boolean areCachedFilesMissing(@NotNull Project project) {
        if (project == null) {
            GradleSyncExecutor.$$$reportNull$$$0(4);
        }
        Ref missingFileFound = Ref.create((Object)false);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            rootManager.orderEntries().withoutModuleSourceEntries().withoutDepModules().forEach(entry -> {
                for (OrderRootType type : OrderRootType.getAllTypes()) {
                    List<String> expectedUrls = Arrays.asList(entry.getUrls(type));
                    if (expectedUrls.isEmpty()) continue;
                    if (type.equals((Object)OrderRootType.CLASSES)) {
                        if (!expectedUrls.stream().noneMatch(url -> VirtualFileManager.getInstance().findFileByUrl(url) != null)) continue;
                        missingFileFound.set((Object)true);
                        return false;
                    }
                    if (!expectedUrls.stream().anyMatch(url -> VirtualFileManager.getInstance().findFileByUrl(url) == null)) continue;
                    missingFileFound.set((Object)true);
                    return false;
                }
                return true;
            });
            if (!((Boolean)missingFileFound.get()).booleanValue()) continue;
            return true;
        }
        return (Boolean)missingFileFound.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/GradleSyncExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/GradleSyncExecutor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchGradleModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sync";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attemptToLinkGradleProject";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "areCachedFilesMissing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

