/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.util.PropertiesFiles;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public final class RemoveSHA256FromGradleWrapperHyperlink
extends NotificationHyperlink {
    public RemoveSHA256FromGradleWrapperHyperlink() {
        super("remove.SHA256.from.gradle.wrapper", "Remove distributionSha256Sum and sync project");
    }

    @Override
    protected void execute(@NotNull Project project) {
        GradleWrapper gradleWrapper;
        if (project == null) {
            RemoveSHA256FromGradleWrapperHyperlink.$$$reportNull$$$0(0);
        }
        if ((gradleWrapper = GradleWrapper.find(project)) != null) {
            File propertiesFilePath = gradleWrapper.getPropertiesFilePath();
            try {
                Properties properties = gradleWrapper.getProperties();
                if (properties.getProperty("distributionSha256Sum") != null) {
                    properties.remove("distributionSha256Sum");
                    PropertiesFiles.savePropertiesToFile(properties, propertiesFilePath, null);
                    LocalFileSystem.getInstance().refreshIoFiles(Collections.singletonList(propertiesFilePath));
                }
            }
            catch (IOException e) {
                Logger.getInstance(this.getClass()).warn("Failed to read file " + propertiesFilePath.getPath());
            }
        }
        GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_QF_DISTRIBUTIONSHA256SUM_REMOVED_FROM_WRAPPER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/RemoveSHA256FromGradleWrapperHyperlink", "execute"));
    }
}

