/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.gradle.util.PersistentSHA256Checksums;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfirmSHA256FromGradleWrapperHyperlink
extends NotificationHyperlink {
    @NotNull
    String myDistributionUrl;
    @NotNull
    String myDistributionSHA256;

    private ConfirmSHA256FromGradleWrapperHyperlink(@NotNull String distribution, @NotNull String checksum) {
        if (distribution == null) {
            ConfirmSHA256FromGradleWrapperHyperlink.$$$reportNull$$$0(0);
        }
        if (checksum == null) {
            ConfirmSHA256FromGradleWrapperHyperlink.$$$reportNull$$$0(1);
        }
        super("confirm.SHA256.from.gradle.wrapper", ConfirmSHA256FromGradleWrapperHyperlink.generateMessage(distribution, checksum));
        this.myDistributionUrl = distribution;
        this.myDistributionSHA256 = checksum;
    }

    private static String generateMessage(@NotNull String distribution, @NotNull String checksum) {
        if (distribution == null) {
            ConfirmSHA256FromGradleWrapperHyperlink.$$$reportNull$$$0(2);
        }
        if (checksum == null) {
            ConfirmSHA256FromGradleWrapperHyperlink.$$$reportNull$$$0(3);
        }
        String shortSHA = checksum.length() <= 9 ? checksum : checksum.substring(0, 6) + "...";
        return "Use \"" + shortSHA + "\" as checksum for " + distribution + " and sync project";
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            ConfirmSHA256FromGradleWrapperHyperlink.$$$reportNull$$$0(4);
        }
        PersistentSHA256Checksums.getInstance().storeChecksum(this.myDistributionUrl, this.myDistributionSHA256);
        GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_QF_DISTRIBUTIONSHA256SUM_CONFIRMED_BY_USER);
    }

    public static ConfirmSHA256FromGradleWrapperHyperlink create(@NotNull GradleWrapper wrapper) {
        if (wrapper == null) {
            ConfirmSHA256FromGradleWrapperHyperlink.$$$reportNull$$$0(5);
        }
        try {
            return ConfirmSHA256FromGradleWrapperHyperlink.create(wrapper.getDistributionUrl(), wrapper.getDistributionSha256Sum());
        }
        catch (IOException e) {
            return null;
        }
    }

    @VisibleForTesting
    public static ConfirmSHA256FromGradleWrapperHyperlink create(@Nullable String distribution, @Nullable String checksum) {
        if (StringUtil.isEmptyOrSpaces((String)distribution) || StringUtil.isEmptyOrSpaces((String)checksum)) {
            return null;
        }
        return new ConfirmSHA256FromGradleWrapperHyperlink(distribution, checksum);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checksum";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/ConfirmSHA256FromGradleWrapperHyperlink";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generateMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

