/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixBuildToolsVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallBuildToolsHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;

public class SdkBuildToolsTooLowErrorHandler
extends SyncErrorHandler {
    private static final Pattern SDK_BUILD_TOOLS_TOO_LOW_PATTERN = Pattern.compile("The SDK Build Tools revision \\((.*)\\) is too low for project '(.*)'. Minimum required is (.*)");

    @NotNull
    public static SdkBuildToolsTooLowErrorHandler getInstance() {
        for (SyncErrorHandler errorHandler : SyncErrorHandler.getExtensions()) {
            if (!(errorHandler instanceof SdkBuildToolsTooLowErrorHandler)) continue;
            SdkBuildToolsTooLowErrorHandler sdkBuildToolsTooLowErrorHandler = (SdkBuildToolsTooLowErrorHandler)errorHandler;
            if (sdkBuildToolsTooLowErrorHandler == null) {
                SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(0);
            }
            return sdkBuildToolsTooLowErrorHandler;
        }
        throw new IllegalStateException("Unable to find an instance of " + SdkBuildToolsTooLowErrorHandler.class.getName());
    }

    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String text;
        List<NotificationHyperlink> hyperlinks;
        if (error == null) {
            SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(1);
        }
        if (notification == null) {
            SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(2);
        }
        if (project == null) {
            SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(3);
        }
        if (!(hyperlinks = this.getQuickFixHyperlinks(project, text = this.getRootCause(error).getMessage())).isEmpty()) {
            SdkBuildToolsTooLowErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.SDK_BUILD_TOOLS_TOO_LOW);
            GradleSyncMessages.getInstance(project).updateNotification(notification, text, hyperlinks);
            return true;
        }
        return false;
    }

    @NotNull
    private List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        Matcher matcher;
        if (project == null) {
            SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(4);
        }
        if (text == null) {
            SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(5);
        }
        if ((matcher = SDK_BUILD_TOOLS_TOO_LOW_PATTERN.matcher(SdkBuildToolsTooLowErrorHandler.getFirstLineMessage(text))).matches()) {
            String gradlePath = matcher.group(2);
            Module module = GradleUtil.findModuleByGradlePath(project, gradlePath);
            String minimumVersion = matcher.group(3);
            VirtualFile file = module == null ? null : GradleUtil.getGradleBuildFile(module);
            ImmutableMap buildFileMap = module != null && file != null ? ImmutableMap.of((Object)module, (Object)file) : ImmutableMap.of();
            List<NotificationHyperlink> links = this.getQuickFixHyperlinks(minimumVersion, (List<Module>)(file == null ? ImmutableList.of() : ImmutableList.of((Object)module)), (Map<Module, VirtualFile>)buildFileMap);
            if (file != null) {
                links.add(new OpenFileHyperlink(file.getPath()));
            }
            List<NotificationHyperlink> list = links;
            if (list == null) {
                SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<NotificationHyperlink> list = Collections.emptyList();
        if (list == null) {
            SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static boolean doesAndroidGradlePluginPackageBuildTools(@NotNull List<Module> modules) {
        if (modules == null) {
            SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(8);
        }
        for (Module module : modules) {
            GradleVersion agpVersion;
            AndroidPluginInfo pluginInfo;
            if (AndroidFacet.getInstance((Module)module) == null || (pluginInfo = AndroidPluginInfo.find(module.getProject())) == null || (agpVersion = pluginInfo.getPluginVersion()) == null || agpVersion.isAtLeast(3, 0, 0)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull String minimumVersion, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        if (minimumVersion == null) {
            SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(9);
        }
        if (affectedModules == null) {
            SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(10);
        }
        if (buildFileMap == null) {
            SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(11);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        boolean buildToolInstalled = false;
        AndroidSdkHandler sdkHandler = null;
        AndroidSdkData androidSdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (androidSdkData != null) {
            sdkHandler = androidSdkData.getSdkHandler();
        }
        if (sdkHandler != null) {
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(SdkBuildToolsTooLowErrorHandler.class);
            RepositoryPackages packages = sdkHandler.getSdkManager((ProgressIndicator)progress).getPackages();
            LocalPackage buildTool = (LocalPackage)packages.getLocalPackages().get(DetailsTypes.getBuildToolsPath((Revision)Revision.parseRevision((String)minimumVersion)));
            buildToolInstalled = buildTool != null;
        }
        List<VirtualFile> buildFiles = affectedModules.stream().map(m -> (VirtualFile)buildFileMap.get(m)).filter(Objects::nonNull).collect(Collectors.toList());
        if (!buildToolInstalled) {
            hyperlinks.add(new InstallBuildToolsHyperlink(minimumVersion, buildFiles, SdkBuildToolsTooLowErrorHandler.doesAndroidGradlePluginPackageBuildTools(affectedModules)));
        } else if (!buildFiles.isEmpty()) {
            hyperlinks.add(new FixBuildToolsVersionHyperlink(minimumVersion, buildFiles, SdkBuildToolsTooLowErrorHandler.doesAndroidGradlePluginPackageBuildTools(affectedModules)));
        }
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            SdkBuildToolsTooLowErrorHandler.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimumVersion";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedModules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleError";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doesAndroidGradlePluginPackageBuildTools";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

