/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NdkToolchainMissingABIHandler
extends BaseSyncErrorHandler {
    @NotNull
    private static final String ERROR_MESSAGE = "No toolchains found in the NDK toolchains folder for ABI with prefix: ";
    @NotNull
    private static final List<String> VALID_ABIS = Arrays.asList("mips64el-linux-android", "mipsel-linux-android");

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        boolean valid;
        String text;
        if (rootCause == null) {
            NdkToolchainMissingABIHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            NdkToolchainMissingABIHandler.$$$reportNull$$$0(1);
        }
        if ((text = rootCause.getMessage()).startsWith(ERROR_MESSAGE) && (valid = VALID_ABIS.stream().anyMatch(it -> text.endsWith((String)it))) && !NdkToolchainMissingABIHandler.isArtifactVersionOver3dot0(NdkToolchainMissingABIHandler.getAndroidPluginArtifactModel(project))) {
            return text + "\nThis version of the NDK may be incompatible with the Android Gradle plugin version 3.0 or older.\nPlease use plugin version 3.1 or newer.";
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            NdkToolchainMissingABIHandler.$$$reportNull$$$0(2);
        }
        if (text == null) {
            NdkToolchainMissingABIHandler.$$$reportNull$$$0(3);
        }
        if (!NdkToolchainMissingABIHandler.isArtifactVersionOver3dot0(NdkToolchainMissingABIHandler.getAndroidPluginArtifactModel(project)) && !GradleUtil.hasKtsBuildFiles(project)) {
            List<NotificationHyperlink> list = Collections.singletonList(new FixAndroidGradlePluginVersionHyperlink());
            if (list == null) {
                NdkToolchainMissingABIHandler.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<NotificationHyperlink> list = super.getQuickFixHyperlinks(project, text);
        if (list == null) {
            NdkToolchainMissingABIHandler.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static boolean isArtifactVersionOver3dot0(@Nullable ArtifactDependencyModel artifactModel) {
        if (artifactModel == null) {
            return false;
        }
        String version2 = artifactModel.version().toString();
        if (version2 == null) {
            return false;
        }
        return NdkToolchainMissingABIHandler.isVersionOver3dot0(version2);
    }

    @VisibleForTesting
    static boolean isVersionOver3dot0(@NotNull String version2) {
        GradleCoordinate versionOnly;
        if (version2 == null) {
            NdkToolchainMissingABIHandler.$$$reportNull$$$0(6);
        }
        return (versionOnly = GradleCoordinate.parseVersionOnly((String)version2)).getMajorVersion() > 3 || versionOnly.getMajorVersion() == 3 && versionOnly.getMinorVersion() > 0;
    }

    @Nullable
    private static ArtifactDependencyModel getAndroidPluginArtifactModel(@NotNull Project project) {
        ProjectBuildModel projectBuildModel2;
        if (project == null) {
            NdkToolchainMissingABIHandler.$$$reportNull$$$0(7);
        }
        if ((projectBuildModel2 = ProjectBuildModel.getOrLog((Project)project)) == null) {
            return null;
        }
        GradleBuildModel rootModel = projectBuildModel2.getProjectBuildModel();
        if (rootModel != null) {
            List dependencyModels = rootModel.buildscript().dependencies().artifacts();
            return dependencyModels.stream().filter(dependency -> NdkToolchainMissingABIHandler.isAndroidPlugin(dependency)).findFirst().orElse(null);
        }
        return null;
    }

    private static boolean isAndroidPlugin(@NotNull ArtifactDependencyModel artifactModel) {
        if (artifactModel == null) {
            NdkToolchainMissingABIHandler.$$$reportNull$$$0(8);
        }
        String group2 = artifactModel.group().toString();
        String name = artifactModel.name().toString();
        return group2 != null && name != null && group2.equals("com.android.tools.build") && name.equals("gradle");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/NdkToolchainMissingABIHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/NdkToolchainMissingABIHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findErrorMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isVersionOver3dot0";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidPluginArtifactModel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

