/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.tools.idea.gradle.project.sync.errors.MissingNdkIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallNdkHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.processor.FixNdkVersionProcessor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingNdkIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "appendQuickFix", "", "quickFixes", "", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "quickFix", "message", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "errorMessage", "matchesKnownLocatorIssue", "", "matchesNdkNotConfigured", "matchesTriedInstall", "FixNdkVersionQuickFix", "InstallNdkQuickFix", "intellij.android.core"})
public final class MissingNdkIssueChecker
implements GradleIssueChecker {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        void description;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        String string = this.errorMessage(issueData);
        if (string == null) {
            return null;
        }
        String message2 = string;
        Revision preferredVersion = MissingNdkIssueCheckerKt.tryExtractPreferredNdkDownloadVersion(message2);
        boolean bl = false;
        List quickFixes = new ArrayList();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = message2 + '\n';
        IdeSdks ideSdks = IdeSdks.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"IdeSdks.getInstance()");
        IdeSdks ideSdks2 = ideSdks;
        String localRevision = null;
        if (preferredVersion != null) {
            LocalPackage localPackage = ideSdks2.getSpecificLocalPackage("ndk;" + preferredVersion);
            localRevision = localPackage != null && (localPackage = localPackage.getVersion()) != null ? localPackage.toString() : null;
        } else if (this.matchesNdkNotConfigured(message2) || this.matchesKnownLocatorIssue(message2) || this.matchesTriedInstall(message2)) {
            LocalPackage localPackage;
            LocalPackage localPackage2 = ideSdks2.getHighestLocalNdkPackage(false);
            if (localPackage2 == null) {
                localPackage2 = localPackage = ideSdks2.getHighestLocalNdkPackage(true);
            }
            localRevision = localPackage2 != null && (localPackage = localPackage.getVersion()) != null ? localPackage.toString() : null;
        } else {
            return null;
        }
        if (localRevision != null) {
            description.element = (String)description.element + this.appendQuickFix(quickFixes, new FixNdkVersionQuickFix(localRevision), "Update NDK version to " + localRevision + " and sync project");
        } else {
            Revision revision = preferredVersion;
            description.element = (String)description.element + this.appendQuickFix(quickFixes, new InstallNdkQuickFix(revision != null ? revision.toString() : null), preferredVersion != null ? "Install NDK '" + preferredVersion + "' and sync project" : "Install latest NDK and sync project");
        }
        return new BuildIssue((Ref.ObjectRef)description, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ Ref.ObjectRef $description;
            final /* synthetic */ List $quickFixes;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
            {
                this.$description = $captured_local_variable$0;
                this.$quickFixes = $captured_local_variable$1;
                this.title = "NDK not configured.";
                this.description = (String)$captured_local_variable$0.element;
                this.quickFixes = $captured_local_variable$1;
            }
        };
    }

    private final String appendQuickFix(List<BuildIssueQuickFix> quickFixes, BuildIssueQuickFix quickFix, String message2) {
        Collection collection2 = quickFixes;
        boolean bl = false;
        collection2.add(quickFix);
        return "\n<a href=\"" + quickFix.getId() + "\">" + message2 + "</a>";
    }

    private final String errorMessage(GradleIssueData issueData) {
        Pair pair = GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError());
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"GradleExecutionErrorHand\u2026Location(issueData.error)");
        Pair rootCauseAndLocation = pair;
        Throwable throwable = (Throwable)rootCauseAndLocation.first;
        if (throwable == null) {
            return null;
        }
        Throwable rootCause = throwable;
        return rootCause.getMessage();
    }

    private final boolean matchesNdkNotConfigured(String errorMessage) {
        return StringsKt.startsWith$default((String)errorMessage, (String)"NDK not configured.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)errorMessage, (String)"NDK location not found.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)errorMessage, (String)"Requested NDK version", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)errorMessage, (String)"No version of NDK matched the requested version", (boolean)false, (int)2, null);
    }

    private final boolean matchesKnownLocatorIssue(String errorMessage) {
        return StringsKt.startsWith$default((String)errorMessage, (String)"Specified android.ndkVersion", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"does not have enough precision", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)errorMessage, (String)"Location specified by ndk.dir", (boolean)false, (int)2, null);
    }

    private final boolean matchesTriedInstall(String errorMessage) {
        return (StringsKt.startsWith$default((String)errorMessage, (String)"Failed to install the following Android SDK packages as some licences have not been accepted.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)errorMessage, (String)"Failed to install the following SDK components:", (boolean)false, (int)2, null)) && StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"NDK", (boolean)false, (int)2, null);
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return GradleIssueChecker.DefaultImpls.consumeBuildOutputFailureMessage((GradleIssueChecker)this, (String)message2, (String)failureCause, (String)stacktrace, (FilePosition)location, (Object)parentEventId, messageConsumer);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingNdkIssueChecker$FixNdkVersionQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "version", "", "(Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "getVersion", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "intellij.android.core"})
    public static final class FixNdkVersionQuickFix
    implements BuildIssueQuickFix {
        @NotNull
        private final String id;
        @NotNull
        private final String version;

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataProvider dataProvider) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
            CompletableFuture future2 = new CompletableFuture();
            ApplicationManager.getApplication().invokeLater(new Runnable(this, project, future2){
                final /* synthetic */ FixNdkVersionQuickFix this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ CompletableFuture $future;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    try {
                        void $this$mapNotNullTo$iv$iv;
                        LocalProperties localProperties = new LocalProperties(this.$project);
                        localProperties.setAndroidNdkPath((File)null);
                        localProperties.save();
                        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.$project);
                        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                        Module[] moduleArray = moduleManager.getModules();
                        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                        Module[] $this$mapNotNull$iv = moduleArray;
                        boolean $i$f$mapNotNull = false;
                        Module[] moduleArray2 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        void var10_10 = $this$forEach$iv$iv$iv;
                        int n = ((void)var10_10).length;
                        for (int j = 0; j < n; ++j) {
                            VirtualFile virtualFile;
                            void element$iv$iv$iv;
                            void element$iv$iv = element$iv$iv$iv = var10_10[j];
                            boolean bl = false;
                            void it = element$iv$iv;
                            boolean bl2 = false;
                            if (GradleUtil.getGradleBuildFile((Module)it) == null) continue;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            VirtualFile it$iv$iv = virtualFile;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List buildFiles = (List)destination$iv$iv;
                        FixNdkVersionProcessor processor = new FixNdkVersionProcessor(this.$project, buildFiles, this.this$0.getVersion());
                        processor.run();
                        this.$future.complete(null);
                    }
                    catch (Exception e) {
                        this.$future.completeExceptionally(e);
                    }
                }
                {
                    this.this$0 = fixNdkVersionQuickFix;
                    this.$project = project;
                    this.$future = completableFuture;
                }
            });
            return future2;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        public FixNdkVersionQuickFix(@NotNull String version2) {
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            this.version = version2;
            this.id = "fix.ndk.version.quickfix";
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingNdkIssueChecker$InstallNdkQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "preferredVersion", "", "(Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "intellij.android.core"})
    public static final class InstallNdkQuickFix
    implements BuildIssueQuickFix {
        private final String preferredVersion;

        @NotNull
        public String getId() {
            return "install.ndk.quickfix";
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataProvider dataProvider) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
            CompletableFuture future2 = new CompletableFuture();
            ApplicationManager.getApplication().invokeLater(new Runnable(this, project, future2){
                final /* synthetic */ InstallNdkQuickFix this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ CompletableFuture $future;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    try {
                        void $this$mapNotNullTo$iv$iv;
                        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.$project);
                        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                        Module[] moduleArray = moduleManager.getModules();
                        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                        Module[] $this$mapNotNull$iv = moduleArray;
                        boolean $i$f$mapNotNull = false;
                        Module[] moduleArray2 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        void var9_8 = $this$forEach$iv$iv$iv;
                        int n = ((void)var9_8).length;
                        for (int j = 0; j < n; ++j) {
                            VirtualFile virtualFile;
                            void element$iv$iv$iv;
                            void element$iv$iv = element$iv$iv$iv = var9_8[j];
                            boolean bl = false;
                            void it = element$iv$iv;
                            boolean bl2 = false;
                            if (GradleUtil.getGradleBuildFile((Module)it) == null) continue;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            VirtualFile it$iv$iv = virtualFile;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List buildFiles = (List)destination$iv$iv;
                        new InstallNdkHyperlink(InstallNdkQuickFix.access$getPreferredVersion$p(this.this$0), buildFiles).execute(this.$project);
                        this.$future.complete(null);
                    }
                    catch (Exception e) {
                        this.$future.completeExceptionally(e);
                    }
                }
                {
                    this.this$0 = installNdkQuickFix;
                    this.$project = project;
                    this.$future = completableFuture;
                }
            });
            return future2;
        }

        public InstallNdkQuickFix(@Nullable String preferredVersion) {
            this.preferredVersion = preferredVersion;
        }

        public static final /* synthetic */ String access$getPreferredVersion$p(InstallNdkQuickFix $this) {
            return $this.preferredVersion;
        }
    }
}

