/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallCMakeHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.SetCmakeDirHyperlink;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingCMakeErrorHandler
extends BaseSyncErrorHandler {
    private static final String FORK_CMAKE_SDK_VERSION = "3.6.4111459";
    private static final String FORK_CMAKE_REPORTED_VERSION = "3.6.0";
    private static final Revision ourForkCmakeSdkVersion = Revision.parseRevision((String)"3.6.4111459");
    private static final Revision ourForkCmakeReportedVersion = Revision.parseRevision((String)"3.6.0");

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String message2;
        if (rootCause == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)(message2 = rootCause.getMessage()))) {
            String firstLine = MissingCMakeErrorHandler.getFirstLineMessage(message2);
            if (firstLine.startsWith("Failed to find CMake.") || firstLine.startsWith("Unable to get the CMake version")) {
                MissingCMakeErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.MISSING_CMAKE);
                return "Failed to find CMake.";
            }
            if (MissingCMakeErrorHandler.matchesCannotFindCmake(firstLine) || MissingCMakeErrorHandler.matchesTriedInstall(message2) || MissingCMakeErrorHandler.matchesCmakeWithVersion(message2)) {
                MissingCMakeErrorHandler.updateUsageTracker(project, null);
                return message2;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        String firstLine;
        String version2;
        if (project == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(2);
        }
        if (text == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(3);
        }
        if ((version2 = MissingCMakeErrorHandler.extractCmakeVersionFromError(firstLine = MissingCMakeErrorHandler.getFirstLineMessage(text))) != null) {
            RevisionOrHigher requestedCmake = MissingCMakeErrorHandler.parseRevisionOrHigher(version2, firstLine);
            if (requestedCmake == null) {
                List<NotificationHyperlink> list = Collections.emptyList();
                if (list == null) {
                    MissingCMakeErrorHandler.$$$reportNull$$$0(4);
                }
                return list;
            }
            RepoManager sdkManager = this.getSdkManager();
            Collection remoteCmakePackages = sdkManager.getPackages().getRemotePackagesForPrefix("cmake");
            Revision foundCmakeVersion = MissingCMakeErrorHandler.findBestMatch(remoteCmakePackages, requestedCmake);
            if (foundCmakeVersion == null) {
                List<NotificationHyperlink> list = Collections.emptyList();
                if (list == null) {
                    MissingCMakeErrorHandler.$$$reportNull$$$0(5);
                }
                return list;
            }
            Collection localCmakePackages = sdkManager.getPackages().getLocalPackagesForPrefix("cmake");
            File alreadyInstalledCmake = MissingCMakeErrorHandler.getAlreadyInstalled(localCmakePackages, foundCmakeVersion);
            if (alreadyInstalledCmake != null) {
                block19: {
                    File cmakeDir;
                    block18: {
                        List<NotificationHyperlink> list;
                        try {
                            cmakeDir = this.getLocalPropertiesCMakeDir(project);
                            if (cmakeDir != null) break block18;
                            list = Collections.singletonList(new SetCmakeDirHyperlink(alreadyInstalledCmake, String.format("Set cmake.dir in local.properties to %s", alreadyInstalledCmake)));
                        }
                        catch (IOException e) {
                            List<NotificationHyperlink> list2 = Collections.emptyList();
                            if (list2 == null) {
                                MissingCMakeErrorHandler.$$$reportNull$$$0(9);
                            }
                            return list2;
                        }
                        if (list == null) {
                            MissingCMakeErrorHandler.$$$reportNull$$$0(6);
                        }
                        return list;
                    }
                    if (cmakeDir.getPath() != alreadyInstalledCmake.getPath()) break block19;
                    List<NotificationHyperlink> list = Collections.emptyList();
                    if (list == null) {
                        MissingCMakeErrorHandler.$$$reportNull$$$0(7);
                    }
                    return list;
                }
                List<NotificationHyperlink> list = Collections.singletonList(new SetCmakeDirHyperlink(alreadyInstalledCmake, String.format("Replace cmake.dir in local.properties with %s", alreadyInstalledCmake)));
                if (list == null) {
                    MissingCMakeErrorHandler.$$$reportNull$$$0(8);
                }
                return list;
            }
            List<NotificationHyperlink> list = Collections.singletonList(new InstallCMakeHyperlink(foundCmakeVersion));
            if (list == null) {
                MissingCMakeErrorHandler.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<NotificationHyperlink> list = Collections.singletonList(new InstallCMakeHyperlink());
        if (list == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static boolean matchesCmakeWithVersion(@NotNull String firstLine) {
        if (firstLine == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(12);
        }
        return firstLine.startsWith("Unable to find CMake with version:");
    }

    private static boolean matchesCannotFindCmake(@NotNull String firstLine) {
        if (firstLine == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(13);
        }
        return firstLine.startsWith("CMake") && firstLine.contains("was not found in PATH or by cmake.dir property");
    }

    private static boolean matchesTriedInstall(@NotNull String errorMessage) {
        if (errorMessage == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(14);
        }
        return !(!errorMessage.startsWith("Failed to install the following Android SDK packages as some licences have not been accepted.") && !errorMessage.startsWith("Failed to install the following SDK components:") || !errorMessage.contains("CMake") && !errorMessage.contains("cmake"));
    }

    @Nullable
    @VisibleForTesting
    static String extractCmakeVersionFromError(@NotNull String firstLine) {
        String revision;
        if (firstLine == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(15);
        }
        if ((revision = MissingCMakeErrorHandler.extractCmakeVersionFromErrorInTicks(firstLine)) != null) {
            return revision;
        }
        return MissingCMakeErrorHandler.extractCmakeVersionFromErrorInVersionWithin(firstLine);
    }

    @Nullable
    @VisibleForTesting
    static RevisionOrHigher parseRevisionOrHigher(String version2, String firstLine) {
        try {
            return new RevisionOrHigher(Revision.parseRevision((String)version2), firstLine.contains("'" + version2 + "' or higher"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    private static String extractCmakeVersionFromErrorInTicks(@NotNull String firstLine) {
        int startPos;
        if (firstLine == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(16);
        }
        if ((startPos = firstLine.indexOf(39)) == -1) {
            return null;
        }
        int endPos = firstLine.indexOf(39, startPos + 1);
        if (endPos == -1) {
            return null;
        }
        return firstLine.substring(startPos + 1, endPos);
    }

    @Nullable
    private static String extractCmakeVersionFromErrorInVersionWithin(@NotNull String firstLine) {
        int startPos;
        if (firstLine == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(17);
        }
        if ((startPos = firstLine.indexOf("version: ")) == -1) {
            return null;
        }
        int endPos = firstLine.indexOf(" within", startPos + 1);
        if (endPos == -1) {
            return null;
        }
        return firstLine.substring(startPos + 9, endPos);
    }

    @Nullable
    @VisibleForTesting
    static Revision findBestMatch(@NotNull Collection<RemotePackage> cmakePackages, @NotNull RevisionOrHigher requestedCmake) {
        if (cmakePackages == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(18);
        }
        if (requestedCmake == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(19);
        }
        Revision foundVersion = null;
        for (RemotePackage remotePackage : cmakePackages) {
            Revision remoteCmake = remotePackage.getVersion();
            if (remoteCmake.equals((Object)ourForkCmakeSdkVersion)) {
                remoteCmake = ourForkCmakeReportedVersion;
            }
            if (!MissingCMakeErrorHandler.versionSatisfies(remoteCmake, requestedCmake)) continue;
            if (foundVersion == null) {
                foundVersion = remoteCmake;
                continue;
            }
            if (remoteCmake.compareTo(foundVersion, Revision.PreviewComparison.IGNORE) <= 0) continue;
            foundVersion = remoteCmake;
        }
        return foundVersion;
    }

    @VisibleForTesting
    static boolean versionSatisfies(@NotNull Revision candidateCmake, @NotNull RevisionOrHigher requestedCmake) {
        int result2;
        if (candidateCmake == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(20);
        }
        if (requestedCmake == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(21);
        }
        return (result2 = candidateCmake.compareTo(requestedCmake.revision, Revision.PreviewComparison.IGNORE)) == 0 || requestedCmake.orHigher && result2 >= 0;
    }

    @Nullable
    private static File getAlreadyInstalled(@NotNull Collection<LocalPackage> cmakePackages, @NotNull Revision cmakeVersion) {
        if (cmakePackages == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(22);
        }
        if (cmakeVersion == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(23);
        }
        for (LocalPackage localCmakePackage : cmakePackages) {
            if (!localCmakePackage.getVersion().equals((Object)cmakeVersion)) continue;
            return localCmakePackage.getLocation();
        }
        return null;
    }

    @NotNull
    protected RepoManager getSdkManager() {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager repoManager = sdkHandler.getSdkManager((ProgressIndicator)progressIndicator);
        if (repoManager == null) {
            MissingCMakeErrorHandler.$$$reportNull$$$0(24);
        }
        return repoManager;
    }

    @Nullable
    protected File getLocalPropertiesCMakeDir(Project project) throws IOException {
        return new LocalProperties(project).getAndroidCmakePath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/MissingCMakeErrorHandler";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstLine";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakePackages";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedCmake";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateCmake";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/MissingCMakeErrorHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findErrorMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 24: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matchesCmakeWithVersion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchesCannotFindCmake";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchesTriedInstall";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractCmakeVersionFromError";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractCmakeVersionFromErrorInTicks";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractCmakeVersionFromErrorInVersionWithin";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findBestMatch";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "versionSatisfies";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAlreadyInstalled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RevisionOrHigher {
        @NotNull
        public final Revision revision;
        public final boolean orHigher;

        public RevisionOrHigher(@NotNull Revision revision, boolean orHigher) {
            if (revision == null) {
                RevisionOrHigher.$$$reportNull$$$0(0);
            }
            this.revision = revision;
            this.orHigher = orHigher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/android/tools/idea/gradle/project/sync/errors/MissingCMakeErrorHandler$RevisionOrHigher", "<init>"));
        }
    }
}

