/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.io.Closeables;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MissingAndroidSdkErrorHandler
extends BaseSyncErrorHandler {
    private static final String FIX_SDK_DIR_PROPERTY = "Please fix the 'sdk.dir' property in the local.properties file.";
    private static final String SDK_DIR_PROPERTY_MISSING = "No sdk.dir property defined in local.properties file.";
    private static final Pattern SDK_NOT_FOUND_PATTERN = Pattern.compile("The SDK directory '(.*?)' does not exist.");

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        if (rootCause == null) {
            MissingAndroidSdkErrorHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MissingAndroidSdkErrorHandler.$$$reportNull$$$0(1);
        }
        Object text = rootCause.getMessage();
        if (rootCause instanceof RuntimeException && StringUtil.isNotEmpty((String)text) && (((String)text).equals(SDK_DIR_PROPERTY_MISSING) || SDK_NOT_FOUND_PATTERN.matcher((CharSequence)text).matches())) {
            MissingAndroidSdkErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.SDK_NOT_FOUND);
            File buildProperties = new File(Projects.getBaseDirPath((Project)project), "local.properties");
            if (buildProperties.isFile()) {
                text = (String)text + "\n\nPlease fix the 'sdk.dir' property in the local.properties file.";
                return text;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        int lineNumber;
        File file;
        block16: {
            String line;
            if (project == null) {
                MissingAndroidSdkErrorHandler.$$$reportNull$$$0(2);
            }
            if (text == null) {
                MissingAndroidSdkErrorHandler.$$$reportNull$$$0(3);
            }
            file = new File(Projects.getBaseDirPath((Project)project), "local.properties");
            lineNumber = 0;
            BufferedReader reader = null;
            reader = new BufferedReader(new FileReader(file));
            int counter2333333332 = 0;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("sdk.dir")) {
                    lineNumber = counter2333333332;
                    break;
                }
                ++counter2333333332;
            }
            try {
                Closeables.close((Closeable)reader, (boolean)true);
            }
            catch (IOException counter2333333332) {}
            break block16;
            catch (IOException e222222222) {
                try {
                    Logger.getInstance(this.getClass()).info("Unable to read file: " + file.getPath(), (Throwable)e222222222);
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close(reader, (boolean)true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException e222222222) {}
            }
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        if (file.exists()) {
            hyperlinks.add(new OpenFileHyperlink(file.getPath(), lineNumber));
        }
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            MissingAndroidSdkErrorHandler.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSdkErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSdkErrorHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findErrorMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

