/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.AddGoogleMavenRepositoryHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenPluginBuildFileHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingAndroidPluginErrorHandler
extends BaseSyncErrorHandler {
    private static final String PATTERN = "Could not find com.android.tools.build:gradle:";

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text;
        if (rootCause == null) {
            MissingAndroidPluginErrorHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MissingAndroidPluginErrorHandler.$$$reportNull$$$0(1);
        }
        if ((text = rootCause.getMessage()).startsWith(PATTERN)) {
            return text;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            MissingAndroidPluginErrorHandler.$$$reportNull$$$0(2);
        }
        if (text == null) {
            MissingAndroidPluginErrorHandler.$$$reportNull$$$0(3);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        if (project.isInitialized()) {
            List<VirtualFile> buildFiles = AddGoogleMavenRepositoryHyperlink.getBuildFileForPlugin(project);
            if (!buildFiles.isEmpty() && buildFiles.get(0) != null) {
                GradleBuildModel gradleBuildModel;
                ProjectBuildModel projectBuildModel2;
                VirtualFile buildFile = buildFiles.get(0);
                if (!GradleUtil.isKtsFile(buildFile) && (projectBuildModel2 = ProjectBuildModel.getOrLog((Project)project)) != null && !(gradleBuildModel = projectBuildModel2.getModuleBuildModel(buildFile)).buildscript().repositories().hasGoogleMavenRepository()) {
                    hyperlinks.add(new AddGoogleMavenRepositoryHyperlink((List<VirtualFile>)ImmutableList.of((Object)buildFile)));
                }
                hyperlinks.add(new OpenFileHyperlink(FileUtil.toSystemDependentName((String)buildFile.getPath())));
            }
        } else {
            hyperlinks.add(new AddGoogleMavenRepositoryHyperlink(project));
            hyperlinks.add(new OpenPluginBuildFileHyperlink());
        }
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            MissingAndroidPluginErrorHandler.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidPluginErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidPluginErrorHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findErrorMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

