/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.common;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.actions.RefreshLinkedCppProjectsAction;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.common.GradleInitScripts;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.SyncProjectWithExtraCommandLineOptionsHyperlink;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.ui.GuiTestingService;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineArgs {
    private static Key<String[]> GRADLE_SYNC_COMMAND_LINE_OPTIONS_KEY = Key.create((String)"gradle.sync.command.line.options");
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final GradleInitScripts myInitScripts;

    public CommandLineArgs() {
        this(IdeInfo.getInstance(), GradleInitScripts.getInstance());
    }

    @VisibleForTesting
    CommandLineArgs(@NotNull IdeInfo ideInfo, @NotNull GradleInitScripts initScripts) {
        if (ideInfo == null) {
            CommandLineArgs.$$$reportNull$$$0(0);
        }
        if (initScripts == null) {
            CommandLineArgs.$$$reportNull$$$0(1);
        }
        this.myIdeInfo = ideInfo;
        this.myInitScripts = initScripts;
    }

    @NotNull
    public List<String> get(@Nullable Project project) {
        Boolean refreshExternalNativeModels;
        String[] extraOptions;
        ArrayList<String> args = new ArrayList<String>();
        this.myInitScripts.addAndroidStudioToolingPluginInitScriptCommandLineArg(args);
        args.add("-Djava.awt.headless=true");
        if (project != null && (extraOptions = (String[])project.getUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY)) != null) {
            project.putUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY, null);
            Collections.addAll(args, extraOptions);
        }
        args.add("--stacktrace");
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only.advanced", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only.versioned", (int)(GradleSyncState.isLevel4Model() ? 4 : 3)));
        IdeaPluginDescriptor androidSupport = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"org.jetbrains.android"));
        if (androidSupport != null && !CommandLineArgs.isDevBuild(androidSupport.getVersion())) {
            args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.studio.version", (String)androidSupport.getVersion()));
        }
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.disable.src.download", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"idea.gradle.do.not.build.tasks", (boolean)GradleExperimentalSettings.getInstance().SKIP_GRADLE_TASKS_LIST));
        if (this.myIdeInfo.isAndroidStudio()) {
            args.add(AndroidGradleSettings.createJvmArg((String)"org.gradle.internal.GradleProjectBuilderOptions", (String)"omit_all_tasks"));
        }
        if (project != null && (refreshExternalNativeModels = (Boolean)project.getUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY)) != null) {
            project.putUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY, null);
            args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.refresh.external.native.model", (boolean)refreshExternalNativeModels));
        }
        Application application = ApplicationManager.getApplication();
        boolean isTestingMode = CommandLineArgs.isInTestingMode();
        if (isTestingMode) {
            application.putUserData(GRADLE_SYNC_COMMAND_LINE_OPTIONS_KEY, (Object)ArrayUtil.toStringArray(args));
        }
        if (((Boolean)StudioFlags.USE_DEVELOPMENT_OFFLINE_REPOS.get()).booleanValue() || isTestingMode) {
            this.myInitScripts.addLocalMavenRepoInitScriptCommandLineArg(args);
        }
        ArrayList<String> arrayList = args;
        if (arrayList == null) {
            CommandLineArgs.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static boolean isDevBuild(String version2) {
        return version2.equals("dev build");
    }

    public static boolean isInTestingMode() {
        GuiTestingService guiTestingService = GuiTestingService.getInstance();
        return guiTestingService != null && guiTestingService.isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScripts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/common/CommandLineArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/common/CommandLineArgs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

