/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.cleanup;

import com.android.tools.idea.gradle.project.ProxySettingsDialog;
import com.android.tools.idea.gradle.project.sync.cleanup.AndroidStudioCleanUpTask;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.ProxySettings;
import com.android.tools.idea.project.AndroidNotification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

class HttpProxySettingsCleanUpTask
extends AndroidStudioCleanUpTask {
    HttpProxySettingsCleanUpTask() {
    }

    @Override
    void doCleanUp(@NotNull Project project) {
        GradleProperties properties;
        boolean usingProxy;
        if (project == null) {
            HttpProxySettingsCleanUpTask.$$$reportNull$$$0(0);
        }
        HttpConfigurable ideHttpProxySettings = HttpConfigurable.getInstance();
        boolean bl = usingProxy = ideHttpProxySettings.USE_HTTP_PROXY && StringUtil.isNotEmpty((String)ideHttpProxySettings.PROXY_HOST) || ideHttpProxySettings.USE_PROXY_PAC;
        if (!usingProxy) {
            return;
        }
        try {
            properties = new GradleProperties(GradleProperties.getUserGradlePropertiesFile());
        }
        catch (IOException e) {
            this.getLogger().info("Failed to read gradle.properties file", (Throwable)e);
            return;
        }
        ProxySettings gradleProxySettings = properties.getHttpProxySettings();
        ProxySettingsDialog dialog2 = null;
        if (ideHttpProxySettings.USE_PROXY_PAC) {
            if (StringUtil.isEmpty((String)gradleProxySettings.getHost()) || !properties.getProperties().containsKey("systemProp.http.proxyPort")) {
                dialog2 = new ProxySettingsDialog(project, gradleProxySettings);
            }
        } else {
            ProxySettings ideProxySettings = new ProxySettings(ideHttpProxySettings);
            if (!ideProxySettings.equals(gradleProxySettings)) {
                dialog2 = new ProxySettingsDialog(project, ideProxySettings);
            }
        }
        if (dialog2 != null && dialog2.showAndGet()) {
            boolean needsPassword = dialog2.applyProxySettings(properties.getProperties());
            try {
                properties.save();
                if (needsPassword) {
                    String msg = "Proxy passwords are not defined.";
                    OpenFileHyperlink openLink = new OpenFileHyperlink(GradleProperties.getUserGradlePropertiesFile().getPath());
                    AndroidNotification.getInstance(project).showBalloon("Proxy Settings", msg, NotificationType.WARNING, openLink);
                }
            }
            catch (IOException e) {
                Throwable root2 = ExceptionUtil.getRootCause((Throwable)e);
                Object cause = root2.getMessage();
                Object errMsg = "Failed to save HTTP proxy settings to gradle.properties file.";
                if (StringUtil.isNotEmpty((String)cause)) {
                    if (!((String)cause).endsWith(".")) {
                        cause = (String)cause + ".";
                    }
                    errMsg = (String)errMsg + String.format("\nCause: %1$s", cause);
                }
                AndroidNotification notification = AndroidNotification.getInstance(project);
                notification.showBalloon("Proxy Settings", (String)errMsg, NotificationType.ERROR);
                this.getLogger().info("Failed to save changes to gradle.properties file", root2);
            }
        }
    }

    @NotNull
    private Logger getLogger() {
        Logger logger2 = Logger.getInstance(this.getClass());
        if (logger2 == null) {
            HttpProxySettingsCleanUpTask.$$$reportNull$$$0(1);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/cleanup/HttpProxySettingsCleanUpTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/cleanup/HttpProxySettingsCleanUpTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCleanUp";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

