/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.common;

import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import com.android.ide.gradle.model.GradlePluginModel;
import com.android.ide.gradle.model.builder.AndroidStudioToolingPlugin;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.serviceContainer.NonInjectable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleInitScripts {
    @NotNull
    private final EmbeddedDistributionPaths myEmbeddedDistributionPaths;
    @NotNull
    private final ContentCreator myContentCreator;

    @NotNull
    public static GradleInitScripts getInstance() {
        GradleInitScripts gradleInitScripts = (GradleInitScripts)ApplicationManager.getApplication().getService(GradleInitScripts.class);
        if (gradleInitScripts == null) {
            GradleInitScripts.$$$reportNull$$$0(0);
        }
        return gradleInitScripts;
    }

    public GradleInitScripts() {
        this(EmbeddedDistributionPaths.getInstance(), new ContentCreator());
    }

    @NonInjectable
    @VisibleForTesting
    GradleInitScripts(@NotNull EmbeddedDistributionPaths embeddedDistributionPaths, @NotNull ContentCreator contentCreator) {
        if (embeddedDistributionPaths == null) {
            GradleInitScripts.$$$reportNull$$$0(1);
        }
        if (contentCreator == null) {
            GradleInitScripts.$$$reportNull$$$0(2);
        }
        this.myEmbeddedDistributionPaths = embeddedDistributionPaths;
        this.myContentCreator = contentCreator;
    }

    public void addLocalMavenRepoInitScriptCommandLineArg(@NotNull List<String> allArgs) {
        File initScriptFile;
        if (allArgs == null) {
            GradleInitScripts.$$$reportNull$$$0(3);
        }
        if ((initScriptFile = this.createLocalMavenRepoInitScriptFile()) != null) {
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
    }

    @Nullable
    private File createLocalMavenRepoInitScriptFile() {
        String content2;
        List repoPaths = this.myEmbeddedDistributionPaths.findAndroidStudioLocalMavenRepoPaths().stream().map(File::getPath).collect(Collectors.toCollection(ArrayList::new));
        if (!"https://maven.google.com/".equals(GoogleMavenRepositoryKt.GMAVEN_BASE_URL)) {
            repoPaths.add(GoogleMavenRepositoryKt.GMAVEN_BASE_URL);
        }
        if ((content2 = this.myContentCreator.createLocalMavenRepoInitScriptContent(repoPaths)) != null) {
            String fileName = "sync.local.repo";
            try {
                return GradleInitScripts.createInitScriptFile(fileName, content2);
            }
            catch (Throwable e) {
                String message2 = String.format("Failed to set up Gradle init script: '%1$s'", fileName);
                GradleInitScripts.getLogger().warn(message2, e);
            }
        }
        return null;
    }

    public void addAndroidStudioToolingPluginInitScriptCommandLineArg(@NotNull List<String> allArgs) {
        if (allArgs == null) {
            GradleInitScripts.$$$reportNull$$$0(4);
        }
        try {
            File initScriptFile = this.createAndroidStudioToolingPluginInitScriptFile();
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
        catch (IOException e) {
            GradleInitScripts.getLogger().warn("Failed to create init script that applies the Android Studio Tooling plugin.", (Throwable)e);
        }
    }

    @NotNull
    private File createAndroidStudioToolingPluginInitScriptFile() throws IOException {
        String content2 = this.myContentCreator.createAndroidStudioToolingPluginInitScriptContent();
        return GradleInitScripts.createInitScriptFile("sync.studio.tooling", content2);
    }

    @NotNull
    private static File createInitScriptFile(@NotNull String fileName, @NotNull String content2) throws IOException {
        if (fileName == null) {
            GradleInitScripts.$$$reportNull$$$0(5);
        }
        if (content2 == null) {
            GradleInitScripts.$$$reportNull$$$0(6);
        }
        File file = FileUtil.createTempFile((String)fileName, (String)".gradle");
        file.deleteOnExit();
        FileUtil.writeToFile((File)file, (String)content2);
        GradleInitScripts.getLogger().info(String.format("init script file %s contents %s", fileName, GradleInitScripts.escapeAsStringLiteral(content2)));
        File file2 = file;
        if (file2 == null) {
            GradleInitScripts.$$$reportNull$$$0(7);
        }
        return file2;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger2 = Logger.getInstance(GradleInitScripts.class);
        if (logger2 == null) {
            GradleInitScripts.$$$reportNull$$$0(8);
        }
        return logger2;
    }

    @NotNull
    private static String escapeAsStringLiteral(@NotNull String s) {
        if (s == null) {
            GradleInitScripts.$$$reportNull$$$0(9);
        }
        Escaper escaper = Escapers.builder().addEscape('\b', "\\b").addEscape('\t', "\\t").addEscape('\n', "\\n").addEscape('\f', "\\f").addEscape('\r', "\\r").addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();
        String string = "\"" + escaper.escape(s) + "\"";
        if (string == null) {
            GradleInitScripts.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static void addInitScriptCommandLineArg(@NotNull File initScriptFile, @NotNull List<String> allArgs) {
        if (initScriptFile == null) {
            GradleInitScripts.$$$reportNull$$$0(11);
        }
        if (allArgs == null) {
            GradleInitScripts.$$$reportNull$$$0(12);
        }
        allArgs.add("--init-script");
        allArgs.add(initScriptFile.getAbsolutePath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/common/GradleInitScripts";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedDistributionPaths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentCreator";
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allArgs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScriptFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/common/GradleInitScripts";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitScriptFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeAsStringLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addLocalMavenRepoInitScriptCommandLineArg";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidStudioToolingPluginInitScriptCommandLineArg";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInitScriptFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "escapeAsStringLiteral";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addInitScriptCommandLineArg";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class AndroidStudioToolingPluginJars {
        AndroidStudioToolingPluginJars() {
        }

        @NotNull
        List<String> getJarPaths() {
            List<String> list = Arrays.asList(PathManager.getJarPathForClass(GradlePluginModel.class), PathManager.getJarPathForClass(AndroidStudioToolingPlugin.class), PathManager.getJarPathForClass(KType.class));
            if (list == null) {
                AndroidStudioToolingPluginJars.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/common/GradleInitScripts$AndroidStudioToolingPluginJars", "getJarPaths"));
        }
    }

    @VisibleForTesting
    static class ContentCreator {
        @NotNull
        private final AndroidStudioToolingPluginJars myAndroidStudioToolingPluginJars;

        ContentCreator() {
            this(new AndroidStudioToolingPluginJars());
        }

        ContentCreator(@NotNull AndroidStudioToolingPluginJars androidStudioToolingPluginJars) {
            if (androidStudioToolingPluginJars == null) {
                ContentCreator.$$$reportNull$$$0(0);
            }
            this.myAndroidStudioToolingPluginJars = androidStudioToolingPluginJars;
        }

        @Nullable
        String createLocalMavenRepoInitScriptContent(@NotNull List<String> repoPaths) {
            if (repoPaths == null) {
                ContentCreator.$$$reportNull$$$0(1);
            }
            if (repoPaths.isEmpty()) {
                return null;
            }
            StringBuilder paths = new StringBuilder();
            for (String path2 : repoPaths) {
                path2 = GradleImport.escapeGroovyStringLiteral(path2);
                paths.append("      maven { url '").append(path2).append("'}\n");
            }
            return "allprojects {\n  buildscript {\n    repositories {\n" + paths + "    }\n  }\n  repositories {\n" + paths + "  }\n}\n";
        }

        @NotNull
        String createAndroidStudioToolingPluginInitScriptContent() {
            List<String> paths = this.myAndroidStudioToolingPluginJars.getJarPaths();
            String string = "initscript {\n    dependencies {\n        " + this.createClassPathString(paths) + "\n    }\n}\nallprojects {\n    apply plugin: " + AndroidStudioToolingPlugin.class.getName() + "\n}\n";
            if (string == null) {
                ContentCreator.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        String createClassPathString(@NotNull List<String> paths) {
            if (paths == null) {
                ContentCreator.$$$reportNull$$$0(3);
            }
            StringBuilder classpath = new StringBuilder();
            classpath.append("classpath files([");
            int pathCount = paths.size();
            for (int i2 = 0; i2 < pathCount; ++i2) {
                String jarPath = GradleImport.escapeGroovyStringLiteral(paths.get(i2));
                classpath.append("'").append(jarPath).append("'");
                if (i2 >= pathCount - 1) continue;
                classpath.append(", ");
            }
            classpath.append("])");
            String string = classpath.toString();
            if (string == null) {
                ContentCreator.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidStudioToolingPluginJars";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repoPaths";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/common/GradleInitScripts$ContentCreator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/common/GradleInitScripts$ContentCreator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAndroidStudioToolingPluginInitScriptContent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createClassPathString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createLocalMavenRepoInitScriptContent";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createClassPathString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

