/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.attribution;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.utils.FileUtils;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\f\u0010\f\u001a\u00020\b*\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"minimumSupportedAgpVersion", "Lcom/android/ide/common/repository/GradleVersion;", "buildOutputLine", "", "getAgpAttributionFileDir", "Ljava/io/File;", "buildDir", "isAgpVersionHigherOrEqualToMinimal", "", "project", "Lcom/intellij/openapi/project/Project;", "isBuildAttributionEnabledForProject", "higherOrEqualToMinimal", "intellij.android.core"})
@JvmName(name="BuildAttributionUtil")
public final class BuildAttributionUtil {
    private static final GradleVersion minimumSupportedAgpVersion;

    public static final boolean isBuildAttributionEnabledForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = StudioFlags.BUILD_ATTRIBUTION_ENABLED.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"StudioFlags.BUILD_ATTRIBUTION_ENABLED.get()");
        return (Boolean)object != false && BuildAttributionUtil.isAgpVersionHigherOrEqualToMinimal(project);
    }

    public static final boolean isAgpVersionHigherOrEqualToMinimal(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ProjectStructure projectStructure = ProjectStructure.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)projectStructure, (String)"ProjectStructure.getInstance(project)");
            ProjectStructure.AndroidPluginVersionsInProject androidPluginVersionsInProject = projectStructure.getAndroidPluginVersions();
            Intrinsics.checkNotNullExpressionValue((Object)androidPluginVersionsInProject, (String)"ProjectStructure.getInst\u2026ct).androidPluginVersions");
            List<GradleVersion> list = androidPluginVersionsInProject.getAllVersions();
            Intrinsics.checkNotNullExpressionValue(list, (String)"ProjectStructure.getInst\u2026luginVersions.allVersions");
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    GradleVersion it = (GradleVersion)element$iv;
                    boolean bl2 = false;
                    GradleVersion gradleVersion2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"it");
                    if (BuildAttributionUtil.higherOrEqualToMinimal(gradleVersion2)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean higherOrEqualToMinimal(GradleVersion $this$higherOrEqualToMinimal) {
        return $this$higherOrEqualToMinimal.compareTo(minimumSupportedAgpVersion) >= 0;
    }

    @NotNull
    public static final File getAgpAttributionFileDir(@NotNull File buildDir) {
        Intrinsics.checkNotNullParameter((Object)buildDir, (String)"buildDir");
        File file = FileUtils.join((File)buildDir, (String[])new String[]{"build"});
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtils.join(buildDir,\u2026l.BUILD_DIR_DEFAULT_NAME)");
        return file;
    }

    @NotNull
    public static final String buildOutputLine() {
        return "Build Analyzer results available";
    }

    static {
        GradleVersion gradleVersion2 = GradleVersion.tryParseAndroidGradlePluginVersion((String)"4.0.0-beta05");
        Intrinsics.checkNotNull((Object)gradleVersion2);
        minimumSupportedAgpVersion = gradleVersion2;
    }
}

