/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectImportUtil {
    @NonNls
    private static final String ANDROID_NATURE_NAME = "com.android.ide.eclipse.adt.AndroidNature";
    private static final Logger LOG = Logger.getInstance(ProjectImportUtil.class);
    private static final String[] GRADLE_SUPPORTED_FILES = new String[]{"build.gradle", "build.gradle.kts", "settings.gradle", "settings.gradle.kts"};

    private ProjectImportUtil() {
    }

    @NotNull
    public static VirtualFile findImportTarget(@NotNull VirtualFile file) {
        VirtualFile gradleTarget;
        if (file == null) {
            ProjectImportUtil.$$$reportNull$$$0(0);
        }
        if ((gradleTarget = ProjectImportUtil.findGradleTarget(file)) != null) {
            VirtualFile virtualFile = gradleTarget;
            if (virtualFile == null) {
                ProjectImportUtil.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }
        VirtualFile eclipseTarget = ProjectImportUtil.findEclipseTarget(file);
        if (eclipseTarget != null) {
            VirtualFile virtualFile = eclipseTarget;
            if (virtualFile == null) {
                ProjectImportUtil.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            ProjectImportUtil.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile findEclipseTarget(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectImportUtil.$$$reportNull$$$0(4);
        }
        VirtualFile result2 = null;
        if (file.isDirectory()) {
            VirtualFile target = ProjectImportUtil.findMatch(file, ".project");
            if (target != null) {
                result2 = ProjectImportUtil.findImportTarget(target);
            }
        } else if (".project".equals(file.getName()) && ProjectImportUtil.hasAndroidNature(file)) {
            result2 = file;
        } else if (".classpath".equals(file.getName())) {
            result2 = ProjectImportUtil.findImportTarget(file.getParent());
        }
        return result2;
    }

    private static VirtualFile findGradleTarget(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectImportUtil.$$$reportNull$$$0(5);
        }
        return ProjectImportUtil.findMatch(file, GRADLE_SUPPORTED_FILES);
    }

    @Nullable
    private static VirtualFile findMatch(@NotNull VirtualFile location, String ... validNames) {
        if (location == null) {
            ProjectImportUtil.$$$reportNull$$$0(6);
        }
        if (validNames == null) {
            ProjectImportUtil.$$$reportNull$$$0(7);
        }
        if (location.isDirectory()) {
            for (VirtualFile child : location.getChildren()) {
                for (String name : validNames) {
                    if (!name.equals(child.getName())) continue;
                    return child;
                }
            }
        } else {
            for (String name : validNames) {
                if (!name.equals(location.getName())) continue;
                return location;
            }
        }
        return null;
    }

    private static boolean hasAndroidNature(@NotNull VirtualFile projectFile) {
        if (projectFile == null) {
            ProjectImportUtil.$$$reportNull$$$0(8);
        }
        File dotProjectFile = new File(projectFile.getPath());
        try {
            Element naturesElement = JDOMUtil.load((File)dotProjectFile).getChild("natures");
            if (naturesElement != null) {
                List naturesList = naturesElement.getChildren("nature");
                for (Element nature : naturesList) {
                    String natureName = nature.getText();
                    if (!ANDROID_NATURE_NAME.equals(natureName)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOG.info(String.format("Unable to get natures for Eclipse project file '%1$s", projectFile.getPath()), (Throwable)e);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/ProjectImportUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validNames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/ProjectImportUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findImportTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findImportTarget";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findEclipseTarget";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findGradleTarget";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMatch";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasAndroidNature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

