/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\u0012\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/project/AndroidGradleProjectOpenProcessor;", "Lcom/intellij/projectImport/ProjectOpenProcessor;", "()V", "canOpenAsExistingProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "canOpenProject", "doOpenProject", "Lcom/intellij/openapi/project/Project;", "virtualFile", "projectToClose", "forceOpenInNewFrame", "getName", "", "isStrongProjectInfoHolder", "promptToCloseIfNecessary", "project", "intellij.android.core"})
public final class AndroidGradleProjectOpenProcessor
extends ProjectOpenProcessor {
    @NotNull
    public String getName() {
        return "Android Gradle";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canOpenProject(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Registry.is((String)"android.gradle.importer.enabled")) {
            IdeInfo ideInfo = IdeInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideInfo, (String)"IdeInfo.getInstance()");
            if (!ideInfo.isAndroidStudio()) return false;
        }
        if (!GradleProjects.canImportAsGradleProject(file)) return false;
        return true;
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        VirtualFile adjustedOpenTarget;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!this.canOpenProject(virtualFile)) {
            return null;
        }
        VirtualFile virtualFile2 = ProjectImportUtil.findImportTarget(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"ProjectImportUtil.findImportTarget(virtualFile)");
        VirtualFile importTarget = virtualFile2;
        VirtualFile virtualFile3 = adjustedOpenTarget = importTarget.isDirectory() ? importTarget : importTarget.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"adjustedOpenTarget");
        if (!this.canOpenAsExistingProject(virtualFile3)) {
            if (!forceOpenInNewFrame && !this.promptToCloseIfNecessary(projectToClose)) {
                return null;
            }
            GradleProjectImporter gradleProjectImporter = GradleProjectImporter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)gradleProjectImporter, (String)"GradleProjectImporter.getInstance()");
            GradleProjectImporter gradleImporter = gradleProjectImporter;
            VirtualFile projectFolder = virtualFile.isDirectory() ? virtualFile : virtualFile.getParent();
            return gradleImporter.importProjectCore(projectFolder, null);
        }
        return ProjectManagerEx.getInstanceEx().openProject(adjustedOpenTarget.toNioPath(), new OpenProjectTask(forceOpenInNewFrame, projectToClose, false, false, null, null, false, null, null, 0, 0, false, false, false, null, false, false, null, null, null, 1048572, null));
    }

    private final boolean promptToCloseIfNecessary(Project project) {
        Project[] openProjects;
        boolean success2 = true;
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        Project[] projectArray = projectManager.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
        Project[] projectArray2 = openProjects = projectArray;
        boolean bl = false;
        Project[] projectArray3 = projectArray2;
        boolean bl2 = false;
        if (!(projectArray3.length == 0)) {
            int exitCode = ProjectUtil.confirmOpenNewProject((boolean)false);
            if (exitCode == 1) {
                Project toClose;
                Project project2 = toClose = project != null && !project.isDefault() ? project : openProjects[openProjects.length - 1];
                if (!ProjectManagerEx.getInstanceEx().closeAndDispose(toClose)) {
                    success2 = false;
                }
            } else if (exitCode != 0) {
                success2 = false;
            }
        }
        return success2;
    }

    private final boolean canOpenAsExistingProject(VirtualFile file) {
        return FileExtensions.toVirtualFile(FileExtensions.toPathString(file).resolve(".idea"), true) != null;
    }

    public boolean isStrongProjectInfoHolder() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        return application.isHeadlessEnvironment();
    }
}

