/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.GradleBuildContext;
import com.android.tools.idea.gradle.project.build.JpsBuildContext;
import com.android.tools.idea.gradle.project.build.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.annotations.NotNull;

public class AndroidGradleProjectDumbStartupActivity
implements StartupActivity.DumbAware {
    private static final String GRADLE_NOTIFICATION_GROUP_NAME = "Gradle Notification Group";

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            AndroidGradleProjectDumbStartupActivity.$$$reportNull$$$0(0);
        }
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.disableGradlePluginNotifications();
        }
        this.registerAfterTaskForAndroidGradleProjectCompiledViaJPS(project);
        this.registerAfterTaskForAndroidGradleProjectCompiledViaGradleInvocation(project);
    }

    private void registerAfterTaskForAndroidGradleProjectCompiledViaGradleInvocation(Project project) {
        GradleBuildInvoker.getInstance(project).add(result2 -> {
            if (project.isDisposed()) {
                return;
            }
            PostProjectBuildTasksExecutor.getInstance(project).onBuildCompletion(result2);
            GradleBuildContext newContext = new GradleBuildContext(result2);
            AndroidProjectBuildNotifications.getInstance(project).notifyBuildComplete(newContext);
            if (AndroidGradleProjectDumbStartupActivity.isVfsRefreshAfterBuildRequired(project)) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    FileDocumentManager.getInstance().saveAllDocuments();
                    SaveAndSyncHandler.getInstance().refreshOpenFiles();
                    VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
                });
            }
        });
    }

    private void registerAfterTaskForAndroidGradleProjectCompiledViaJPS(Project project) {
        CompilerManager.getInstance((Project)project).addAfterTask(context -> {
            if (GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
                PostProjectBuildTasksExecutor.getInstance(project).onBuildCompletion(context);
                JpsBuildContext newContext = new JpsBuildContext(context);
                AndroidProjectBuildNotifications.getInstance(project).notifyBuildComplete(newContext);
            }
            return true;
        });
    }

    private void disableGradlePluginNotifications() {
        NotificationsConfiguration.getNotificationsConfiguration().changeSettings(GRADLE_NOTIFICATION_GROUP_NAME, NotificationDisplayType.NONE, false, false);
    }

    private static boolean isVfsRefreshAfterBuildRequired(@NotNull Project project) {
        if (project == null) {
            AndroidGradleProjectDumbStartupActivity.$$$reportNull$$$0(1);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel == null || !androidModuleModel.getFeatures().isVfsRefreshAfterBuildRequired()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/android/tools/idea/gradle/project/AndroidGradleProjectDumbStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isVfsRefreshAfterBuildRequired";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

