/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.Version;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.MavenRepositories;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class LatestKnownPluginVersionProvider {
    public static final LatestKnownPluginVersionProvider INSTANCE = new LatestKnownPluginVersionProvider();

    @NotNull
    public String get() {
        FileOp fileOp = FileOpUtils.create();
        List<File> repoPaths = EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths();
        Optional<GradleCoordinate> highestValueCoordinate = repoPaths.stream().map(repoPath -> MavenRepositories.getHighestInstalledVersion((String)"com.android.tools.build", (String)"gradle", (File)repoPath, null, (boolean)true, (FileOp)fileOp)).filter(Objects::nonNull).max(GradleCoordinate.COMPARE_PLUS_HIGHER);
        if (!highestValueCoordinate.isPresent()) {
            String version2 = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            Logger logger2 = Logger.getInstance(MethodHandles.lookup().lookupClass());
            logger2.info("'gradle' plugin missing from the offline Maven repo, will use default " + version2);
            String string = version2;
            if (string == null) {
                LatestKnownPluginVersionProvider.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = highestValueCoordinate.get().getRevision();
        if (string == null) {
            LatestKnownPluginVersionProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/LatestKnownPluginVersionProvider", "get"));
    }
}

