/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModelExtensionKt;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.util.BuildFileProcessor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginVersionUpdater {
    @NotNull
    private final Project myProject;
    @NotNull
    private final TextSearch myTextSearch;

    @NotNull
    public static AndroidPluginVersionUpdater getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(0);
        }
        AndroidPluginVersionUpdater androidPluginVersionUpdater = (AndroidPluginVersionUpdater)ServiceManager.getService((Project)project, AndroidPluginVersionUpdater.class);
        if (androidPluginVersionUpdater == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(1);
        }
        return androidPluginVersionUpdater;
    }

    public AndroidPluginVersionUpdater(@NotNull Project project) {
        if (project == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(2);
        }
        this(project, new TextSearch(project));
    }

    @NonInjectable
    @VisibleForTesting
    AndroidPluginVersionUpdater(@NotNull Project project, @NotNull TextSearch textSearch) {
        if (project == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(3);
        }
        if (textSearch == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myTextSearch = textSearch;
    }

    public boolean updatePluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2) {
        UpdateResult result2;
        if (pluginVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(5);
        }
        return (result2 = this.updatePluginVersion(pluginVersion, gradleVersion2, null)).isPluginVersionUpdated() || result2.isGradleVersionUpdated();
    }

    public UpdateResult updatePluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2, @Nullable GradleVersion oldPluginVersion) {
        String msg;
        if (pluginVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(6);
        }
        UpdateResult result2 = new UpdateResult();
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)"Update plugin version", null, () -> this.updateAndroidPluginVersion(pluginVersion, gradleVersion2, oldPluginVersion, result2), (PsiFile[])new PsiFile[0]);
        if (result2.isPluginVersionUpdated() && gradleVersion2 != null) {
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)"Update Gradle wrapper version", null, () -> this.updateGradleWrapperVersion(gradleVersion2, result2), (PsiFile[])new PsiFile[0]);
        }
        Throwable pluginVersionUpdateError = result2.getPluginVersionUpdateError();
        Throwable gradleVersionUpdateError = result2.getGradleVersionUpdateError();
        if (pluginVersionUpdateError != null) {
            msg = String.format("Failed to update Android plugin to version '%1$s'", pluginVersion);
            AndroidPluginVersionUpdater.logUpdateError(msg, pluginVersionUpdateError);
        }
        if (gradleVersionUpdateError != null) {
            msg = String.format("Failed to update Gradle to version '%1$s'", gradleVersion2);
            AndroidPluginVersionUpdater.logUpdateError(msg, gradleVersionUpdateError);
        }
        if (result2.getPluginVersionUpdateError() != null) {
            this.myTextSearch.execute();
        }
        return result2;
    }

    private static void logUpdateError(@NotNull String msg, @NotNull Throwable error) {
        String cause;
        if (msg == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(7);
        }
        if (error == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(8);
        }
        if (StringUtil.isNotEmpty((String)(cause = error.getMessage()))) {
            msg = (String)msg + ": " + cause;
        }
        Logger.getInstance(AndroidPluginVersionUpdater.class).warn((String)msg);
    }

    @NotNull
    private static ThreeState isUpdatablePluginVersion(@NotNull GradleVersion pluginVersion, @NotNull ArtifactDependencyModel model2) {
        String groupId;
        String artifactId;
        if (pluginVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(9);
        }
        if (model2 == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(10);
        }
        if (!AndroidPluginInfo.isAndroidPlugin(artifactId = model2.name().forceString(), groupId = model2.group().toString())) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                AndroidPluginVersionUpdater.$$$reportNull$$$0(11);
            }
            return threeState;
        }
        String versionValue = model2.version().toString();
        ThreeState threeState = StringUtil.isEmpty((String)versionValue) || pluginVersion.compareTo(versionValue) != 0 ? ThreeState.YES : ThreeState.NO;
        if (threeState == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(12);
        }
        return threeState;
    }

    private void updateAndroidPluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2, @Nullable GradleVersion oldPluginVersion, @NotNull UpdateResult result2) {
        boolean updateModels;
        if (pluginVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(14);
        }
        ArrayList modelsToUpdate = new ArrayList();
        BuildFileProcessor.getInstance().processRecursively(this.myProject, (Processor<? super GradleBuildModel>)((Processor)buildModel -> {
            DependenciesModel dependencies2 = buildModel.buildscript().dependencies();
            for (ArtifactDependencyModel dependency : dependencies2.artifacts("classpath")) {
                ThreeState shouldUpdate = AndroidPluginVersionUpdater.isUpdatablePluginVersion(pluginVersion, dependency);
                if (shouldUpdate == ThreeState.YES) {
                    dependency.version().getResultModel().setValue((Object)pluginVersion.toString());
                    if (oldPluginVersion == null || !oldPluginVersion.isAtLeast(3, 0, 0)) {
                        if (gradleVersion2 != null) {
                            RepositoriesModelExtensionKt.addGoogleMavenRepository(buildModel.buildscript().repositories(), gradleVersion2);
                        } else {
                            RepositoriesModelExtensionKt.addGoogleMavenRepository(buildModel.buildscript().repositories(), this.myProject);
                        }
                    }
                    modelsToUpdate.add(buildModel);
                    continue;
                }
                if (shouldUpdate != ThreeState.NO) continue;
                break;
            }
            return true;
        }));
        boolean bl = updateModels = !modelsToUpdate.isEmpty();
        if (updateModels) {
            try {
                for (GradleBuildModel buildModel2 : modelsToUpdate) {
                    buildModel2.applyChanges();
                }
                result2.pluginVersionUpdated();
            }
            catch (Throwable e) {
                result2.setPluginVersionUpdateError(e);
            }
        } else {
            result2.setPluginVersionUpdateError(new RuntimeException("Failed to find gradle build models to update."));
        }
    }

    private void updateGradleWrapperVersion(@NotNull GradleVersion gradleVersion2, @NotNull UpdateResult result2) {
        String basePath;
        if (gradleVersion2 == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(15);
        }
        if (result2 == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(16);
        }
        if ((basePath = this.myProject.getBasePath()) == null) {
            return;
        }
        ArrayList<File> projectRootFolders = new ArrayList<File>();
        projectRootFolders.add(new File(FileUtils.toSystemDependentPath((String)basePath)));
        projectRootFolders.addAll(BuildFileProcessor.getCompositeBuildFolderPaths(this.myProject));
        for (File rootFolder : projectRootFolders) {
            if (rootFolder == null) continue;
            try {
                File wrapperPropertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(rootFolder);
                GradleWrapper gradleWrapper = GradleWrapper.get(wrapperPropertiesFilePath);
                String current = gradleWrapper.getGradleVersion();
                GradleVersion parsedCurrent = null;
                if (current != null) {
                    parsedCurrent = GradleVersion.tryParse((String)current);
                }
                if (parsedCurrent == null || GradleUtil.isSupportedGradleVersion(parsedCurrent)) continue;
                gradleWrapper.updateDistributionUrl(gradleVersion2.toString());
                result2.gradleVersionUpdated();
            }
            catch (Throwable e) {
                result2.setGradleVersionUpdateError(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textSearch";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginVersion";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "isUpdatablePluginVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 11: 
            case 12: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updatePluginVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logUpdateError";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatablePluginVersion";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateAndroidPluginVersion";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateGradleWrapperVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class TextSearch {
        @NotNull
        private final Project myProject;

        TextSearch(@NotNull Project project) {
            if (project == null) {
                TextSearch.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        void execute() {
            String msg = "Failed to update the version of the Android Gradle plugin.\n\nPlease click 'OK' to perform a textual search and then update the build files manually.";
            ApplicationManager.getApplication().invokeLater(() -> {
                Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
                String textToFind = "com.android.tools.build:gradle";
                SearchInBuildFilesHyperlink.searchInBuildFiles(textToFind, this.myProject);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater$TextSearch", "<init>"));
        }
    }

    public static class UpdateResult {
        @Nullable
        private Throwable myPluginVersionUpdateError;
        @Nullable
        private Throwable myGradleVersionUpdateError;
        private boolean myPluginVersionUpdated;
        private boolean myGradleVersionUpdated;

        @VisibleForTesting
        public UpdateResult() {
        }

        @Nullable
        public Throwable getPluginVersionUpdateError() {
            return this.myPluginVersionUpdateError;
        }

        void setPluginVersionUpdateError(@NotNull Throwable error) {
            if (error == null) {
                UpdateResult.$$$reportNull$$$0(0);
            }
            this.myPluginVersionUpdateError = error;
        }

        @Nullable
        public Throwable getGradleVersionUpdateError() {
            return this.myGradleVersionUpdateError;
        }

        void setGradleVersionUpdateError(@NotNull Throwable error) {
            if (error == null) {
                UpdateResult.$$$reportNull$$$0(1);
            }
            this.myGradleVersionUpdateError = error;
        }

        public boolean isPluginVersionUpdated() {
            return this.myPluginVersionUpdated;
        }

        void pluginVersionUpdated() {
            this.myPluginVersionUpdated = true;
        }

        public boolean isGradleVersionUpdated() {
            return this.myGradleVersionUpdated;
        }

        void gradleVersionUpdated() {
            this.myGradleVersionUpdated = true;
        }

        public boolean versionUpdateSuccess() {
            return (this.myPluginVersionUpdated || this.myGradleVersionUpdated) && this.myPluginVersionUpdateError == null && this.myGradleVersionUpdateError == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "error";
            objectArray2[1] = "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater$UpdateResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setPluginVersionUpdateError";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGradleVersionUpdateError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

