/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkExternalCppProjectDialog
extends DialogWrapper {
    private static final String CMAKE_PATH_DESCRIPTION = "Select the main CMakeLists.txt file of a CMake project";
    private static final String NDK_BUILD_PATH_DESCRIPTION = "Select the main .mk file of the NDK project (e.g. Android.mk)";
    @NotNull
    private final Module myModule;
    private JPanel myPanel;
    private JComboBox<BuildSystem> myBuildSystemCombo;
    private JXLabel myProjectPathDescriptionLabel;
    private TextFieldWithBrowseButton myProjectPathTextField;
    private JXLabel myProjectPathResultLabel;

    public LinkExternalCppProjectDialog(@NotNull Module module) {
        if (module == null) {
            LinkExternalCppProjectDialog.$$$reportNull$$$0(0);
        }
        super(false);
        this.myModule = module;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle("Link C++ Project with Gradle");
        this.myBuildSystemCombo.addItem(BuildSystem.CMAKE);
        this.myBuildSystemCombo.addItem(BuildSystem.NDK_BUILD);
        this.myBuildSystemCombo.setSelectedItem((Object)BuildSystem.CMAKE);
        this.myProjectPathDescriptionLabel.setText(CMAKE_PATH_DESCRIPTION);
        this.myBuildSystemCombo.addItemListener(e -> {
            if (this.myBuildSystemCombo.getSelectedItem() == BuildSystem.CMAKE) {
                this.myProjectPathDescriptionLabel.setText(CMAKE_PATH_DESCRIPTION);
            } else {
                this.myProjectPathDescriptionLabel.setText(NDK_BUILD_PATH_DESCRIPTION);
            }
        });
        this.getOKAction().setEnabled(false);
        this.myProjectPathTextField.setTextFieldPreferredWidth(50);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, false){

            public void validateSelectedFiles(@NotNull VirtualFile[] files2) throws Exception {
                if (files2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VirtualFile virtualFile : files2) {
                    String errorMessage = LinkExternalCppProjectDialog.this.validateProjectFilePath(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
                    if (errorMessage == null) continue;
                    throw new IllegalArgumentException(errorMessage);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/gradle/actions/LinkExternalCppProjectDialog$1", "validateSelectedFiles"));
            }
        };
        descriptor2.setTitle("Choose C++ Project Location");
        this.myProjectPathTextField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener("Select C++ Project Location", null, (ComponentWithBrowseButton)this.myProjectPathTextField, null, descriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        this.myProjectPathResultLabel.setVisible(false);
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String projectPath = FileUtil.toSystemIndependentName((String)this.myProjectPathTextField.getText().trim());
        if (Strings.isNullOrEmpty((String)projectPath)) {
            this.getOKAction().setEnabled(false);
            this.setProjectPathResultLabelVisible(false);
            return null;
        }
        String errorMessage = this.validateProjectFilePath(new File(projectPath));
        if (errorMessage != null) {
            this.setProjectPathResultLabelVisible(false);
            return new ValidationInfo(errorMessage, (JComponent)this.myProjectPathTextField.getTextField());
        }
        String relativePath = AndroidRootUtil.getPathRelativeToModuleDir(this.myModule, projectPath);
        assert (relativePath != null);
        this.myProjectPathResultLabel.setText("<html>Path to be saved into the build.gradle file:<br><b>\"" + relativePath + "\"</b></html>");
        this.getOKAction().setEnabled(true);
        this.setProjectPathResultLabelVisible(true);
        return null;
    }

    private void setProjectPathResultLabelVisible(boolean newVisible) {
        boolean oldVisible = this.myProjectPathResultLabel.isVisible();
        if (oldVisible != newVisible) {
            this.myProjectPathResultLabel.setVisible(newVisible);
            this.myPanel.doLayout();
            this.myPanel.revalidate();
            this.myPanel.repaint();
        }
    }

    @Nullable
    private String validateProjectFilePath(@NotNull File file) {
        if (file == null) {
            LinkExternalCppProjectDialog.$$$reportNull$$$0(1);
        }
        if (!file.exists()) {
            return "The selected file does not exist";
        }
        if (this.myBuildSystemCombo.getSelectedItem() == BuildSystem.CMAKE && !file.getName().equals("CMakeLists.txt")) {
            return "Invalid file name. Expected: CMakeLists.txt";
        }
        if (this.myBuildSystemCombo.getSelectedItem() == BuildSystem.NDK_BUILD && !FileUtilRt.extensionEquals((String)file.getPath(), (String)"mk")) {
            return "Invalid file extension. Expected: .mk";
        }
        return null;
    }

    protected void doOKAction() {
        String projectPath = FileUtil.toSystemIndependentName((String)this.myProjectPathTextField.getText().trim());
        String relativePath = AndroidRootUtil.getPathRelativeToModuleDir(this.myModule, projectPath);
        assert (relativePath != null);
        final GradleBuildModel buildModel = GradleBuildModel.get((Module)this.myModule);
        assert (buildModel != null);
        AndroidModel android = buildModel.android();
        if (this.myBuildSystemCombo.getSelectedItem() == BuildSystem.CMAKE) {
            android.externalNativeBuild().cmake().path().setValue((Object)relativePath);
        } else {
            android.externalNativeBuild().ndkBuild().path().setValue((Object)relativePath);
        }
        Project project = this.myModule.getProject();
        new WriteCommandAction(project, "Link C++ Project with Gradle", new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                buildModel.applyChanges();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/actions/LinkExternalCppProjectDialog$2", "run"));
            }
        }.execute();
        GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_CPP_EXTERNAL_PROJECT_LINKED);
        super.doOKAction();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/actions/LinkExternalCppProjectDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "validateProjectFilePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JXLabel jXLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JXLabel jXLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Build System");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myBuildSystemCombo = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectPathDescriptionLabel = jXLabel2 = new JXLabel();
        jXLabel2.setLineWrap(true);
        jXLabel2.setText("");
        jPanel.add((Component)jXLabel2, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 7, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Project Path");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myProjectPathResultLabel = jXLabel = new JXLabel();
        jXLabel.setLineWrap(true);
        jXLabel.setText("");
        jPanel.add((Component)jXLabel, new GridConstraints(3, 0, 1, 3, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static enum BuildSystem {
        CMAKE("CMake"),
        NDK_BUILD("ndk-build");

        private String myText;

        private BuildSystem(String text) {
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }
    }
}

